/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.ui;

import com.kingdee.bos.ctrl.print.ConfigManager;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.ui.AbstractConfigUI;
import com.kingdee.bos.ctrl.print.config.ui.AbstractStartLocationModel;
import com.kingdee.bos.ctrl.print.config.ui.SunPrintConfigDialog;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.Map;
import javax.print.PrintService;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PaperStartLocationUI
extends AbstractConfigUI {
    private PrintService[] services;
    private ConfigManager printermanager;
    private PageStartLocationPanel ps;
    private int defaultServiceIndex;
    private static final int PAGE_W = 410;
    private static final int GAP = 5;

    @Override
    public void init(PrintJobConfig manager, String uniqueName) {
        this.setManager(manager.getPrinter().getPrintConfig());
        super.init(manager, uniqueName);
        this.initPanel();
    }

    private static String getMsg(String key) {
        return Resources.getMsg(key);
    }

    private void setManager(ConfigManager manager) {
        this.printermanager = manager;
        this.defaultServiceIndex = manager.getModel().getPrintServiceIndex();
        this.config = manager.getStartLocationModel();
    }

    public void initPanel() {
        this.services = this.printermanager.getModel().getPrintServices();
        this.setLayout(null);
        this.ps = new PageStartLocationPanel();
        this.add((Component)((Object)this.ps));
        int x = 5;
        int y = 5;
        int h = this.ps.getPreferredSize().height;
        int w = 400;
        this.ps.setBounds(x, y, w, h);
        JTextArea lblRangeTo = new JTextArea(2, 17);
        lblRangeTo.setEditable(false);
        lblRangeTo.setText(((AbstractStartLocationModel)this.config).getUIExplain());
        lblRangeTo.setOpaque(false);
        lblRangeTo.setLineWrap(true);
        lblRangeTo.setWrapStyleWord(true);
        lblRangeTo.setBorder(null);
        this.add(lblRangeTo);
        lblRangeTo.setBounds(x + 5, y + h + 10, w, 200);
        this.setPreferredSize(new Dimension(425, 350));
    }

    @Override
    public void approve() {
        AbstractStartLocationModel saver = (AbstractStartLocationModel)this.config;
        saver.save();
    }

    @Override
    public IConfigModel createConfigModel() {
        return null;
    }

    @Override
    public void updateConfigToUI() {
        AbstractStartLocationModel model = (AbstractStartLocationModel)this.config;
        Map ac = model.getStartContent();
        for (Object key : ac.keySet()) {
            float[] values = new float[]{0.0f, 0.0f};
            if (ac.get(key) != null) {
                values = (float[])ac.get(key);
            }
            model.setStartValues(key, values);
        }
        this.ps.updateInfo();
    }

    private class PageStartLocationPanel
    extends KDPanel
    implements ItemListener,
    FocusListener,
    ChangeListener {
        private final String strTitle = PaperStartLocationUI.access$000("border.startLocationTitle");
        private KDFormattedTextField ftfX;
        private KDFormattedTextField ftfY;
        private KDComboBox cbName;

        public PageStartLocationPanel() {
            this.setOpaque(false);
            this.setLayout(null);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            String strX = PaperStartLocationUI.getMsg("label.horizontal");
            String strY = PaperStartLocationUI.getMsg("label.vertical");
            Object[] psnames = new String[PaperStartLocationUI.this.services.length];
            for (int i = 0; i < psnames.length; ++i) {
                psnames[i] = PaperStartLocationUI.this.services[i].getName();
            }
            this.cbName = new KDComboBox(psnames);
            if (psnames.length > PaperStartLocationUI.this.defaultServiceIndex) {
                this.cbName.setSelectedIndex(PaperStartLocationUI.this.defaultServiceIndex);
            }
            this.cbName.addItemListener((ItemListener)this);
            String str = PaperStartLocationUI.getMsg("label.printer");
            SunPrintConfigDialog.LinedLabel l1 = SunPrintConfigDialog.L(str, (JComponent)this.cbName);
            this.ftfX = new KDFormattedTextField();
            this.ftfX.setDataType(4);
            this.ftfX.setNumberValue((Number)new Float(0.0f));
            this.ftfX.setPrecision(1);
            this.ftfX.addFocusListener((FocusListener)this);
            this.ftfY = new KDFormattedTextField();
            this.ftfY.setDataType(4);
            this.ftfY.setNumberValue((Number)new Float(0.0f));
            this.ftfY.setPrecision(1);
            this.ftfY.addFocusListener((FocusListener)this);
            SunPrintConfigDialog.LinedLabel llx = SunPrintConfigDialog.L(strX, (JComponent)this.ftfX);
            SunPrintConfigDialog.LinedLabel lly = SunPrintConfigDialog.L(strY, (JComponent)this.ftfY);
            this.add((Component)((Object)l1));
            this.add((Component)((Object)llx));
            KDLabel label1 = new KDLabel("(" + PaperStartLocationUI.getMsg("label.unit_mm") + ")");
            this.add((Component)label1);
            this.add((Component)((Object)lly));
            KDLabel label2 = new KDLabel("(" + PaperStartLocationUI.getMsg("label.unit_mm") + ")");
            this.add((Component)label2);
            l1.setBounds(10, 25, 350, 20);
            llx.setBounds(10, 50, 160, 20);
            label1.setBounds(180, 50, 150, 20);
            lly.setBounds(10, 75, 160, 20);
            label2.setBounds(180, 75, 150, 20);
            this.setPreferredSize(new Dimension(410, 120));
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.save();
        }

        private void save() {
            String item = (String)this.cbName.getSelectedItem();
            if (item != null) {
                try {
                    this.ftfX.commitEdit();
                    this.ftfY.commitEdit();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                float xValue = this.ftfX.getNumberValue().floatValue();
                float yValue = this.ftfY.getNumberValue().floatValue();
                float[] values = new float[]{xValue, yValue};
                ((AbstractStartLocationModel)PaperStartLocationUI.this.config).setStartValues(item, values);
            }
        }

        public void updateInfo() {
            String item = (String)this.cbName.getSelectedItem();
            if (item != null) {
                float[] values = ((AbstractStartLocationModel)PaperStartLocationUI.this.config).getStartValues(item);
                if (values == null) {
                    values = new float[]{0.0f, 0.0f};
                    ((AbstractStartLocationModel)PaperStartLocationUI.this.config).setStartValues(item, values);
                }
                this.ftfX.setValue((Object)new Float(values[0]));
                this.ftfY.setValue((Object)new Float(values[1]));
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.updateInfo();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.save();
        }
    }
}

