/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.io.HtmlExport;
import com.kingdee.bos.ctrl.print.io.JpgExport;
import com.kingdee.bos.ctrl.print.io.KDPException;
import com.kingdee.bos.ctrl.print.io.KDPFile;
import com.kingdee.bos.ctrl.print.io.PdfExport;
import com.kingdee.bos.ctrl.print.io.PdfExportOS;
import com.kingdee.bos.ctrl.print.io.XlsExport;
import com.kingdee.bos.ctrl.print.io.XlsExport2;
import com.kingdee.bos.ctrl.print.io.XlsExport2OS;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class IOManager {
    private KDPrinter printer;

    public IOManager(KDPrinter printer) {
        this.printer = printer;
    }

    public void exportToKDP(boolean isDirect) throws KDPException, IOException {
        KDFileChooser chooser = new KDFileChooser();
        int result = chooser.showSaveDialog(this.printer.getParentWindow());
        if (result == 0) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            this.exportToKDP(filename, isDirect);
        }
    }

    public void exportToKDP() throws KDPException, IOException {
        this.exportToKDP(false);
    }

    public void exportToKDP(String filePath, boolean isDirect) throws KDPException, IOException {
        KDPFile kdpFile = new KDPFile(filePath);
        if (!isDirect) {
            this.printer.preParePrint();
        }
        kdpFile.save(this.printer);
    }

    public void exportToKDP(String filePath) throws KDPException, IOException {
        this.exportToKDP(filePath, false);
    }

    public void importFromKDP() throws KDPException, IOException {
        KDFileChooser chooser = new KDFileChooser();
        int result = chooser.showOpenDialog(this.printer.getParentWindow());
        if (result == 0) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            this.importFromKDP(filename);
        }
    }

    public void importFromKDP(String filePath) throws KDPException, IOException {
        KDPFile kdpFile = new KDPFile(filePath);
        kdpFile.load(this.printer);
    }

    public void exportToXls() {
        KDFileChooser chooser = new KDFileChooser();
        int result = chooser.showOpenDialog(this.printer.getParentWindow());
        if (result == 0) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            this.exportToXls(filename);
        }
    }

    public void exportToXls(String filePath) {
        this.printer.preParePrint();
        XlsExport export = new XlsExport();
        export.export(filePath, this.printer);
    }

    public void exportToHtml() {
        KDFileChooser chooser = new KDFileChooser();
        int result = chooser.showOpenDialog(this.printer.getParentWindow());
        if (result == 0) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            this.exportToHtml(filename);
        }
    }

    public void exportToHtml(String filePath) {
        this.printer.preParePrint();
        HtmlExport export = new HtmlExport();
        export.export(filePath, this.printer);
    }

    public List<BufferedImage> exportToJpg() {
        this.printer.preParePrint();
        JpgExport export = new JpgExport();
        return export.export(this.printer);
    }

    public void exportToPdf(String filePath) {
        this.printer.preParePrint();
        PdfExport export = new PdfExport();
        export.export(filePath, this.printer);
    }

    public void exportToPdf(OutputStream os) {
        this.printer.preParePrint();
        PdfExport export = new PdfExport(os);
        export.export("", this.printer);
    }

    public ArrayList<OutputStream> exportToPdf(ArrayList<OutputStream> list) {
        this.printer.preParePrint();
        PdfExportOS export = new PdfExportOS(list);
        return export.export("", this.printer);
    }

    public void exportToPdf() {
        KDFileChooser chooser = new KDFileChooser();
        int result = chooser.showOpenDialog(this.printer.getParentWindow());
        if (result == 0) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            this.exportToPdf(filename);
        }
    }

    public void exportToXls2(String filepath, Component owner) {
        this.printer.preParePrint();
        XlsExport2 export = new XlsExport2(owner);
        export.export(filepath, this.printer);
    }

    public void exportToXls2(OutputStream os) {
        this.printer.preParePrint();
        XlsExport2OS export = new XlsExport2OS(os);
        export.export("", this.printer);
    }
}

