/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.control.ControlPrint;
import com.kingdee.bos.ctrl.print.io.KDFontMapper;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class JpgExport {
    KDPrinter printer;
    public List<BufferedImage> imgList;
    public static KDFontMapper DEFAULT_FONTMAPPER = new KDFontMapper();

    public List<BufferedImage> export(KDPrinter printer) {
        Paper paper;
        this.imgList = new ArrayList<BufferedImage>();
        this.printer = printer;
        printer.getPrintJob().getPageCount();
        this.begin();
        ControlPrint control = this.printer.getControlPrint();
        int index = 0;
        while ((paper = control.getPaper(index)) != null) {
            this.exportPaper(paper);
            ++index;
        }
        this.end();
        return this.imgList;
    }

    protected void begin() {
    }

    protected void exportPaper(Paper paper) {
        int dpi = Integer.parseInt(System.getProperty("com.kingdee.bos.ctrl.print.io.JpgExport.dpi", "300"));
        int width = (int)paper.getWidth();
        int height = (int)paper.getHeight();
        int imageWidth = (int)Math.round((double)width / (double)KDToolkit.getCurrentDpi() * (double)dpi);
        int imageHeight = (int)Math.round((double)height / (double)KDToolkit.getCurrentDpi() * (double)dpi);
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 10);
        Graphics2D graphic = image.createGraphics();
        double scale = (double)dpi / (double)KDToolkit.getCurrentDpi();
        graphic.scale(scale, scale);
        graphic.setClip(0, 0, width, height);
        graphic.setColor(Color.white);
        graphic.fillRect(0, 0, width, height);
        paper.painting(graphic, paper.getPainterInfo());
        graphic.dispose();
        this.imgList.add(image);
    }

    protected void end() {
    }
}

