/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class KDFontMapper
implements FontMapper {
    private HashMap aliases = new HashMap();
    private HashMap mapper = new HashMap();
    public BaseFont defaultFont;

    public KDFontMapper() {
        String userHome;
        String windir;
        String easHome;
        String prop = System.getProperty("eas.properties.dir");
        if (prop != null) {
            this.insertDirectory(prop);
        }
        if ((easHome = System.getProperty("EAS_HOME")) != null) {
            this.insertDirectory(easHome + "/client/bin");
        }
        if ((windir = System.getenv("windir")) != null && !windir.isEmpty()) {
            windir = windir.endsWith("\\") || windir.endsWith("/") ? windir : windir + File.separator;
            this.insertDirectory(windir + "Fonts");
        }
        if ((userHome = System.getProperty("user.home")) != null && !userHome.isEmpty()) {
            userHome = userHome.endsWith("\\") || userHome.endsWith("/") ? userHome : userHome + File.separator;
            this.insertDirectory(userHome + ".fonts");
        }
        this.insertDirectory("/usr/share/fonts");
        this.insertDirectory("/usr/local/share/fonts");
        this.insertDirectory("/usr/X/lib/X11/fonts/TrueType");
        this.insertDirectory("/usr/openwin/lib/X11/fonts/TrueType");
        this.insertDirectory("/usr/share/fonts/default/TrueType");
        this.insertDirectory("/usr/X11R6/lib/X11/fonts/ttf");
        this.insertDirectory("/usr/lpp/X11/lib/X11/fonts");
        this.insertDirectory("/usr/lib/X11/fonts");
        this.insertDirectory("/usr/lpp/X11/lib/X11");
        this.insertDirectory("/usr/X11R6/lib/X11/fonts");
        this.insertDirectory("/System/Library/Fonts");
        this.insertDirectory("/Library/Fonts");
        try {
            BaseFontParameters p = this.getBaseFontParameters("SimSun");
            this.defaultFont = BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, (byte[])p.ttfAfm, (byte[])p.pfb);
        }
        catch (DocumentException documentException) {
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public BaseFont awtToPdf(Font font) {
        try {
            int style;
            boolean styled = false;
            BaseFontParameters p = this.getBaseFontParameters(font.getFontName());
            if (p == null && (style = font.getStyle()) != 0) {
                String styledName = font.getFontName();
                if ((style & 1) != 0) {
                    styledName = String.valueOf(String.valueOf(styledName)).concat(" Bold");
                }
                if ((style & 2) != 0) {
                    styledName = String.valueOf(String.valueOf(styledName)).concat(" Italic");
                }
                p = this.getBaseFontParameters(styledName);
                styled = true;
            }
            if (p == null) {
                if (this.defaultFont != null) {
                    BaseFont basefont = this.defaultFont;
                    return basefont;
                }
                throw new ExceptionConverter(new Exception(String.valueOf(String.valueOf(new StringBuffer("Can't find any font named [").append(font.getFontName()).append(" ] installed in your system, default font is not Available too.")))));
            }
            BaseFont base = BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, (byte[])p.ttfAfm, (byte[])p.pfb);
            BaseFont basefont1 = BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, (byte[])p.ttfAfm, (byte[])p.pfb);
            return basefont1;
        }
        catch (Exception e) {
            if (this.defaultFont != null) {
                return this.defaultFont;
            }
            throw new ExceptionConverter(e);
        }
    }

    public Font pdfToAwt(BaseFont font, int size) {
        String finalName;
        String[][] names = font.getFullFontName();
        if (names.length == 1) {
            return new Font(names[0][3], 0, size);
        }
        String name10 = null;
        String name3x = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (name[0].equals("1") && name[1].equals("0")) {
                name10 = name[3];
                continue;
            }
            if (!name[2].equals("1033")) continue;
            name3x = name[3];
            break;
        }
        if ((finalName = name3x) == null) {
            finalName = name10;
        }
        if (finalName == null) {
            finalName = names[0][3];
        }
        return new Font(finalName, 0, size);
    }

    public void putName(String awtName, BaseFontParameters parameters) {
        this.mapper.put(awtName, parameters);
    }

    public void putAlias(String alias, String awtName) {
        this.aliases.put(alias, awtName);
    }

    public BaseFontParameters getBaseFontParameters(String name) {
        String alias = (String)this.aliases.get(name);
        if (alias == null) {
            return (BaseFontParameters)this.mapper.get(name);
        }
        BaseFontParameters p = (BaseFontParameters)this.mapper.get(alias);
        if (p == null) {
            return (BaseFontParameters)this.mapper.get(name);
        }
        return p;
    }

    protected void insertNames(String[][] names, String path) {
        String main = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (!name[2].equals("1033")) continue;
            main = name[3];
            break;
        }
        if (main == null) {
            main = names[0][3];
        }
        BaseFontParameters p = new BaseFontParameters(path);
        this.mapper.put(main, p);
        for (int k = 0; k < names.length; ++k) {
            this.aliases.put(names[k][3], main);
        }
    }

    public int insertDirectory(String dir) {
        File file = new File(dir);
        if (!file.exists() || !file.isDirectory()) {
            return 0;
        }
        File[] files = file.listFiles();
        int count = 0;
        for (int k = 0; k < files.length; ++k) {
            file = files[k];
            if (file.isDirectory()) {
                this.insertDirectory(file.getPath());
                continue;
            }
            String name = file.getPath().toLowerCase();
            try {
                if (name.endsWith(".ttf") || name.endsWith(".otf") || name.endsWith(".afm")) {
                    String[][] names = BaseFont.getFullFontName((String)file.getPath(), (String)"Cp1252", null);
                    this.insertNames(names, file.getPath());
                    ++count;
                    continue;
                }
                if (!name.endsWith(".ttc")) continue;
                String[] ttcs = BaseFont.enumerateTTCNames((String)file.getPath());
                for (int j = 0; j < ttcs.length; ++j) {
                    String nt = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(file.getPath()))).append(",").append(j)));
                    String[][] names = BaseFont.getFullFontName((String)nt, (String)"Cp1252", null);
                    this.insertNames(names, nt);
                }
                ++count;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count;
    }

    public HashMap getMapper() {
        return this.mapper;
    }

    public HashMap getAliases() {
        return this.aliases;
    }

    public static class BaseFontParameters {
        public String fontName;
        public String encoding;
        public boolean embedded;
        public boolean cached;
        public byte[] ttfAfm;
        public byte[] pfb;

        public BaseFontParameters(String fontName) {
            this.fontName = fontName;
            this.encoding = "Identity-H";
            this.embedded = true;
            this.cached = true;
        }
    }
}

