/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.preview;

import com.kingdee.bos.ctrl.print.KDPConstant;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.attribute.PageIntervalInfo;
import com.kingdee.bos.ctrl.print.control.CtrlGraphics;
import com.kingdee.bos.ctrl.print.preview.EditPopupMenu;
import com.kingdee.bos.ctrl.print.preview.PreviewBody;
import com.kingdee.bos.ctrl.print.printjob.table.TableColumnsInfo;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.ImageCell;
import com.kingdee.bos.ctrl.print.ui.component.LabelCell;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.PainterCell;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;

public class OnePaperUI
extends KDPanel {
    private static final long serialVersionUID = -654155712125327801L;
    public static int VIEW = 0;
    public static int IntervalSetting = 1;
    public static int MOVECELL = 2;
    public static int RESIZECELL = 3;
    private int drawFlag = 0;
    public static int MIN_RESIZE = 3;
    public static int RESIZE_CORNER_RECT = 4;
    private int currentDragCorner = -1;
    private double scale = 1.0;
    private Paper paper;
    private MouseListener mouseHandler;
    private MouseMotionListener mouseMotionHandler;
    private int lineIndex = -1;
    private KDPrinter printer;
    private PreviewBody previewUI;
    private Rectangle selectRect;
    private Point movePressPoint;
    private Rectangle resizeRect;
    Rectangle[] columnResetRects;
    int lastMousX = 0;
    Rectangle lastLine = new Rectangle();

    public OnePaperUI(KDPrinter printer, PreviewBody previewUI) {
        this.previewUI = previewUI;
        this.setBackground(Color.WHITE);
        this.setLayout(null);
        MatteBorder border1 = BorderFactory.createMatteBorder(1, 1, 3, 3, Color.DARK_GRAY);
        this.setBorder(border1);
        this.installListeners();
        this.printer = printer;
    }

    public PreviewBody getPreviewUI() {
        return this.previewUI;
    }

    public void paintComponent(Graphics g) {
        if (this.paper == null) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        super.paintComponent(g);
        this.paper.setEditable(this.previewUI.getStatus() == 1);
        Graphics2D sg = (Graphics2D)g;
        sg.scale(this.getScale(), this.getScale());
        this.paper.getPainterInfo().setPreviewing(true);
        this.paper.painting(sg, this.paper.getPainterInfo());
        this.paintPageMarginAdjust(g, this.paper);
        this.paintSelectMargin(g);
        sg.scale(1.0 / this.getScale(), 1.0 / this.getScale());
    }

    private void paintSelectMargin(Graphics g) {
        if (this.selectRect != null && this.previewUI.getStatus() == 1) {
            g.setColor(Color.BLUE);
            g.drawRect(this.selectRect.x, this.selectRect.y, this.selectRect.width, this.selectRect.height);
            Rectangle[] rects = this.getSelectRectCornerRects();
            for (int i = 0; i < rects.length; ++i) {
                g.fillRect(rects[i].x, rects[i].y, rects[i].width, rects[i].height);
            }
        }
    }

    private Rectangle[] getSelectRectCornerRects() {
        Rectangle[] cornerRects = new Rectangle[4];
        int x = this.selectRect.x;
        int y = this.selectRect.y;
        int width = RESIZE_CORNER_RECT + 1;
        int height = RESIZE_CORNER_RECT + 1;
        cornerRects[0] = new Rectangle(x, y, width, height);
        x = this.selectRect.x + this.selectRect.width - RESIZE_CORNER_RECT;
        y = this.selectRect.y;
        cornerRects[1] = new Rectangle(x, y, width, height);
        x = this.selectRect.x;
        y = this.selectRect.y + this.selectRect.height - RESIZE_CORNER_RECT;
        cornerRects[2] = new Rectangle(x, y, width, height);
        x = this.selectRect.x + this.selectRect.width - RESIZE_CORNER_RECT;
        y = this.selectRect.y + this.selectRect.height - RESIZE_CORNER_RECT;
        cornerRects[3] = new Rectangle(x, y, width, height);
        return cornerRects;
    }

    private void paintPageMarginAdjust(Graphics g, Paper paper) {
        if (this.drawFlag == IntervalSetting) {
            PainterInfo painterInfo = paper.getPainterInfo();
            PrintRequestAttributeSet set = painterInfo.getAttributeManager().getPrintRequestAttributeSet();
            Rectangle headerBounds = KDPrinterUtils.getPageHeadBounds(set, KDPrinterUtils.SCREEN_RESOLUTION);
            Rectangle footerBounds = KDPrinterUtils.getPageFootBounds(set, KDPrinterUtils.SCREEN_RESOLUTION);
            Rectangle pageBounds = KDPrinterUtils.getPageBounds(set, KDPrinterUtils.SCREEN_RESOLUTION);
            Graphics isg = CtrlGraphics.createPreviewLineGraphics(g);
            isg.setColor(KDPConstant.PREVIEW_PAGEMARGIN_COLOR);
            double w = paper.getPainterSize().getWidth() - 1.0;
            double h = paper.getPainterSize().getHeight() - 1.0;
            isg.drawLine(0, headerBounds.y, (int)w, headerBounds.y);
            isg.drawLine(0, pageBounds.y, (int)w, pageBounds.y);
            isg.drawLine(0, pageBounds.y + (int)pageBounds.getHeight(), (int)w, pageBounds.y + (int)pageBounds.getHeight());
            isg.drawLine(pageBounds.x, 0, pageBounds.x, (int)h);
            isg.drawLine((int)((double)pageBounds.x + pageBounds.getWidth()), 0, (int)((double)pageBounds.x + pageBounds.getWidth()), (int)h);
            isg.drawLine(0, (int)((double)footerBounds.y + footerBounds.getHeight()), (int)w, (int)((double)footerBounds.y + footerBounds.getHeight()));
            Object userObj = this.paper.getBody().getUserObject();
            if (userObj != null && userObj instanceof TableColumnsInfo) {
                TableColumnsInfo columnsInfo = (TableColumnsInfo)userObj;
                float startPosition = columnsInfo.getStartPosition();
                int[] columnsWidth = columnsInfo.getAllColumnWidth();
                g.setColor(Color.BLACK);
                float columnY = this.paper.getBody().getX() + startPosition;
                this.columnResetRects = new Rectangle[columnsWidth.length];
                for (int i = 0; i < columnsWidth.length; ++i) {
                    if (columnsWidth[i] > 0) {
                        columnY += (float)columnsWidth[i] * (float)painterInfo.getScaleX();
                    }
                    g.fillRect((int)columnY - 3, 0, 6, 5);
                    g.drawLine((int)columnY, 5, (int)columnY, 9);
                    this.columnResetRects[i] = new Rectangle((int)columnY - 3, 0, 6, 9);
                }
            }
            isg.dispose();
        }
    }

    void setInterval(int isInterval) {
        this.drawFlag = isInterval;
        this.repaint();
    }

    void changeInterval() {
        if (this.drawFlag == IntervalSetting) {
            this.setInterval(0);
        } else {
            this.setInterval(IntervalSetting);
        }
        if (this.drawFlag == IntervalSetting) {
            this.previewUI.setViewStatus(2);
        } else {
            this.previewUI.setViewStatus(0);
        }
        this.paper.getPainterInfo().getAttributeManager().getPageSetupModel().getUnPrintableArea(this.printer.getPrintService());
    }

    public void setPaper(Paper paper) {
        this.paper = paper;
        if (paper != null) {
            Dimension2D d = paper.getPainterSize();
            double w = this.scale * d.getWidth();
            double h = this.scale * d.getHeight();
            this.setPreferredSize(new Dimension((int)w, (int)h));
            this.setSize((int)w, (int)h);
        }
        this.validate();
        this.invalidate();
        this.repaint();
    }

    private void mouseMovingOnPaper(MouseEvent e) {
        this.lineIndex = -1;
        int x = (int)((double)e.getX() / this.scale);
        int y = (int)((double)e.getY() / this.scale);
        Rectangle[] rect = this.getRects(8);
        for (int i = 0; i < 6; ++i) {
            if (!rect[i].contains(x, y)) continue;
            this.lineIndex = i;
            break;
        }
        try {
            if (this.lineIndex != -1) {
                if (this.lineIndex == 4 || this.lineIndex == 5) {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(8));
                }
            } else if (this.columnResetRects != null) {
                int i;
                this.setCursor(Cursor.getPredefinedCursor(0));
                boolean isFromRightToLeft = this.lastMousX > e.getX();
                int n = i = isFromRightToLeft ? this.columnResetRects.length - 1 : 0;
                while (true) {
                    if (this.columnResetRects[i].contains(x, y)) {
                        this.lineIndex = 6 + i;
                        this.setCursor(Cursor.getPredefinedCursor(11));
                    } else if (isFromRightToLeft) {
                        if (i >= 0) {
                            --i;
                            continue;
                        }
                    } else if (i < this.columnResetRects.length) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastMousX = e.getX();
    }

    private void drawDragLine(MouseEvent e) {
        if (this.lineIndex != -1) {
            Point p = e.getPoint();
            p = this.limitScope(p);
            if (this.lineIndex == 0 || this.lineIndex == 1 || this.lineIndex == 2 || this.lineIndex == 3) {
                int w = (int)(this.paper.getPainterSize().getWidth() * this.scale - 1.0);
                this.drawDashedLine(0, p.y, w, p.y);
            } else if (this.lineIndex >= 4) {
                int h = (int)(this.paper.getPainterSize().getHeight() * this.scale - 1.0);
                this.drawDashedLine(p.x, 0, p.x, h);
            }
        }
    }

    private void drawSelectRect(MouseEvent e) {
        int x = this.movePressPoint.x - this.selectRect.x;
        int y = this.movePressPoint.y - this.selectRect.y;
        Point dPoint = e.getPoint();
        int mX = dPoint.x - x;
        int mY = dPoint.y - y;
        this.drawDashedLine(mX, mY, this.selectRect.width, this.selectRect.height);
    }

    private void drawResizeRect(MouseEvent e) {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        Point toP = e.getPoint();
        if (this.currentDragCorner == 0) {
            if (toP.x > this.selectRect.x + this.selectRect.width - MIN_RESIZE) {
                toP.x = this.selectRect.x + this.selectRect.width - MIN_RESIZE;
            }
            if (toP.y > this.selectRect.y + this.selectRect.height - MIN_RESIZE) {
                toP.y = this.selectRect.y + this.selectRect.height - MIN_RESIZE;
            }
            x = toP.x;
            y = toP.y;
            width = this.selectRect.x - toP.x + this.selectRect.width;
            height = this.selectRect.y - toP.y + this.selectRect.height;
        } else if (this.currentDragCorner == 1) {
            if (toP.x < this.selectRect.x + MIN_RESIZE) {
                toP.x = this.selectRect.x + MIN_RESIZE;
            }
            if (toP.y > this.selectRect.y + this.selectRect.height - MIN_RESIZE) {
                toP.y = this.selectRect.y + this.selectRect.height - MIN_RESIZE;
            }
            x = this.selectRect.x;
            y = toP.y;
            width = toP.x - this.selectRect.x;
            height = this.selectRect.y - toP.y + this.selectRect.height;
        } else if (this.currentDragCorner == 2) {
            if (toP.x > this.selectRect.x + this.selectRect.width - MIN_RESIZE) {
                toP.x = this.selectRect.x + this.selectRect.width - MIN_RESIZE;
            }
            if (toP.y < this.selectRect.y + MIN_RESIZE) {
                toP.y = this.selectRect.y + MIN_RESIZE;
            }
            x = toP.x;
            y = this.selectRect.y;
            width = this.selectRect.x - toP.x + this.selectRect.width;
            height = toP.y - this.selectRect.y;
        } else if (this.currentDragCorner == 3) {
            if (toP.x < this.selectRect.x + MIN_RESIZE) {
                toP.x = this.selectRect.x + MIN_RESIZE;
            }
            if (toP.y < this.selectRect.y + MIN_RESIZE) {
                toP.y = this.selectRect.y + MIN_RESIZE;
            }
            x = this.selectRect.x;
            y = this.selectRect.y;
            width = toP.x - this.selectRect.x;
            height = toP.y - this.selectRect.y;
        }
        width = width < 3 ? 3 : width;
        height = height < 3 ? 3 : height;
        this.resizeRect.x = x;
        this.resizeRect.y = y;
        this.resizeRect.width = width;
        this.resizeRect.height = height;
        this.drawDashedLine(x, y, width, height);
    }

    private Point limitScope(Point p) {
        Point newP = new Point(p);
        double screenRate = KDPrinterUtils.getScreenMapRate(KDPrinterUtils.SCREEN_RESOLUTION);
        PageIntervalInfo unPrintableArea = this.paper.getPainterInfo().getAttributeManager().getPageSetupModel().getUnPrintableArea(this.printer.getPrintService());
        double left = (double)(unPrintableArea.getLeft(25430) * (float)KDPrinterUtils.getPtsPerInch()) * screenRate * this.scale;
        double right = (double)(unPrintableArea.getRight(25430) * (float)KDPrinterUtils.getPtsPerInch()) * screenRate * this.scale;
        double top = (double)(unPrintableArea.getTop(25430) * (float)KDPrinterUtils.getPtsPerInch()) * screenRate * this.scale;
        double bottom = (double)(unPrintableArea.getBottom(25430) * (float)KDPrinterUtils.getPtsPerInch()) * screenRate * this.scale;
        int py = p.y;
        int py2 = p.y;
        Rectangle[] rects = this.getRects(0);
        py2 = this.lineIndex == 0 ? (int)((double)rects[3].y * this.scale - 5.0) : (this.lineIndex == 1 ? (int)((double)rects[2].y * this.scale - 5.0) : (int)((this.paper.getPainterBounds().getY() + this.paper.getPainterSize().getHeight()) * this.scale) - (int)bottom);
        py = this.lineIndex == 2 ? (int)((double)rects[1].y * this.scale + 5.0) : (this.lineIndex == 3 ? (int)((double)rects[0].y * this.scale + 5.0) : (int)(this.paper.getPainterBounds().getY() * this.scale) + (int)top);
        if (p.y < py) {
            newP.y = py;
        } else if (p.y > py2) {
            newP.y = py2;
        }
        int px = p.x;
        int px2 = p.x;
        if (this.lineIndex == 4) {
            px2 = (int)((double)rects[5].x * this.scale - 5.0);
            px = (int)(this.paper.getPainterBounds().getX() * this.scale) + (int)left;
        } else if (this.lineIndex == 5) {
            px = (int)((double)rects[4].x * this.scale + 5.0);
            px2 = (int)((this.paper.getPainterBounds().getX() + this.paper.getPainterSize().getWidth()) * this.scale) - (int)right;
        } else if (this.lineIndex > 5) {
            px = (int)((double)rects[4].x * this.scale);
            px2 = (int)((double)rects[5].x * this.scale);
        }
        if (p.x < px) {
            newP.x = px;
        } else if (p.x > px2) {
            newP.x = px2;
        }
        return newP;
    }

    private void drawDashedLine(int x1, int y1, int x2, int y2) {
        if (this.lastLine.x != -1) {
            this.drawDashedLine2(this.lastLine.x, this.lastLine.y, this.lastLine.width, this.lastLine.height);
        }
        this.drawDashedLine2(x1, y1, x2, y2);
        this.lastLine.x = x1;
        this.lastLine.y = y1;
        this.lastLine.width = x2;
        this.lastLine.height = y2;
    }

    private void drawDashedLine2(int x1, int y1, int x2, int y2) {
        Graphics2D g = (Graphics2D)CtrlGraphics.createPreviewLineGraphics(this.getGraphics());
        g.setColor(KDPConstant.PREVIEW_PAGEMARGIN_COLOR);
        g.setXORMode(Color.WHITE);
        if (x1 == x2 || y1 == y2) {
            g.drawLine(x1, y1, x2, y2);
        } else {
            g.drawRect(x1, y1, x2, y2);
        }
        g.setPaintMode();
        g.dispose();
    }

    private void clearDashedLine() {
        if (this.lastLine.x != -1) {
            this.drawDashedLine2(this.lastLine.x, this.lastLine.y, this.lastLine.width, this.lastLine.height);
        }
    }

    private int pointToMM(double point) {
        double screenRate = KDPrinterUtils.getScreenMapRate(KDPrinterUtils.SCREEN_RESOLUTION);
        double mm = point / (double)KDPrinterUtils.getPtsPerInch() / screenRate * (double)25.43f;
        return (int)Math.round(mm);
    }

    private void mouseDragingOnPaper(MouseEvent e) {
        if (this.lineIndex != -1) {
            Rectangle2D.Float temp;
            Point p = this.limitScope(e.getPoint());
            int y = (int)(p.getY() / this.scale);
            int x = (int)(p.getX() / this.scale);
            if (this.lineIndex == 0) {
                this.printer.getPrintJobByPaperIndex(this.previewUI.getPaperIndex()).getConfig().setHeaderMargin(this.pointToMM(y), 1000);
            } else if (this.lineIndex == 1) {
                this.printer.getPrintJobByPaperIndex(this.previewUI.getPaperIndex()).getConfig().setBodyTopMargin(this.pointToMM(y), 1000);
            } else if (this.lineIndex == 2) {
                temp = this.paper.getPainterBounds();
                double low = (float)(temp.getX() + temp.getHeight() - (double)y);
                this.printer.getPrintJobByPaperIndex(this.previewUI.getPaperIndex()).getConfig().setBodyBottomMargin(this.pointToMM(low), 1000);
            } else if (this.lineIndex == 3) {
                temp = this.paper.getPainterBounds();
                float low = temp.y + temp.height - (float)y;
                this.printer.getPrintJobByPaperIndex(this.previewUI.getPaperIndex()).getConfig().setFooterMargin(this.pointToMM(low), 1000);
            } else if (this.lineIndex == 4) {
                this.printer.getPrintJobByPaperIndex(this.previewUI.getPaperIndex()).getConfig().setLeftMargin(this.pointToMM(x), 1000);
            } else if (this.lineIndex == 5) {
                temp = this.paper.getPainterBounds();
                float margin = temp.x + temp.width - (float)x;
                this.printer.getPrintJobByPaperIndex(this.previewUI.getPaperIndex()).getConfig().setRightMargin(this.pointToMM(margin), 1000);
            } else if (this.lineIndex > 5) {
                this.printer.fireConfigWillChange();
                Rectangle rect = this.columnResetRects[this.lineIndex - 6];
                ((TableColumnsInfo)this.paper.getBody().getUserObject()).columnChanging(this.lineIndex - 6, x - (rect.x + 3));
                this.printer.getPrintConfig().setChange(true);
                this.printer.getPrintConfig().checkChange();
                this.printer.fireConfigOver();
            }
            int pageCount = this.printer.getPrintJob().getPageCount();
            this.previewUI.setPageCount(pageCount);
            this.previewUI.updatePaper();
            this.previewUI.checkZoom();
            this.repaint();
        }
    }

    protected Rectangle[] getRects(int theExtend) {
        int horiX = 1;
        int horiH = theExtend;
        int vertW = theExtend;
        int extend = theExtend / 2;
        Rectangle[] rect = new Rectangle[]{new Rectangle(), new Rectangle(), new Rectangle(), new Rectangle(), new Rectangle(), new Rectangle()};
        PainterInfo painterInfo = this.paper.getPainterInfo();
        PrintRequestAttributeSet set = painterInfo.getAttributeManager().getPrintRequestAttributeSet();
        Rectangle headerBounds = KDPrinterUtils.getPageHeadBounds(set, KDPrinterUtils.SCREEN_RESOLUTION);
        Rectangle footerBounds = KDPrinterUtils.getPageFootBounds(set, KDPrinterUtils.SCREEN_RESOLUTION);
        Rectangle pageBounds = KDPrinterUtils.getPageBounds(set, KDPrinterUtils.SCREEN_RESOLUTION);
        Dimension2D paperDim = this.paper.getPainterSize();
        float paperW = (float)paperDim.getWidth();
        float paperH = (float)paperDim.getHeight();
        rect[0].x = horiX;
        rect[0].y = headerBounds.y - extend;
        rect[0].width = (int)paperW;
        rect[0].height = horiH;
        rect[1].x = horiX;
        rect[1].y = pageBounds.y - extend;
        rect[1].width = (int)paperW;
        rect[1].height = horiH;
        rect[2].x = horiX;
        rect[2].y = pageBounds.y + pageBounds.height - extend;
        rect[2].width = (int)paperW;
        rect[2].height = horiH;
        rect[4].x = pageBounds.x - extend;
        rect[4].y = 1;
        rect[4].width = vertW;
        rect[4].height = (int)paperH;
        rect[5].x = pageBounds.x + pageBounds.width - extend;
        rect[5].y = 1;
        rect[5].width = vertW;
        rect[5].height = (int)paperH;
        rect[3].x = horiX;
        rect[3].y = footerBounds.y + footerBounds.height - extend;
        rect[3].width = (int)paperW;
        rect[3].height = horiH;
        return rect;
    }

    public void installListeners() {
        if (this.mouseHandler == null) {
            this.mouseHandler = new MouseHandler();
            this.addMouseListener(this.mouseHandler);
        }
        if (this.mouseMotionHandler == null) {
            this.mouseMotionHandler = new MouseMotionHandler();
            this.addMouseMotionListener(this.mouseMotionHandler);
        }
    }

    public void unInstallListeners() {
        if (this.mouseHandler != null) {
            this.removeMouseListener(this.mouseHandler);
            this.mouseHandler = null;
        }
        if (this.mouseMotionHandler != null) {
            this.removeMouseMotionListener(this.mouseMotionHandler);
            this.mouseMotionHandler = null;
        }
    }

    private boolean isActive() {
        return this.previewUI.getActiveUI() == this;
    }

    private void setActive() {
        this.previewUI.setActiveUI(this);
    }

    private void updateCursor() {
        if (this.previewUI.getStatus() == 0) {
            if (this.isActive()) {
                if (this.previewUI.getZoomStatus()) {
                    this.setCursor(Resources.getCustomCursor((Component)((Object)this), "cursor.zoomIn"));
                } else {
                    this.setCursor(Resources.getCustomCursor((Component)((Object)this), "cursor.zoomOut"));
                }
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        } else if (this.lineIndex == -1) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.setPaper(this.getPaper());
    }

    public Paper getPaper() {
        return this.paper;
    }

    public PainterCell getPainterByPosition(float x, float y, Point2D.Float position) {
        if (this.paper != null) {
            Page canvas = this.paper.getBody();
            Point2D.Float location = canvas.getPainterLocation();
            float px = x - location.x;
            float py = y - location.y;
            PainterCell cell = this.locatLabelCell(px, py, canvas, position);
            if (cell != null) {
                position.x = x - position.x;
                position.y = y - position.y;
            }
            return cell;
        }
        return null;
    }

    public PainterCell locatLabelCell(float x, float y, Canvas page, Point2D.Float position) {
        List painters = page.getAllPainter();
        int size = painters.size();
        for (int i = size - 1; i > -1; --i) {
            IPainter painter = (IPainter)painters.get(i);
            Rectangle2D.Float bounds = painter.getPainterBounds();
            if (!this.pointIsInRect(x, y, bounds)) continue;
            if (painter instanceof LabelCell || painter instanceof ImageCell) {
                position.x = x - bounds.x;
                position.y = y - bounds.y;
                return (PainterCell)painter;
            }
            if (!(painter instanceof Canvas)) continue;
            return this.locatLabelCell(x - bounds.x, y - bounds.y, (Canvas)painter, position);
        }
        return null;
    }

    private boolean pointIsInRect(float x, float y, Rectangle2D.Float bounds) {
        return x >= bounds.x && y >= bounds.y && x <= bounds.x + bounds.width && y <= bounds.y + bounds.height;
    }

    private boolean pointIsInRect(Point point, Rectangle bounds) {
        if (bounds == null) {
            return false;
        }
        int x = point.x;
        int y = point.y;
        return x >= bounds.x && y >= bounds.y && x <= bounds.x + bounds.width && y <= bounds.y + bounds.height;
    }

    private int pointIsInRects(Point point, Rectangle[] rects) {
        int index = -1;
        for (int i = 0; i < rects.length; ++i) {
            if (!this.pointIsInRect(point, rects[i])) continue;
            index = i;
            break;
        }
        return index;
    }

    public void setSelectRect(Rectangle rect) {
        this.selectRect = rect;
        this.repaint();
    }

    private class MouseMotionHandler
    extends MouseMotionAdapter {
        private MouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (OnePaperUI.this.previewUI.getStatus() == 2) {
                OnePaperUI.this.drawDragLine(e);
            } else if (OnePaperUI.this.drawFlag == MOVECELL) {
                OnePaperUI.this.drawSelectRect(e);
            } else if (OnePaperUI.this.drawFlag == RESIZECELL) {
                OnePaperUI.this.drawResizeRect(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (OnePaperUI.this.previewUI.getStatus() == 2) {
                OnePaperUI.this.mouseMovingOnPaper(e);
            } else if (OnePaperUI.this.previewUI.getStatus() == 1 && OnePaperUI.this.selectRect != null && OnePaperUI.this.pointIsInRect(e.getPoint(), OnePaperUI.this.selectRect)) {
                Rectangle[] rects = OnePaperUI.this.getSelectRectCornerRects();
                int one = OnePaperUI.this.pointIsInRects(e.getPoint(), rects);
                if (one < 0) {
                    OnePaperUI.this.setCursor(Cursor.getPredefinedCursor(13));
                } else if (one == 0) {
                    OnePaperUI.this.setCursor(Cursor.getPredefinedCursor(6));
                } else if (one == 1) {
                    OnePaperUI.this.setCursor(Cursor.getPredefinedCursor(7));
                } else if (one == 2) {
                    OnePaperUI.this.setCursor(Cursor.getPredefinedCursor(7));
                } else if (one == 3) {
                    OnePaperUI.this.setCursor(Cursor.getPredefinedCursor(6));
                }
            } else {
                OnePaperUI.this.updateCursor();
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (OnePaperUI.this.previewUI.getStatus() == 0) {
                if (!OnePaperUI.this.isActive()) {
                    OnePaperUI.this.setActive();
                    OnePaperUI.this.updateCursor();
                } else {
                    OnePaperUI.this.previewUI.zoomUI(me.getPoint());
                }
            } else if (OnePaperUI.this.previewUI.getStatus() == 2) {
                OnePaperUI.this.updateCursor();
            } else if (OnePaperUI.this.previewUI.getStatus() == 1) {
                OnePaperUI.this.previewUI.getEditManager().stopEditing();
                boolean isOnSelectRect = OnePaperUI.this.pointIsInRect(me.getPoint(), OnePaperUI.this.selectRect);
                if (!isOnSelectRect) {
                    boolean isSelect = OnePaperUI.this.previewUI.getEditManager().selectCellAt(me.getX(), me.getY(), null);
                    if (isSelect) {
                        OnePaperUI.this.setCursor(Cursor.getPredefinedCursor(13));
                        OnePaperUI.this.drawFlag = MOVECELL;
                        OnePaperUI.this.movePressPoint = me.getPoint();
                    }
                } else {
                    int isOnSelectRectCorner = OnePaperUI.this.pointIsInRects(me.getPoint(), OnePaperUI.this.getSelectRectCornerRects());
                    if (isOnSelectRectCorner < 0) {
                        OnePaperUI.this.setCursor(Cursor.getPredefinedCursor(13));
                        OnePaperUI.this.drawFlag = MOVECELL;
                        OnePaperUI.this.movePressPoint = me.getPoint();
                    } else {
                        OnePaperUI.this.resizeRect = new Rectangle();
                        OnePaperUI.this.currentDragCorner = isOnSelectRectCorner;
                        OnePaperUI.this.drawFlag = RESIZECELL;
                    }
                }
                if (SwingUtilities.isRightMouseButton(me)) {
                    EditPopupMenu menu = new EditPopupMenu(OnePaperUI.this.previewUI, me.getX(), me.getY());
                    menu.show((Component)((Object)OnePaperUI.this), me.getX(), me.getY());
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (OnePaperUI.this.previewUI.getStatus() == 1 && e.getClickCount() == 2) {
                OnePaperUI.this.previewUI.getEditManager().editCellAt(e.getX(), e.getY(), null);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (OnePaperUI.this.previewUI.getStatus() == 2) {
                OnePaperUI.this.mouseDragingOnPaper(e);
            } else if (OnePaperUI.this.previewUI.getStatus() == 1) {
                if (OnePaperUI.this.drawFlag == MOVECELL) {
                    OnePaperUI.this.clearDashedLine();
                    OnePaperUI.this.drawFlag = 0;
                    int mX = e.getPoint().x - (((OnePaperUI)OnePaperUI.this).movePressPoint.x - ((OnePaperUI)OnePaperUI.this).selectRect.x);
                    int mY = e.getPoint().y - (((OnePaperUI)OnePaperUI.this).movePressPoint.y - ((OnePaperUI)OnePaperUI.this).selectRect.y);
                    OnePaperUI.this.movePressPoint = null;
                    if (mX != ((OnePaperUI)OnePaperUI.this).selectRect.x || mY != ((OnePaperUI)OnePaperUI.this).selectRect.y) {
                        OnePaperUI.this.previewUI.getEditManager().moveCell(mX, mY);
                        OnePaperUI.this.previewUI.repaint();
                    }
                } else if (OnePaperUI.this.drawFlag == RESIZECELL) {
                    OnePaperUI.this.clearDashedLine();
                    OnePaperUI.this.previewUI.getEditManager().resizeCell(OnePaperUI.this.resizeRect);
                    OnePaperUI.this.drawFlag = 0;
                }
            }
            OnePaperUI.this.lastLine.x = -1;
            OnePaperUI.this.lineIndex = -1;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            OnePaperUI.this.updateCursor();
        }
    }
}

