/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.preview;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.print.preview.ButtonItem;
import com.kingdee.bos.ctrl.print.preview.ButtonItemGroup;
import com.kingdee.bos.ctrl.print.preview.IPreviewToolBarButtonCreator;
import com.kingdee.bos.ctrl.print.preview.PreviewBody;
import com.kingdee.bos.ctrl.print.preview.ZoomPercent;
import com.kingdee.bos.ctrl.print.preview.event.ButtonItemEvent;
import com.kingdee.bos.ctrl.print.preview.event.ButtonItemListener;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.print.util.KDPrintUtil;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class PreviewToolBar
implements ButtonItemListener {
    private Logger logger = CommonLogger.getLogger(PreviewToolBar.class);
    private KDToolBar toolBar;
    PreviewBody previewUI;
    private List bgList;
    private Map buttonItemMap = new HashMap();
    private EventListenerList listenerList = new EventListenerList();
    private String url;
    private ButtonItemGroup[] toolbar_buttonGroup;
    protected JTextField scaleTextField;

    public PreviewToolBar(PreviewBody previewUI) {
        this.previewUI = previewUI;
        this.init();
        ButtonItemGroup[] big = this.configCommonGroup();
        this.setButtonItemGroup(big);
    }

    private ButtonItemGroup[] configCommonGroup() {
        if (this.toolbar_buttonGroup == null || this.toolbar_buttonGroup.length == 0) {
            if (this.url == null) {
                this.toolbar_buttonGroup = this.configDefaultGroup();
            } else {
                this.loadToolbarConfigXmlUrl();
            }
        }
        return this.toolbar_buttonGroup;
    }

    public PreviewToolBar(KDToolBar pToolBar) {
        this.init();
        this.toolBar = pToolBar;
    }

    private void init() {
        this.bgList = new ArrayList();
        this.addButtonItemListener(this);
    }

    public void setToolbarConfigXmlUrl(String url) {
        this.url = url;
    }

    public void addButtonItemListener(ButtonItemListener l) {
        if (l == null) {
            return;
        }
        this.listenerList.add(ButtonItemListener.class, l);
    }

    public void fireButtonItemListener(ButtonItemEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != ButtonItemListener.class) continue;
            ((ButtonItemListener)listeners[i + 1]).handleButtonItem(event);
        }
    }

    public void removeButtonItemListener(ButtonItemListener l) {
        this.listenerList.remove(ButtonItemListener.class, l);
    }

    public KDToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new KDToolBar();
            this.reSort();
            this.loadButtonItem(this.getButtonItemGroups());
        }
        return this.toolBar;
    }

    public void addButtonItem(ButtonItem buttonItem, int categoryOfButtonItemGroup) {
        if (!this.hasButtonItemGroup(categoryOfButtonItemGroup)) {
            this.createButtonItemCroup(categoryOfButtonItemGroup);
        }
        ButtonItemGroup big = this.getButtonItemGroup(categoryOfButtonItemGroup);
        big.addButtonItem(buttonItem);
        this.mapButtonItem(big);
    }

    public ButtonItem getButtonItem(int category) {
        return (ButtonItem)this.buttonItemMap.get(new Integer(category));
    }

    public boolean hasButtonItemGroup(int categoryOfButtonItemGroup) {
        boolean b = false;
        if (this.bgList != null && this.bgList.size() > 0) {
            int size = this.bgList.size();
            for (int i = 0; i < size; ++i) {
                ButtonItemGroup big = (ButtonItemGroup)this.bgList.get(i);
                if (big.getCategory() != categoryOfButtonItemGroup) continue;
                return true;
            }
        }
        return b;
    }

    public void loadToolbarConfigXmlUrl() {
        if (this.url != null) {
            try {
                Element root = XmlUtil.loadXmlFile((String)this.url);
                List groupList = root.getChildren("group");
                ButtonItemGroup[] groups = new ButtonItemGroup[groupList.size()];
                Element creator = root.getChild("extendItemCreator");
                IPreviewToolBarButtonCreator buttonCreator = null;
                if (creator != null) {
                    String className = creator.getText();
                    try {
                        Class<?> theClass = PreviewBody.class.getClassLoader().loadClass(className);
                        buttonCreator = (IPreviewToolBarButtonCreator)theClass.newInstance();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                int length = groupList.size();
                for (int i = 0; i < length; ++i) {
                    ButtonItemGroup oneGroup;
                    groups[i] = oneGroup = new ButtonItemGroup(i);
                    Element group = (Element)groupList.get(i);
                    List itemList = group.getChildren("item");
                    int size = itemList.size();
                    for (int j = 0; j < size; ++j) {
                        String visible;
                        Element item = (Element)itemList.get(j);
                        String system = item.getAttributeValue("system");
                        String key = item.getAttributeValue("key");
                        int category = Integer.parseInt(item.getAttributeValue("category"));
                        String stype = item.getAttributeValue("type");
                        short type = 0;
                        if (stype != null) {
                            type = (short)Integer.parseInt(stype);
                        }
                        boolean isVisible = (visible = item.getAttributeValue("visible")) == null ? true : "true".equals(visible);
                        String iconKey = item.getAttributeValue("icon");
                        if ("true".equals(system)) {
                            Object icon = null;
                            if (iconKey != null) {
                                icon = Resources.getIcon(iconKey);
                            }
                            oneGroup.addButtonItem(this.createbuttonItem(key, category, type, icon, isVisible));
                            continue;
                        }
                        if (buttonCreator == null) continue;
                        oneGroup.addButtonItem(buttonCreator.createbuttonItem(key, category, iconKey, isVisible));
                    }
                }
                this.toolbar_buttonGroup = groups;
                this.setButtonItemGroup(this.toolbar_buttonGroup);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.loadDefaultToolBar();
            }
            catch (JDOMException e) {
                e.printStackTrace();
                this.loadDefaultToolBar();
            }
        }
    }

    public void loadDefaultToolBar() {
        this.toolbar_buttonGroup = this.configDefaultGroup();
        this.setButtonItemGroup(this.toolbar_buttonGroup);
    }

    private ButtonItemGroup[] configDefaultGroup() {
        ButtonItemGroup[] bigs = new ButtonItemGroup[4];
        bigs[0] = new ButtonItemGroup(0);
        bigs[0].setIndex(0);
        bigs[0].addButtonItem(this.createbuttonItem("button.print", 0, Resources.getIcon("action.print.icon")));
        bigs[0].addButtonItem(this.createbuttonItem("button.pagesetup", 1, Resources.getIcon("action.page-setup.icon")));
        bigs[1] = new ButtonItemGroup(1);
        bigs[1].setIndex(1);
        bigs[1].addButtonItem(this.createbuttonItem("button.firstPage", 6, Resources.getIcon("action.firstpage.icon")));
        bigs[1].addButtonItem(this.createbuttonItem("button.previousPage", 7, Resources.getIcon("action.back.icon")));
        bigs[1].addButtonItem(this.createbuttonItem("button.nextPage", 8, Resources.getIcon("action.forward.icon")));
        bigs[1].addButtonItem(this.createbuttonItem("button.lastPage", 9, Resources.getIcon("action.lastpage.icon")));
        bigs[2] = new ButtonItemGroup(3);
        bigs[2].setIndex(2);
        bigs[2].addButtonItem(this.createbuttonItem("button.singlepage", 3, false));
        bigs[2].addButtonItem(this.createbuttonItem("button.multiView", 4, Resources.getIcon("action.multiPageView.icon")));
        bigs[2].addButtonItem(this.createbuttonItem("button.zoomview", 5));
        bigs[2].addButtonItem(this.createbuttonItem("button.papermargin", 10, Resources.getIcon("action.activate-margin-edit.icon")));
        if (this.previewUI.getPrinter().isEditButtonVisible()) {
            bigs[2].addButtonItem(this.createbuttonItem("button.edit", 14, Resources.getIcon("action.edit.icon")));
        }
        if (this.previewUI.getPrinter().isExportImportButtonVisible()) {
            bigs[2].addButtonItem(this.createbuttonItem("button.export", 15, Resources.getIcon("action.export.icon")));
            bigs[2].addButtonItem(this.createbuttonItem("button.import", 16, Resources.getIcon("action.import.icon")));
        }
        bigs[2].addButtonItem(this.createbuttonItem("button.printTest", 17, Resources.getIcon("action.print.icon")));
        boolean isShow = KDPrintUtil.isShowPDFButton();
        if (isShow) {
            bigs[2].addButtonItem(this.createbuttonItem("button.export.pdf", 18, Resources.getIcon("action.export.icon")));
        }
        bigs[3] = new ButtonItemGroup(2);
        bigs[3].setIndex(3);
        bigs[3].addButtonItem(this.createbuttonItem("button.close", 2, Resources.getIcon("action.exit.icon")));
        return bigs;
    }

    private ButtonItem createbuttonItem(String key, int categary) {
        return this.createbuttonItem(key, categary, (short)0, null, true);
    }

    private ButtonItem createbuttonItem(String key, int categary, boolean visiable) {
        return this.createbuttonItem(key, categary, (short)0, null, visiable);
    }

    private ButtonItem createbuttonItem(String key, int categary, Object icon) {
        return this.createbuttonItem(key, categary, (short)0, icon, true);
    }

    public ButtonItemGroup createButtonItemCroup(int categoryOfButtonItemGroup) {
        ButtonItemGroup big = new ButtonItemGroup(categoryOfButtonItemGroup);
        big.setIndex(this.bgList.size());
        this.bgList.add(big);
        return big;
    }

    public void addButtonItemGroup(ButtonItemGroup big) {
        if (this.hasButtonItemGroup(big.getCategory())) {
            throw new IllegalArgumentException("duplicate category of the ButtonItemGroup ,please reset the category");
        }
        this.bgList.add(big);
        this.mapButtonItem(big);
    }

    private void mapButtonItem(ButtonItemGroup big) {
        List items = big.getButtonItems();
        int length = items.size();
        for (int i = 0; i < length; ++i) {
            ButtonItem item = (ButtonItem)items.get(i);
            this.buttonItemMap.put(new Integer(item.getCategory()), item);
        }
    }

    public void setButtonItemGroup(ButtonItemGroup[] big) {
        this.clear();
        if (big != null && big.length > 0) {
            for (int i = 0; i < big.length; ++i) {
                this.addButtonItemGroup(big[i]);
            }
        }
    }

    public void clear() {
        this.toolBar = null;
        this.bgList.clear();
        this.buttonItemMap.clear();
    }

    public ButtonItemGroup getButtonItemGroup(int categoryOfButtonItemGroup) {
        int size = this.bgList.size();
        for (int i = 0; i < size; ++i) {
            ButtonItemGroup big = (ButtonItemGroup)this.bgList.get(i);
            if (big.getCategory() != categoryOfButtonItemGroup) continue;
            return big;
        }
        return null;
    }

    public List getButtonItemGroups() {
        try {
            this.reSort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.bgList;
    }

    void reSort() {
        Collections.sort(this.bgList, new Comparator(){

            public int compare(Object o1, Object o2) {
                ButtonItemGroup b1 = (ButtonItemGroup)o1;
                ButtonItemGroup b2 = (ButtonItemGroup)o2;
                if (b1.getIndex() < b2.getIndex()) {
                    return -1;
                }
                if (b1.getIndex() > b2.getIndex()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    protected void loadButtonItem(List biglist) {
        int bigSize = biglist.size();
        for (int i = 0; i < bigSize; ++i) {
            ButtonItemGroup big = (ButtonItemGroup)biglist.get(i);
            List list = big.getButtonItems();
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                final ButtonItem bi = (ButtonItem)list.get(j);
                JComponent comp = KDPrinterUtils.getComponentOfButtonItem(bi);
                bi.setComponent(comp);
                if (comp == null) continue;
                if (comp instanceof AbstractButton) {
                    ((AbstractButton)comp).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            Object source = ae.getSource();
                            Boolean value = null;
                            if (source instanceof JToggleButton) {
                                value = ((JToggleButton)source).isSelected();
                            }
                            ButtonItemEvent event = new ButtonItemEvent(bi, value);
                            PreviewToolBar.this.fireButtonItemListener(event);
                        }
                    });
                }
                this.toolBar.add((Component)comp);
            }
            if (i == bigSize - 1) continue;
            this.toolBar.addSeparator();
        }
    }

    private ButtonItem createbuttonItem(String key, int categary, short type, Object icon, boolean visiable) {
        ButtonItem item = null;
        if (categary == 5) {
            final KDComboBox cbZoom = new KDComboBox((Object[])new ZoomPercent[]{new ZoomPercent(5.0f), new ZoomPercent(4.0f), new ZoomPercent(3.0f), new ZoomPercent(2.0f), new ZoomPercent(1.75f), new ZoomPercent(1.5f), new ZoomPercent(1.0f), new ZoomPercent(0.75f), new ZoomPercent(0.5f), new ZoomPercent(0.25f)});
            cbZoom.setPreferredSize(new Dimension(72, 22));
            cbZoom.setSelectedIndex(6);
            cbZoom.setToolTipText(this.getMsg(key));
            cbZoom.setEditable(true);
            final ButtonItem item2 = new ButtonItem((JComponent)cbZoom, 5);
            item2.setVisible(visiable);
            this.scaleTextField = (JTextField)cbZoom.getEditor().getEditorComponent();
            cbZoom.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        KDComboBox combobox = (KDComboBox)event.getSource();
                        Object o = combobox.getSelectedItem();
                        if (o instanceof ZoomPercent) {
                            ZoomPercent obj = (ZoomPercent)o;
                            JTextField editor = (JTextField)((KDComboBox)event.getSource()).getEditor().getEditorComponent();
                            float percent = obj.getValue();
                            if (percent > 0.0f) {
                                editor.setText(obj.toString());
                                PreviewToolBar.this.handleButtonItem(item2, new Double(percent));
                            }
                        } else if (o instanceof String && PreviewToolBar.this.scaleTextField.isEditable()) {
                            String newPercent = (String)o;
                            int length = newPercent.length();
                            if (newPercent.endsWith("%") && newPercent.length() > 1) {
                                String numStr = newPercent.substring(0, length - 1);
                                float num = Float.parseFloat(numStr) / 100.0f;
                                if ((double)num <= 0.05) {
                                    num = 1.0f;
                                    PreviewToolBar.this.setScaleText("100%");
                                }
                                PreviewToolBar.this.handleButtonItem(item2, new Double(num));
                            }
                        }
                    }
                }
            });
            JTextField editor = (JTextField)cbZoom.getEditor().getEditorComponent();
            editor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTextField editor = (JTextField)e.getSource();
                    String text = editor.getText();
                    if (KDPrinterUtils.isPercentStr(text) || KDPrinterUtils.isNumber(text)) {
                        float p = KDPrinterUtils.getPercentByStr(text);
                        PreviewToolBar.this.handleButtonItem(item2, new Double(p));
                        if (KDPrinterUtils.isNumber(text)) {
                            editor.setText(text + "%");
                        }
                    } else {
                        editor.setText(cbZoom.getSelectedItem().toString());
                    }
                }
            });
            item = item2;
        } else {
            item = new ButtonItem(this.getMsg(key), (Icon)icon, categary);
            item.setVisible(visiable);
            item.setCompType(type);
        }
        return item;
    }

    protected void setScaleText(String scale) {
        KDComboBox zoomCombo = (KDComboBox)this.getButtonItem(5).getOtherComponent();
        int count = zoomCombo.getItemCount();
        zoomCombo.setSelectedIndex(-1);
        for (int i = 0; i < count; ++i) {
            String sStr = zoomCombo.getItemAt(i).toString();
            if (!scale.equals(sStr)) continue;
            zoomCombo.setSelectedIndex(i);
            return;
        }
        zoomCombo.setSelectedItem((Object)scale);
    }

    public void reVisibleButtonItem(int categoryOfButtonItem, boolean visible) {
    }

    public void reEnableButtonItem(int categoryOfButtonItem, boolean enable) {
    }

    @Override
    public void handleButtonItem(ButtonItemEvent event) {
        this.handleButtonItem(event.getButtonItem(), event.getButtonItemValue());
    }

    protected void handleButtonItem(ButtonItem buttonItem, Object value) {
        switch (buttonItem.getCategory()) {
            case 0: {
                this.previewUI.print(buttonItem, value);
                break;
            }
            case 1: {
                this.previewUI.pageDialog(buttonItem, value);
                break;
            }
            case 6: {
                this.previewUI.first(buttonItem, value);
                break;
            }
            case 7: {
                this.previewUI.previous(buttonItem, value);
                break;
            }
            case 8: {
                this.previewUI.next(buttonItem, value);
                break;
            }
            case 9: {
                this.previewUI.last(buttonItem, value);
                break;
            }
            case 11: {
                break;
            }
            case 5: {
                this.previewUI.zoomView(buttonItem, value);
                break;
            }
            case 4: {
                this.previewUI.showSelectMultiPageDialog(buttonItem);
                break;
            }
            case 10: {
                this.previewUI.changePageInterval();
                break;
            }
            case 2: {
                this.previewUI.closeWindow();
                break;
            }
            case 14: {
                this.previewUI.changeEditStatus();
                break;
            }
            case 15: {
                this.previewUI.exportKDP();
                break;
            }
            case 16: {
                this.previewUI.importKDP();
                break;
            }
            case 17: {
                this.previewUI.printTestPage();
                break;
            }
            case 18: {
                this.previewUI.exportPDF();
                break;
            }
        }
    }

    private String getMsg(String key) {
        return Resources.getMsg(key);
    }
}

