/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.printjob;

import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.control.PaperInfo;
import com.kingdee.bos.ctrl.print.printjob.AbstractPrintJob;
import com.kingdee.bos.ctrl.print.printjob.IEconomizePrint;
import com.kingdee.bos.ctrl.print.printjob.IPageProvider;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.printjob.ReBufferPrintJob;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiBufferPrintJobs
extends AbstractPrintJob {
    private List jobs;
    private Map jobmap;
    private ArrayList pageNum;
    private float[] pageSize;
    private float[] paperSize;
    private boolean isLoadAll = false;
    private IEconomizePrint pageProvider;

    public MultiBufferPrintJobs() {
        this.setID("$common");
        this.jobs = new ArrayList(1);
        this.jobmap = new HashMap(1);
    }

    @Override
    public PrintJobConfig getConfig() {
        return this.printAttrMana;
    }

    @Override
    public void setPageProvider(IPageProvider virtualModel) {
        throw new UnsupportedOperationException("This is only a container for IPrintJob.");
    }

    @Override
    public void addPrintJob(IPrintJob oneJob) {
        if (oneJob != null) {
            IPrintJob theJob = oneJob;
            String id = oneJob.getID();
            if (!this.jobmap.containsKey(id)) {
                if (this.printer.isDividePage()) {
                    theJob = new ReBufferPrintJob(oneJob);
                }
                this.jobmap.put(id, theJob);
                this.jobs.add(theJob);
                this.initJob(theJob);
            }
        }
    }

    private void initJob(IPrintJob job) {
        job.setParent(this);
        job.setPrinter(this.printer);
    }

    @Override
    public void update() {
        int jobsize = this.jobs.size();
        for (int i = 0; i < jobsize; ++i) {
            IPrintJob job = (IPrintJob)this.jobs.get(i);
            job.update();
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.jobs != null) {
            int length = this.jobs.size();
            for (int i = 0; i < length; ++i) {
                ((IPrintJob)this.jobs.get(i)).removeNotify();
            }
            this.jobs.clear();
        }
        this.jobmap.clear();
        this.isLoadAll = false;
        this.pageNum = null;
    }

    @Override
    public Paper getPaper(int index) {
        return this.createPaper(index);
    }

    @Override
    public Paper createPaper(int index) {
        IPrintJob firstJob = (IPrintJob)this.jobs.get(0);
        IPageProvider pageProvider = firstJob.getPageProvider();
        if (pageProvider instanceof IEconomizePrint && ((IEconomizePrint)((Object)pageProvider)).isEconomizePaper()) {
            this.pageProvider = (IEconomizePrint)((Object)pageProvider);
            return this.createEconomizePaper(index);
        }
        return this.oldCreatePaper(index);
    }

    private Paper oldCreatePaper(int index) {
        IPrintJob firstJob;
        Paper paper = null;
        int jobsize = this.jobs.size();
        int theIndex = 0;
        int lastTotal = 0;
        if (index == 0 && (paper = (firstJob = (IPrintJob)this.jobs.get(0)).createPaper(0)) != null) {
            paper.setIndex(index);
            return paper;
        }
        for (int i = 0; i < jobsize; ++i) {
            IPrintJob job = (IPrintJob)this.jobs.get(i);
            if (job.getPageCount() != -1) {
                if (index < (theIndex += job.getPageCount())) {
                    paper = job.createPaper(index - lastTotal);
                    break;
                }
            } else {
                paper = job.createPaper(index - lastTotal);
                break;
            }
            lastTotal += job.getPageCount();
        }
        if (paper != null) {
            paper.setIndex(index);
        }
        return paper;
    }

    private Paper createEconomizePaper(int index) {
        if (this.pageNum == null) {
            this.pageNum = new ArrayList();
            int[] begin = new int[]{0, 0};
            this.pageNum.add(begin);
            Paper paper = ((IPrintJob)this.jobs.get(0)).createPaper(0);
            float width = paper.getWidth();
            float height = paper.getHeight();
            this.paperSize = new float[]{width, height};
            Page page = paper.getBody();
            this.pageSize = new float[]{page.getWidth(), page.getHeight()};
        }
        if (this.pageNum.size() - 1 <= index) {
            this.loadPaper(index + 1);
        }
        return this.togetherPage(index);
    }

    private void loadPaper(int index) {
        int pageCount;
        if (this.pageNum == null) {
            this.pageNum = new ArrayList();
            int[] begin = new int[]{0, 0};
            this.pageNum.add(begin);
            Paper paper = ((IPrintJob)this.jobs.get(0)).createPaper(0);
            float width = paper.getWidth();
            float height = paper.getHeight();
            this.paperSize = new float[]{width, height};
            Page page = paper.getBody();
            this.pageSize = new float[]{page.getWidth(), page.getHeight()};
        }
        for (int i = pageCount = this.pageNum.size() - 1; i < index && !this.isLoadAll; ++i) {
            this.isLoadAll = this.calculatePage();
        }
    }

    private boolean calculatePage() {
        int[] begin = (int[])this.pageNum.get(this.pageNum.size() - 1);
        int jobSize = this.jobs.size();
        int j = begin[1];
        float pageWidth = this.pageSize[0];
        float pageHeight = this.pageSize[1];
        float leaveWidth = pageWidth;
        float maxHeight = 0.0f;
        block0: for (int i = begin[0]; i < jobSize; ++i) {
            IPrintJob printJob = (IPrintJob)this.jobs.get(i);
            int pageCount = printJob.getPageCount();
            if (pageCount == -1) {
                ((AbstractPrintJob)printJob).bufferPrint();
                pageCount = printJob.getPageCount();
            }
            while (j < pageCount) {
                int[] beginPageCount;
                Page nowPage = printJob.createPaper(j).getBody();
                this.cutPageBlankTail(nowPage);
                float width = nowPage.getWidth();
                float height = nowPage.getHeight();
                if (pageWidth < width || pageHeight < height) {
                    if (i != begin[0] || j != begin[1]) {
                        beginPageCount = new int[]{i, j};
                        this.pageNum.add(beginPageCount);
                        return i == jobSize - 1 && j == pageCount - 1;
                    }
                    if (j == pageCount - 1) {
                        j = 0;
                        beginPageCount = new int[]{i + 1, 0};
                        this.pageNum.add(beginPageCount);
                        continue block0;
                    }
                } else {
                    leaveWidth = this.pageProvider.isHorEconomizePaper() ? (leaveWidth -= width) : -1.0f;
                    if (leaveWidth < 0.0f) {
                        if (i != begin[0] || j != begin[1]) {
                            pageHeight -= (float)this.pageProvider.getVerSpace();
                        }
                        if (this.pageProvider.isVerEconomizePaper()) {
                            if ((pageHeight -= maxHeight) < height) {
                                beginPageCount = new int[]{i, j};
                                this.pageNum.add(beginPageCount);
                                return false;
                            }
                        } else {
                            beginPageCount = new int[]{i, j};
                            this.pageNum.add(beginPageCount);
                            return false;
                        }
                        maxHeight = height;
                        leaveWidth = pageWidth - width;
                    }
                    maxHeight = Math.max(maxHeight, height);
                    leaveWidth -= (float)this.pageProvider.getHorSpace();
                    if (j == pageCount - 1) {
                        j = 0;
                        continue block0;
                    }
                }
                ++j;
            }
        }
        return true;
    }

    private Paper togetherPage(int index) {
        if (this.pageNum.size() < index + 1) {
            return null;
        }
        int[] begin = (int[])this.pageNum.get(index);
        IPrintJob beginPrintJob = (IPrintJob)this.jobs.get(begin[0]);
        Paper paper = beginPrintJob.createPaper(begin[1]);
        Page page = paper.getBody();
        paper.setWidth(this.paperSize[0]);
        paper.setHeight(this.paperSize[1]);
        float pageWidth = this.pageSize[0];
        float pageHeight = this.pageSize[1];
        Page returnPage = new Page();
        returnPage.setWidth(pageWidth);
        returnPage.setHeight(pageHeight);
        returnPage.setX(page.getX());
        returnPage.setY(page.getY());
        page.setX(0.0f);
        page.setY(0.0f);
        if (pageWidth < page.getWidth() || pageHeight < page.getHeight()) {
            returnPage.addPainter(page);
            paper.setBody(returnPage);
            paper.setIndex(index);
            return paper;
        }
        float maxHeight = 0.0f;
        int jobSize = this.jobs.size();
        int j = begin[1];
        float addX = 0.0f;
        float addY = 0.0f;
        block0: for (int i = begin[0]; i < jobSize; ++i) {
            IPrintJob printJob = (IPrintJob)this.jobs.get(i);
            int pageCount = printJob.getPageCount();
            if (pageCount == -1) {
                ((AbstractPrintJob)printJob).bufferPrint();
                pageCount = printJob.getPageCount();
            }
            while (j < pageCount) {
                Page nowPage = printJob.createPaper(j).getBody();
                this.cutPageBlankTail(nowPage);
                nowPage.setX(0.0f);
                nowPage.setY(0.0f);
                if (this.pageProvider.isHorEconomizePaper() && addX + nowPage.getWidth() < pageWidth) {
                    nowPage.setX(addX);
                }
                if (this.pageProvider.isVerEconomizePaper()) {
                    if (!this.pageProvider.isHorEconomizePaper()) {
                        if (i != begin[0] || j != begin[1]) {
                            addY += (float)this.pageProvider.getVerSpace();
                        }
                        addY += maxHeight;
                        maxHeight = 0.0f;
                        nowPage.setY(addY);
                    } else if (addX + nowPage.getWidth() > pageWidth) {
                        addX = 0.0f;
                        addY += maxHeight + (float)this.pageProvider.getVerSpace();
                        maxHeight = 0.0f;
                        nowPage.setY(addY);
                    } else {
                        nowPage.setY(addY);
                    }
                }
                if (addX + nowPage.getWidth() > pageWidth || addY + nowPage.getHeight() > pageHeight) {
                    paper.setBody(returnPage);
                    paper.setIndex(index);
                    return paper;
                }
                if (this.pageProvider.isHorEconomizePaper()) {
                    addX += nowPage.getWidth() + (float)this.pageProvider.getHorSpace();
                }
                maxHeight = Math.max(maxHeight, nowPage.getHeight());
                returnPage.addPainter(nowPage);
                if (j == pageCount - 1) {
                    j = 0;
                    continue block0;
                }
                ++j;
            }
        }
        paper.setBody(returnPage);
        paper.setIndex(index);
        return paper;
    }

    @Override
    public Page getPage(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IPrintJob getPrintJob(int index) {
        if (index > this.jobs.size() - 1) {
            return null;
        }
        return (IPrintJob)this.jobs.get(index);
    }

    @Override
    public int getTaskCount() {
        return this.jobs.size();
    }

    @Override
    public int getPageCount() {
        IPrintJob firstJob = (IPrintJob)this.jobs.get(0);
        IPageProvider pageProvider = firstJob.getPageProvider();
        if (pageProvider instanceof IEconomizePrint && ((IEconomizePrint)((Object)pageProvider)).isEconomizePaper()) {
            this.pageProvider = (IEconomizePrint)((Object)pageProvider);
            this.pageCount = this.oldGetPageCount();
            this.loadPaper(this.pageCount);
            return this.pageCount;
        }
        return this.oldGetPageCount();
    }

    private int oldGetPageCount() {
        int nums = 0;
        int jobsize = this.jobs.size();
        for (int i = 0; i < jobsize; ++i) {
            IPrintJob job = (IPrintJob)this.jobs.get(i);
            int pageCount = job.getPageCount();
            if (pageCount == -1) {
                ((AbstractPrintJob)job).bufferPrint();
                pageCount = job.getPageCount();
            }
            if (pageCount != -1) {
                nums += pageCount;
                continue;
            }
            nums = -1;
            break;
        }
        this.pageCount = nums;
        return this.pageCount;
    }

    @Override
    public int getPageCount2() {
        return this.pageCount;
    }

    @Override
    public void rePagination() {
        int jobsize = this.jobs.size();
        for (int i = 0; i < jobsize; ++i) {
            IPrintJob job = (IPrintJob)this.jobs.get(i);
            job.rePagination();
        }
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) {
        IPrintJob job = this.getPrintJobByPaperIndex(pageIndex);
        return job.getPageFormat(pageIndex);
    }

    @Override
    public IPrintJob getPrintJobByPaperIndex(int paperIndex) {
        int jobsize = this.jobs.size();
        int theIndex = 0;
        if (paperIndex == 0 && jobsize > 0) {
            return (IPrintJob)this.jobs.get(0);
        }
        for (int i = 0; i < jobsize; ++i) {
            IPrintJob job = (IPrintJob)this.jobs.get(i);
            if (job.getPageCount() != -1 && paperIndex >= (theIndex += job.getPageCount())) continue;
            return job;
        }
        return null;
    }

    @Override
    public PrintJobConfig[] getJobsConfigs() {
        int jobsize = this.jobs.size();
        PrintJobConfig[] managers = new PrintJobConfig[jobsize];
        for (int i = 0; i < jobsize; ++i) {
            IPrintJob job = (IPrintJob)this.jobs.get(i);
            managers[i] = job.getConfig();
        }
        return managers;
    }

    @Override
    public void preparePagination() {
        this.update();
        int jobsize = this.jobs.size();
        for (int i = 0; i < jobsize; ++i) {
            IPrintJob job = (IPrintJob)this.jobs.get(i);
            job.preparePagination();
        }
    }

    public void changeReFecthPage(boolean isReFetchPage) {
        int i;
        int jobsize = this.jobs.size();
        ArrayList<IPrintJob> resulList = new ArrayList<IPrintJob>();
        for (i = 0; i < jobsize; ++i) {
            IPrintJob job = (IPrintJob)this.jobs.get(i);
            if (isReFetchPage) {
                resulList.add(new ReBufferPrintJob(job));
                continue;
            }
            resulList.add(((ReBufferPrintJob)job).getOriginJob());
        }
        this.jobs.clear();
        this.jobmap.clear();
        int size = resulList.size();
        for (i = 0; i < size; ++i) {
            IPrintJob theJob = (IPrintJob)resulList.get(i);
            this.jobmap.put(theJob.getID(), theJob);
            this.jobs.add(theJob);
            this.initJob(theJob);
        }
    }

    @Override
    public boolean isEmpty() {
        int jobsize = this.jobs.size();
        boolean isEmpty = true;
        for (int i = 0; i < jobsize; ++i) {
            IPrintJob job = (IPrintJob)this.jobs.get(i);
            if (job.isEmpty()) continue;
            return false;
        }
        return isEmpty;
    }

    @Override
    public PaperInfo getPaperInfo() {
        return this.paperInfo;
    }

    @Override
    public Paper getTestPaper(boolean testType) {
        return this.getPrintJob(0).getTestPaper(testType);
    }

    private void cutPageBlankTail(Page page) {
        float maxBottom = 0.0f;
        float maxRight = 0.0f;
        for (IPainter child : page.getAllPainter()) {
            float bottom = child.getY() + child.getHeight();
            float right = child.getX() + child.getWidth();
            if (maxBottom < bottom) {
                maxBottom = bottom;
            }
            if (!(maxRight < right)) continue;
            maxRight = right;
        }
        if (maxBottom < page.getHeight()) {
            page.setHeight(maxBottom);
        }
        if (maxRight < page.getWidth()) {
            page.setWidth(maxRight);
        }
    }
}

