/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.printjob;

import com.kingdee.bos.ctrl.common.util.list.exception.OutOfCapacityException;
import com.kingdee.bos.ctrl.print.IVariantParser;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.ui.KDPrintServiceUI;
import com.kingdee.bos.ctrl.print.control.PaperInfo;
import com.kingdee.bos.ctrl.print.printjob.AbstractPrintJob;
import com.kingdee.bos.ctrl.print.printjob.DefaultDividePolicy;
import com.kingdee.bos.ctrl.print.printjob.IBeforePaginationListener;
import com.kingdee.bos.ctrl.print.printjob.IDividePolicy;
import com.kingdee.bos.ctrl.print.printjob.IPageProvider;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.util.PrintPageFileBuffer;
import com.kingdee.bos.ctrl.print.util.Resource;
import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ReBufferPrintJob
extends AbstractPrintJob {
    IPrintJob originJob;
    int pageCount = -1;
    boolean hasOrignJobPagination = false;
    private int previewPageIndex = 0;
    private ArrayList previewPageBuffer = new ArrayList();
    private PrintPageFileBuffer printFileBuffer;
    private int memoryBufferCount = 50;
    private boolean isBuffered = false;
    private IDividePolicy defaultDividePolicy = new DefaultDividePolicy();

    public ReBufferPrintJob(IPrintJob job) {
        this.setOriginJob(job);
    }

    @Override
    public void rePagination() {
        this.getConfig().setChange(false);
        this.isBuffered = false;
        this.clearPreviewPageBuffer();
    }

    @Override
    public void checkChange() {
        if (this.getConfig().isChange()) {
            this.rePagination();
        }
    }

    private void clearPreviewPageBuffer() {
        this.previewPageBuffer.clear();
        this.previewPageIndex = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.originJob.isEmpty();
    }

    @Override
    public void preparePagination() {
        if (!this.hasOrignJobPagination) {
            this.originJob.preparePagination();
            this.hasOrignJobPagination = true;
        }
    }

    @Override
    public Page getPage(int index) {
        Page page = super.getPage(index);
        if (page == null) {
            if (this.isBuffered) {
                if (this.previewPageBuffer.size() > 0) {
                    this.previewPageBuffer.clear();
                }
                page = this.getPageFromBuffer(index);
            } else {
                if (index == 0 && this.previewPageBuffer.size() == 0) {
                    this.update();
                }
                if (index < this.previewPageBuffer.size()) {
                    page = (Page)this.previewPageBuffer.get(index);
                } else {
                    while ((page = this.getOriginJob().getPage(this.previewPageIndex++)) != null) {
                        List pageList = this.dividePage(page);
                        int size = pageList.size();
                        for (int j = 0; j < size; ++j) {
                            this.previewPageBuffer.add(pageList.get(j));
                        }
                        if (index >= this.previewPageBuffer.size()) continue;
                        page = (Page)this.previewPageBuffer.get(index);
                        break;
                    }
                }
            }
            if (page != null) {
                page.setPainterInfo(this.getPrintPainterInfo());
            }
        }
        if (page != null) {
            page.setIndex(index);
        }
        return page;
    }

    private Page getPageFromBuffer(int index) {
        PrintPageFileBuffer fileBuffer = this.getFileBuffer();
        if (fileBuffer == null) {
            return null;
        }
        if (index >= this.getPageCount()) {
            return null;
        }
        return (Page)fileBuffer.get(index);
    }

    @Override
    public void bufferPrint() {
        if (this.isBuffered) {
            return;
        }
        this.update();
        PrintPageFileBuffer fileBuffer = this.getFileBuffer();
        if (fileBuffer == null) {
            return;
        }
        int i = 0;
        int paperIndex = 0;
        Page page = null;
        this.getPaperInfo().resetLastPageHeight();
        while ((page = this.getOriginJob().getPage(i)) != null) {
            if (this.originJob.getPrinter().isStopPagination()) {
                this.pageCount = -1;
                return;
            }
            try {
                List pageList = this.dividePage(page);
                int size = pageList.size();
                for (int j = 0; j < size; ++j) {
                    fileBuffer.add(paperIndex, pageList.get(j));
                    ++paperIndex;
                }
                ++i;
            }
            catch (OutOfCapacityException e1) {
                e1.printStackTrace();
                this.originJob.getPrinter().prompt(Resource.DISK_NOSPACE);
                this.isBuffered = true;
                return;
            }
        }
        this.pageCount = paperIndex;
        this.isBuffered = true;
    }

    private List dividePage(Page page) {
        Rectangle2D.Float pageBounds = this.getPaperInfo().getPageBounds();
        return this.getDividePolicy().dividePage(pageBounds, page);
    }

    private IDividePolicy getDividePolicy() {
        return this.defaultDividePolicy;
    }

    @Override
    public void setPageCount(int nums) {
        this.pageCount = nums;
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    public int getPageCount2() {
        return this.pageCount;
    }

    @Override
    public Object getContentType() {
        return this.originJob.getContentType();
    }

    @Override
    public void clear() {
        this.clearPreviewPageBuffer();
    }

    @Override
    public int pageDialog(Component owner, boolean isShowPreviewButton, boolean isCheckChange) {
        PrintJobConfig printAttrMana = this.originJob.getConfig();
        int status = KDPrintServiceUI.pageDialog(printAttrMana, owner, isShowPreviewButton);
        if (status == 1 && isCheckChange) {
            this.checkChange();
        }
        return status;
    }

    @Override
    public Paper getPaper(int index) {
        return this.originJob.getPaper(index);
    }

    @Override
    public PaperInfo getPaperInfo() {
        return this.originJob.getPaperInfo();
    }

    @Override
    public void setPaperInfo(PaperInfo info) {
        this.originJob.setPaperInfo(info);
    }

    @Override
    public void update() {
        this.originJob.update();
    }

    @Override
    public void setPageProvider(IPageProvider model) {
        this.originJob.setPageProvider(model);
    }

    @Override
    public PainterInfo getPrintPainterInfo() {
        return this.originJob.getPrintPainterInfo();
    }

    @Override
    public String getID() {
        return this.originJob.getID();
    }

    public IPrintJob getOriginJob() {
        return this.originJob;
    }

    public void setOriginJob(IPrintJob originJob) {
        this.originJob = originJob;
    }

    @Override
    public void setParent(IPrintJob jobs) {
        this.originJob.setParent(jobs);
    }

    @Override
    public PrintJobConfig getConfig() {
        this.originJob.getConfig().setPrintJob(this);
        return this.originJob.getConfig();
    }

    @Override
    public void setID(String name) {
        if (this.originJob != null) {
            this.originJob.setID(name);
        }
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) {
        return this.originJob.getPageFormat(pageIndex);
    }

    @Override
    public void setPageConfig(IPrintJob job) {
        this.originJob.setPageConfig(job);
    }

    @Override
    public void addBeforePaginationListener(IBeforePaginationListener listener) {
        this.originJob.addBeforePaginationListener(listener);
    }

    @Override
    public boolean isDynamicPaper() {
        return this.originJob.isDynamicPaper();
    }

    @Override
    public IVariantParser getVariantParser() {
        return this.originJob.getVariantParser();
    }

    @Override
    public void setVariantParser(IVariantParser variantParser) {
        this.originJob.setVariantParser(variantParser);
    }

    @Override
    public void setUserObject(Object obj) {
        this.originJob.setUserObject(obj);
    }

    @Override
    public Object getUserObject() {
        return this.originJob.getUserObject();
    }

    @Override
    public void setHeader(Canvas header) {
        this.originJob.setHeader(header);
    }

    @Override
    public void setFooter(Canvas footer) {
        this.originJob.setFooter(footer);
    }

    @Override
    public Canvas getHeader() {
        return this.originJob.getHeader();
    }

    @Override
    public Canvas getFooter() {
        return this.originJob.getFooter();
    }

    @Override
    public void addPrintJob(IPrintJob onePrint) {
    }

    @Override
    public IPrintJob getPrintJob(int index) {
        return null;
    }

    @Override
    public int getTaskCount() {
        return 0;
    }

    @Override
    public void setPrinter(KDPrinter print) {
        this.originJob.setPrinter(print);
    }

    @Override
    public PrintJobConfig[] getJobsConfigs() {
        return null;
    }

    @Override
    public IPrintJob getPrintJobByPaperIndex(int paperIndex) {
        return null;
    }

    private PrintPageFileBuffer getFileBuffer() {
        if (this.printFileBuffer == null) {
            try {
                this.printFileBuffer = new PrintPageFileBuffer(this.memoryBufferCount);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.originJob.getPrinter().prompt(Resource.FIILE_ERROR);
            }
        }
        return this.printFileBuffer;
    }

    @Override
    public KDPrinter getPrinter() {
        return this.originJob.getPrinter();
    }
}

