/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.printjob;

import com.kingdee.bos.ctrl.print.config.ui.PaperAdjustModel;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Line2D;

public class TestPage
extends Page {
    boolean type = true;

    public TestPage(boolean type) {
        this.type = type;
    }

    @Override
    public void painting(Graphics g, PainterInfo info) {
        Graphics2D g2d = (Graphics2D)g;
        Image logo = Resources.getImage("kingdee.logo");
        g2d.drawImage(logo, 0, 0, null);
        if (info.getPaperIndex() == 0 && !this.type) {
            Image sample = Resources.getImage("print.testsample");
            g2d.drawImage(sample, 400, 100, null);
        }
        g2d.setColor(Color.black);
        Font font = g2d.getFont();
        g2d.setFont(new Font(font.getFontName(), 0, 36));
        g2d.drawString(Resources.getMsg("print.testmsg1"), logo.getWidth(null), 45);
        g2d.drawString(Resources.getMsg("print.testmsg2"), logo.getWidth(null), 95);
        g2d.setFont(font);
        int y = 110;
        g2d.drawString(Resources.getMsg("print.testmsg3"), 10, y);
        g2d.drawString(Resources.getMsg("print.testmsg4"), 10, y += 15);
        if (this.type) {
            int i;
            int i2;
            g2d.drawString(Resources.getMsg("print.testmsg5"), 10, 200);
            int rulerLength = 15;
            int rulerPoint = (int)((double)rulerLength / 2.543 * (double)KDPrinterUtils.SCREEN_RESOLUTION + 0.5);
            int x1 = 10;
            int y1 = 240;
            int x2 = rulerPoint + 10;
            g2d.drawLine(x1, y1, x2, y1);
            g2d.drawLine(x1, y1, x1, y1 + x2 - x1);
            g2d.drawLine(x1, y1 - 10, x1, y1);
            g2d.drawLine(x2, y1 - 10, x2, y1);
            g2d.drawLine(x1, y1 + x2 - x1, x1 + 10, y1 + x2 - x1);
            float pcm = (float)rulerPoint / (float)rulerLength;
            for (i2 = 0; i2 <= rulerLength; ++i2) {
                g2d.drawString(String.valueOf(i2), (float)x1 + pcm * (float)i2 - 3.0f, (float)(y1 - 6 - 10));
                g2d.draw(new Line2D.Float((float)x1 + pcm * (float)i2, y1 - 8, (float)x1 + pcm * (float)i2, y1));
            }
            for (i2 = 1; i2 <= rulerLength; ++i2) {
                g2d.drawString(String.valueOf(i2), (float)(x1 + 6 + 10), (float)y1 + pcm * (float)i2 + 5.0f);
                g2d.draw(new Line2D.Float(x1 + 8, (float)y1 + pcm * (float)i2, x1, (float)y1 + pcm * (float)i2));
            }
            float pmm = (float)rulerPoint / (float)(rulerLength * 10);
            for (i = 0; i <= rulerLength * 10; ++i) {
                if (i % 5 == 0) {
                    g2d.draw(new Line2D.Float((float)x1 + pmm * (float)i, y1 - 5, (float)x1 + pmm * (float)i, y1));
                    continue;
                }
                g2d.draw(new Line2D.Float((float)x1 + pmm * (float)i, y1 - 3, (float)x1 + pmm * (float)i, y1));
            }
            for (i = 0; i <= rulerLength * 10; ++i) {
                if (i % 5 == 0) {
                    g2d.draw(new Line2D.Float(x1, (float)y1 + pmm * (float)i, x1 + 5, (float)y1 + pmm * (float)i));
                    continue;
                }
                g2d.draw(new Line2D.Float(x1, (float)y1 + pmm * (float)i, x1 + 2, (float)y1 + pmm * (float)i));
            }
        }
        int msgX = 10;
        y += 15;
        if (this.type) {
            msgX = 90;
            y += 150;
        }
        g2d.drawString(Resources.getMsg("print.testmsg7") + (info.getPaperIndex() + 1) + " " + Resources.getMsg("label.strpage"), msgX, y);
        g2d.drawString(Resources.getMsg("border.printservice") + "\uff1a" + info.getAttributeManager().getPrintService().getName(), msgX, y += 15);
        Dimension paperSize = KDPrinterUtils.getPaperSize2(info.getAttributeManager().getPrintRequestAttributeSet(), 1000);
        g2d.drawString(Resources.getMsg("print.testmsg8") + paperSize.width + "\u00d7" + paperSize.height + "   " + Resources.getMsg("label.unit_mm"), msgX, y += 15);
        y += 15;
        if (info.getPaperIndex() == 0) {
            g2d.drawString(Resources.getMsg("print.testmsg10"), msgX, y);
            g2d.drawString(Resources.getMsg("label.topmargin") + "\uff1a" + info.getAttributeManager().getBodyTopMargin(1000), msgX + 95, y);
            g2d.drawString(Resources.getMsg("label.bottommargin") + "\uff1a" + info.getAttributeManager().getBodyBottomMargin(1000), msgX + 180, y);
            g2d.drawString(Resources.getMsg("label.leftmargin") + "\uff1a" + info.getAttributeManager().getLeftMargin(1000), msgX + 95, y += 15);
            g2d.drawString(Resources.getMsg("label.rightmargin") + "\uff1a" + info.getAttributeManager().getRightMargin(1000) + "   " + Resources.getMsg("label.unit_mm"), msgX + 180, y);
            PaperAdjustModel adjustor = info.getAttributeManager().getAdjustor();
            String printer = info.getAttributeManager().getPrintService().getName();
            float[] values = adjustor.getAdjustValues(printer);
            g2d.drawString(Resources.getMsg("tree.stylusPrinterAdujust", "tree.root") + ":  " + Resources.getMsg("label.perPaper") + ":" + values[0] + " ; " + Resources.getMsg("label.scrollLength") + "\uff1a" + values[1] + " " + Resources.getMsg("label.unit_mm"), msgX, y += 15);
            y += 25;
            if (!this.type) {
                g2d.drawString(Resources.getMsg("print.testmsg13"), msgX, y);
                g2d.drawString(Resources.getMsg("print.testmsg14") + paperSize.height + "," + Resources.getMsg("print.testmsg15") + paperSize.height + "-A\u3002", msgX, y += 15);
                y += 15;
            }
            g2d.drawString(Resources.getMsg("print.testmsg6"), 10, 900);
        }
        g2d.drawRect(1, 1, (int)this.getWidth() - 2, (int)this.getHeight() - 2);
    }
}

