/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.printjob.table;

import com.kingdee.bos.ctrl.print.printjob.table.ITableForPrint;

public class TableColumnsInfo {
    ITableForPrint sheet;
    float startPosition;
    int from;
    int to;
    int[] columnsWidth;

    public TableColumnsInfo(ITableForPrint sheet, int from, int to) {
        this.sheet = sheet;
        this.from = from;
        this.to = to;
        this.columnsWidth = new int[to - from + 1];
        for (int j = from; j <= to; ++j) {
            this.setColumnWidth(j, sheet.getColumnWidth(j));
        }
    }

    public void setColumnWidth(int index, int width) {
        if (index >= this.from && index <= this.to) {
            this.columnsWidth[index - this.from] = width;
        }
    }

    public int getColumnWidth(int index) {
        return this.columnsWidth[index - this.from];
    }

    public int[] getAllColumnWidth() {
        return this.columnsWidth;
    }

    public void columnChanging(int index, int offset) {
        int newWidth = this.sheet.getColumnWidth(this.from + index) + offset;
        this.sheet.setWidth(this.from + index, newWidth > 0 ? newWidth : 0);
    }

    public String toString() {
        String str = "Columns:" + this.from + "," + this.to + ";";
        if (this.columnsWidth != null) {
            for (int i = 0; i < this.columnsWidth.length; ++i) {
                str = str + this.columnsWidth[i] + ",";
            }
        }
        return str;
    }

    public float getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(float startPosition) {
        this.startPosition = startPosition;
    }
}

