/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.component;

import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.StyleCell;
import com.kingdee.bos.ctrl.print.ui.view.TableCellView;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class TableCell
extends Canvas {
    public static int DEFAULT_ROW_HEIGHT = 20;
    public static int DEFAULT_COLUMN_WIDTH = 70;
    private float[] columns;
    private float[] rows;
    private HashMap cells;
    private Merges merges;
    private boolean isGrid = true;

    public TableCell(int rowCount, int colCount) {
        int i;
        this.columns = new float[colCount];
        this.rows = new float[rowCount];
        for (i = 0; i < this.columns.length; ++i) {
            this.columns[i] = DEFAULT_COLUMN_WIDTH;
        }
        for (i = 0; i < this.rows.length; ++i) {
            this.rows[i] = DEFAULT_ROW_HEIGHT;
        }
        this.cells = new HashMap();
    }

    public void addRow() {
        float[] newRowsHeight = new float[this.rows.length + 1];
        System.arraycopy(this.rows, 0, newRowsHeight, 0, this.rows.length);
        newRowsHeight[newRowsHeight.length - 1] = DEFAULT_ROW_HEIGHT;
        this.rows = newRowsHeight;
        this.updateWidthHeight();
    }

    public void addColumn() {
        float[] newColumnsWidth = new float[this.columns.length + 1];
        System.arraycopy(this.columns, 0, newColumnsWidth, 0, this.columns.length);
        newColumnsWidth[newColumnsWidth.length - 1] = DEFAULT_COLUMN_WIDTH;
        this.columns = newColumnsWidth;
        this.updateWidthHeight();
    }

    public int getRowCount() {
        return this.rows.length;
    }

    public int getcolumnCount() {
        return this.columns.length;
    }

    public void setColumnWidth(int colIndex, float width) {
        this.columns[colIndex] = width;
        this.updateWidthHeight();
    }

    public float getColumnWidth(int colIndex) {
        return this.columns[colIndex];
    }

    public float getRowHeight(int rowIndex) {
        return this.rows[rowIndex];
    }

    public float[] getRows() {
        return this.rows;
    }

    public float[] getColumns() {
        return this.columns;
    }

    public void setRowHeight(int rowIndex, float height) {
        this.rows[rowIndex] = height;
        this.updateWidthHeight();
    }

    public void setValue(int rowIndex, int colIndex, String text) {
        this.setValue(rowIndex, colIndex, text, null);
    }

    public void setValue(int rowIndex, int colIndex, String text, Style style) {
        StyleCell scell = new StyleCell();
        scell.setText(text);
        if (style != null) {
            scell.setStyle(style);
        }
        this.setValue(rowIndex, colIndex, scell);
    }

    public StyleCell getCell(int rowIndex, int colIndex) {
        Long key = this.getCellsHashKey(rowIndex, colIndex);
        return (StyleCell)this.cells.get(key);
    }

    public void setValue(int rowIndex, int colIndex, StyleCell cell) {
        Long key = this.getCellsHashKey(rowIndex, colIndex);
        this.cells.put(key, cell);
    }

    public boolean isGrid() {
        return this.isGrid;
    }

    public void setGrid(boolean isGrid) {
        this.isGrid = isGrid;
    }

    public void addMerge(int row, int col, int row2, int col2) {
        this.getMerges().addMerge(row, col, row2, col2);
        for (int i = row; i <= row2; ++i) {
            for (int j = col; j <= col2; ++j) {
                if (i == row && j == col) continue;
                Long key = this.getCellsHashKey(i, j);
                this.cells.remove(key);
            }
        }
    }

    public MergeBlock getMerge(int row, int col) {
        if (this.merges == null) {
            return null;
        }
        Iterator iter = this.getMerges().iterator();
        while (iter.hasNext()) {
            MergeBlock block = (MergeBlock)iter.next();
            if (!block.contains(row, col)) continue;
            return block;
        }
        return null;
    }

    public Merges getMerges() {
        if (this.merges == null) {
            this.merges = new Merges();
        }
        return this.merges;
    }

    private Long getCellsHashKey(int row, int col) {
        assert (this.isValidRowCol(row, col));
        return new Long((long)row << 32 | (long)col);
    }

    private boolean isValidRowCol(int row, int col) {
        return row >= 0 && row <= Integer.MAX_VALUE && col >= 0 && col <= Integer.MAX_VALUE;
    }

    @Override
    public void updateView() {
        this.setPainterView(TableCellView.createPainterView());
    }

    public void updateWidthHeight() {
        int i;
        float canvasWidth = 1.0f;
        float canvasHeight = 1.0f;
        for (i = 0; i < this.columns.length; ++i) {
            canvasWidth = canvasWidth + this.columns[i] + 1.0f;
        }
        for (i = 0; i < this.rows.length; ++i) {
            canvasHeight = canvasHeight + this.rows[i] + 1.0f;
        }
        this.setWidth(canvasWidth);
        this.setHeight(canvasHeight);
    }

    public void setRows(float[] rowsHeight) {
        this.rows = rowsHeight;
    }

    public void setColumns(float[] columnsHeight) {
        this.columns = columnsHeight;
    }

    public class MergeBlock {
        int row;
        int col;
        int row2;
        int col2;

        public MergeBlock(int row, int col, int row2, int col2) {
            this.row = row;
            this.col = col;
            this.row2 = row2;
            this.col2 = col2;
        }

        public boolean contains(int arow, int acol) {
            return arow >= this.row && arow <= this.row2 && acol >= this.col && acol <= this.col2;
        }

        public int getRow() {
            return this.row;
        }

        public int getCol() {
            return this.col;
        }

        public int getRow2() {
            return this.row2;
        }

        public int getCol2() {
            return this.col2;
        }
    }

    public class Merges {
        private LinkedList merges = new LinkedList();

        public MergeBlock addMerge(int row, int col, int row2, int col2) {
            MergeBlock block = new MergeBlock(row, col, row2, col2);
            this.merges.add(block);
            return block;
        }

        public Iterator iterator() {
            return this.merges.iterator();
        }
    }
}

