/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.io;

import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.IDecorate;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.ImageCell;
import com.kingdee.bos.ctrl.print.ui.component.LabelCell;
import com.kingdee.bos.ctrl.print.ui.component.LineBorder;
import com.kingdee.bos.ctrl.print.ui.component.LineCell;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.StyleCell;
import com.kingdee.bos.ctrl.print.ui.component.TableCell;
import com.kingdee.bos.ctrl.print.ui.component.VariantLabelCell;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;

public class Painter2Html {
    StringBuffer html = new StringBuffer();
    Map imagesMap;
    String imageDirectionName;

    public String makePage(Page pg, Map imagesMap, String imageDirectionName) {
        this.imagesMap = imagesMap;
        this.imageDirectionName = imageDirectionName;
        pg.setX(20.0f);
        pg.setY(20.0f);
        this.html = new StringBuffer();
        this.makeCommon(pg);
        Style style = pg.getStyle();
        this.html.append(StyleUtil.styleToHtmlStyle((Style)style));
        this.html.append("\"");
        this.html.append(" cellpadding=0 ");
        this.html.append("><tr><td>\n");
        this.makeChildren(pg);
        this.html.append("</td></tr></table>\n");
        return this.html.toString();
    }

    private void makePainter(IPainter pnt) {
        Class<?> cls = pnt.getClass();
        if (Canvas.class.equals(cls)) {
            this.makeCanvas((Canvas)pnt);
        } else if (LabelCell.class.equals(cls)) {
            this.makeLabel((LabelCell)pnt);
        } else if (VariantLabelCell.class.equals(cls)) {
            this.makeVariantLabel((VariantLabelCell)pnt);
        } else if (StyleCell.class.equals(cls)) {
            this.makeStyleCell((StyleCell)pnt);
        } else if (ImageCell.class.equals(cls)) {
            this.makeImage((ImageCell)pnt);
        } else if (LineCell.class.equals(cls)) {
            this.makeLine((LineCell)pnt);
        } else if (TableCell.class.equals(cls)) {
            this.makeTable((TableCell)pnt);
        }
    }

    private void makeChildren(Canvas cv) {
        List children = cv.getAllPainter();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            this.makePainter((IPainter)children.get(i));
        }
    }

    private void makeCommon(IPainter pnt) {
        IDecorate decorate;
        String colorStr;
        this.html.append("<table cellspacing=0 ");
        this.html.append(" style=\"position:absolute;table-layout:fixed;");
        Rectangle2D.Float rc = pnt.getPainterBounds();
        this.html.append("top:" + this.Float2String(rc.y * 25.4f / 96.0f) + "mm;");
        this.html.append("left:" + this.Float2String(rc.x * 25.4f / 96.0f) + "mm;");
        this.html.append("width:" + this.Float2String(rc.width * 25.4f / 96.0f) + "mm;");
        this.html.append("height:" + this.Float2String(rc.height * 25.4f / 96.0f) + "mm;");
        Color backColor = pnt.getBackGround();
        if (backColor != null && !(colorStr = KDPrinterUtils.colorToHex(backColor)).equals("#ffffff")) {
            this.html.append("background:" + colorStr + ";");
        }
        if ((decorate = pnt.getDecorate()) != null && decorate instanceof LineBorder) {
            int type = ((LineBorder)decorate).getType();
            if (type == 15) {
                this.html.append("border:1px solid black;");
            } else {
                if ((type & 2) > 0) {
                    this.html.append("border-top:1px solid black;");
                }
                if ((type & 1) > 0) {
                    this.html.append("border-left:1px solid black;");
                }
                if ((type & 4) > 0) {
                    this.html.append("border-right:1px solid black;");
                }
                if ((type & 8) > 0) {
                    this.html.append("border-bottom:1px solid black;");
                }
            }
        }
    }

    private void makeStyleCell(StyleCell cell) {
        this.makeCommon(cell);
        Style style = cell.getStyle();
        this.html.append(StyleUtil.styleToHtmlStyle((Style)style));
        this.html.append(";\"");
        this.html.append(" cellpadding=3 ");
        this.html.append(" border=0 ");
        this.html.append("><tr><td>\n");
        if (cell.getText() != null) {
            this.html.append(cell.getText());
        }
        this.html.append("</td></tr></table>\n");
    }

    private void makeLabel(LabelCell lbl) {
        this.makeCommon(lbl);
        Style style = lbl.getStyle();
        this.html.append(StyleUtil.styleToHtmlStyle((Style)style));
        this.html.append("\"");
        this.html.append(" cellpadding=0 ");
        this.html.append(" border=0 ");
        this.html.append("><tr><td>\n");
        String text = lbl.getText();
        if (text == null) {
            text = "";
        }
        this.html.append(text);
        this.html.append("</td></tr></table>\n");
    }

    private void makeVariantLabel(VariantLabelCell lbl) {
        this.makeCommon(lbl);
        Style style = lbl.getStyle();
        this.html.append(StyleUtil.styleToHtmlStyle((Style)style));
        this.html.append("\"");
        this.html.append(" cellpadding=0 ");
        this.html.append(" border=0 ");
        this.html.append("><tr><td>\n");
        String text = lbl.getText();
        if (text == null) {
            text = "";
        }
        this.html.append("</td></tr></table>\n");
    }

    private void makeLine(LineCell ln) {
        this.makeCommon(ln);
        Color color = ln.getColor();
        if (color != null) {
            this.html.append("background:" + KDPrinterUtils.colorToHex(color) + ";");
        }
        this.html.append("\"");
        this.html.append(" cellpadding=0 ");
        this.html.append(" border=0 ");
        this.html.append("><tr><td>\n");
        this.html.append("</td></tr></table>\n");
    }

    private void makeImage(ImageCell img) {
        this.makeCommon(img);
        this.html.append("\"");
        this.html.append(" cellpadding=0 ");
        this.html.append(" border=0 ");
        this.html.append("><tr><td>\n");
        Long imageName = new Long(System.currentTimeMillis());
        if (!this.imagesMap.containsKey(img.getImage())) {
            this.imagesMap.put(imageName, img.getImage());
        } else {
            imageName = (Long)this.imagesMap.get(img.getImage());
        }
        this.html.append("<img src='" + this.imageDirectionName + "\\" + imageName + ".jpg'");
        this.html.append("/>\n");
        this.html.append("</td></tr></table>\n");
    }

    private void makeCanvas(Canvas pg) {
        this.makeCommon(pg);
        Style style = pg.getStyle();
        this.html.append(StyleUtil.styleToHtmlStyle((Style)style));
        this.html.append("\"");
        this.html.append(" cellpadding=0 ");
        this.html.append(" border=0 ");
        this.html.append("><tr><td>\n");
        this.makeChildren(pg);
        this.html.append("</td></tr></table>\n");
    }

    private void makeTable(TableCell table) {
        this.makeCommon(table);
        this.html.append("\"");
        this.html.append(" cellpadding=0 ");
        if (table.isGrid()) {
            this.html.append(" border=1  borderColorDark=white borderColorLight=black ");
        }
        this.html.append(">\n");
        int rowCount = table.getRowCount();
        int colCount = table.getcolumnCount();
        for (int iRow = 0; iRow < rowCount; ++iRow) {
            this.html.append("<tr>");
            for (int iCol = 0; iCol < colCount; ++iCol) {
                TableCell.MergeBlock mBlock = table.getMerge(iRow, iCol);
                if (mBlock != null && (mBlock.getRow() != iRow || mBlock.getCol() != iCol)) continue;
                this.html.append("<td ");
                if (mBlock != null && mBlock.getRow() == iRow && mBlock.getCol() == iCol) {
                    int rowspan = mBlock.getRow2() - mBlock.getRow() + 1;
                    int colspan = mBlock.getCol2() - mBlock.getCol() + 1;
                    if (colspan > 1) {
                        this.html.append(" colspan=" + colspan);
                    }
                    if (rowspan > 1) {
                        this.html.append(" rowspan=" + rowspan + " ");
                    }
                }
                this.html.append(" style=\"");
                this.html.append("width:" + this.Float2String(table.getColumnWidth(iCol) * 25.4f / 96.0f) + "mm;");
                this.html.append("height:" + this.Float2String(table.getRowHeight(iRow) * 25.4f / 96.0f) + "mm;");
                StyleCell cell = table.getCell(iRow, iCol);
                if (cell != null) {
                    Style style = cell.getStyle();
                    this.html.append(StyleUtil.styleToHtmlStyle((Style)style));
                }
                this.html.append("\"");
                this.html.append(">");
                if (cell != null) {
                    this.html.append(cell.getText());
                }
                this.html.append("</td>");
                if (mBlock == null) continue;
                iCol = iCol + mBlock.getCol2() - mBlock.getCol();
            }
            this.html.append("</tr>");
        }
        this.html.append("</table>\n");
    }

    private String Float2String(float value) {
        String str = Float.toString(value);
        int length = str.length();
        if (str.endsWith(".0") && length > 2) {
            str = str.substring(0, length - 2);
        }
        return str;
    }
}

