/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.view;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.ScaleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.io.KDPDFBoxFontMapper;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.ImageCell;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.ui.view.BasicPainterView;
import com.kingdee.bos.ctrl.print.ui.view.StyleRender;
import com.kingdee.bos.ctrl.reportone.r1.print.common.ImageUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.FontMapper;
import org.apache.pdfbox.pdmodel.font.FontMappers;
import org.apache.pdfbox.rendering.PDFRenderer;

public class ImageCellView
extends BasicPainterView {
    private static final Logger log = LogUtil.getPackageLogger(ImageCellView.class);
    private static List<IImageCellRender> renders = new ArrayList<IImageCellRender>();
    protected static ImageCellView imageUI;

    public static BasicPainterView createPainterView() {
        return imageUI;
    }

    @Override
    public void paint(Graphics g, IPainter painter, PainterInfo graInfo) {
        super.paint(g, painter, graInfo);
        ImageCell imageCell = (ImageCell)painter;
        int angle = imageCell.getRotate();
        g = g.create();
        Graphics2D g2 = (Graphics2D)g;
        Rectangle2D.Float rc = imageCell.getPainterBounds();
        double tx = rc.getWidth() / 2.0;
        double ty = rc.getHeight() / 2.0;
        g2.translate(tx, ty);
        g2.rotate((double)angle / 360.0 * 2.0 * Math.PI);
        g2.translate(-tx, -ty);
        for (IImageCellRender render : renders) {
            if (!render.support(imageCell.getFileType())) continue;
            render.render(g2, imageCell);
            return;
        }
        new RealImageRender().render(g2, imageCell);
    }

    public static Image loadImage(Object value) {
        if (value != null) {
            byte[] imageData = null;
            if (value instanceof byte[]) {
                imageData = (byte[])value;
            } else if (value instanceof Blob) {
                imageData = ImageCellView.blobToBytes((Blob)value);
            } else if (value instanceof String) {
                imageData = ImageUtil.getImageByteContent((String)((String)value));
            } else if (value instanceof Image) {
                return (Image)value;
            }
            if (imageData != null) {
                return ImageUtil.makeImage((byte[])imageData);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] blobToBytes(Blob blob) {
        ByteArrayOutputStream baos = null;
        InputStream is = null;
        try {
            is = blob.getBinaryStream();
            if (is != null) {
                byte[] binarys;
                baos = new ByteArrayOutputStream();
                byte[] c = new byte[1024];
                int len = 0;
                while ((len = is.read(c, 0, c.length)) != -1) {
                    baos.write(c, 0, len);
                }
                byte[] byArray = binarys = baos.toByteArray();
                return byArray;
            }
        }
        catch (SQLException sqlEx) {
            log.error((Object)sqlEx);
        }
        catch (IOException ioEx) {
            log.error((Object)ioEx);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            try {
                is.close();
            }
            catch (IOException e1) {
                log.error((Object)e1);
            }
        }
        return null;
    }

    static {
        renders.add(new RealImageRender());
        renders.add(new PDFImageRender());
        imageUI = new ImageCellView();
    }

    static class PDFImageRender
    implements IImageCellRender {
        PDFImageRender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void render(Graphics g, ImageCell imageCell) {
            g = g.create();
            PDDocument document = null;
            try {
                Graphics2D g2d = (Graphics2D)g;
                double scale = (double)KDToolkit.getCurrentDpi() / 72.0;
                g2d.scale(scale, scale);
                g2d.setBackground(Color.WHITE);
                ByteArrayInputStream in = new ByteArrayInputStream(imageCell.getContent());
                document = PDDocument.load((InputStream)in);
                for (int i = 0; i < document.getNumberOfPages(); ++i) {
                    long start = System.currentTimeMillis();
                    PDFRenderer pdfRenderer = new PDFRenderer(document);
                    float widthScale = imageCell.getWidth() / (float)scale / document.getPage(i).getCropBox().getWidth();
                    if (widthScale < 1.0f && widthScale > 0.0f && imageCell.getScale() > 0) {
                        pdfRenderer.renderPageToGraphics(i, g2d, widthScale);
                        return;
                    }
                    pdfRenderer.renderPageToGraphics(i, g2d);
                    System.out.println("PDF\u6e32\u67d3\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (document != null) {
                    try {
                        document.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        @Override
        public boolean support(String fileType) {
            return "PDF".equalsIgnoreCase(fileType);
        }

        static {
            try {
                FontMappers.set((FontMapper)new KDPDFBoxFontMapper(FontMappers.instance()));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    static class RealImageRender
    implements IImageCellRender {
        RealImageRender() {
        }

        @Override
        public boolean support(String fileType) {
            return "image".equalsIgnoreCase(fileType);
        }

        @Override
        public void render(Graphics g, ImageCell imageCell) {
            Graphics2D g2 = (Graphics2D)g.create();
            Rectangle2D.Float rc = imageCell.getPainterBounds();
            Style style = imageCell.getStyle();
            if (style == null) {
                style = Styles.getStyle((ShareStyleAttributes)Styles.getEmptySA());
            }
            Rectangle rcContent = StyleRender.getContentBounds((int)rc.width, (int)rc.height, style);
            Image image = ImageCellView.loadImage(imageCell.getImage());
            imageCell.setImage(image);
            double zoom = this.zoomInRect(imageCell, rcContent);
            g2.scale(zoom, zoom);
            StyleRender.drawImange(image, rcContent, style, imageCell.getScale(), g2);
        }

        private double zoomInRect(ImageCell imageCell, Rectangle targetRect) {
            Image image = imageCell.getImage();
            Dimension srcSize = new Dimension(image.getWidth(null), image.getHeight(null));
            double zoom = ScaleUtil.makeScale((int)imageCell.getScale(), (Dimension)srcSize, (Rectangle)targetRect);
            if (zoom != 1.0 && zoom > 0.0) {
                targetRect.setRect((double)targetRect.x / zoom, (double)targetRect.y / zoom, (double)targetRect.width / zoom, (double)targetRect.height / zoom);
            }
            return zoom;
        }
    }

    static interface IImageCellRender {
        public boolean support(String var1);

        public void render(Graphics var1, ImageCell var2);
    }
}

