/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.util;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.client.SysContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;

public class KDPrintUtil {
    private static final Logger log = CommonLogger.getLogger(KDPrinterUtils.class);
    private static HashMap<String, String> directPrintConfigMap = new HashMap();
    private static final String directPrintConfigFilePath = System.getProperty("user.dir") + "/cache/KDPrintConfig/{0}/{1}/KDPrintConfig.xml";
    private static final String directPrintConfigFileDir = System.getProperty("user.dir") + "/cache/KDPrintConfig/{0}/{1}";
    private static final String ROOT_ELEMENT = "DirectPtint-Config";
    private static final String CONFIG_PRINTER_NAME = "printer_name";
    private static final String CONFIG_BILL_NAME = "bill_name";
    private static final String CONFIG_VALUE = "value";
    private static KDPrintUtil instance;

    public static synchronized KDPrintUtil getInstance() {
        if (instance == null) {
            KDPrintUtil.loadDirectPrintConfig();
            instance = new KDPrintUtil();
        }
        return instance;
    }

    public static boolean isPrintDirect(String templateType) {
        String printerName;
        File printDirectConfigXML = new File(MessageFormat.format(directPrintConfigFilePath, KDPrintUtil.getDcName(), KDPrintUtil.getUserId()));
        if (printDirectConfigXML.exists()) {
            KDPrintUtil.generateXMLToMap();
        }
        return !StringUtils.isEmpty((String)(printerName = directPrintConfigMap.get(templateType)));
    }

    public static HashMap<String, String> getCachedConfig() {
        return directPrintConfigMap;
    }

    public static void loadDirectPrintConfig() {
        File printDirectConfigXML;
        if (directPrintConfigMap.size() > 0) {
            directPrintConfigMap.clear();
        }
        if (!(printDirectConfigXML = new File(MessageFormat.format(directPrintConfigFilePath, KDPrintUtil.getDcName(), KDPrintUtil.getUserId()))).exists()) {
            File configFileDir = new File(MessageFormat.format(directPrintConfigFileDir, KDPrintUtil.getDcName(), KDPrintUtil.getUserId()));
            if (!configFileDir.exists()) {
                configFileDir.mkdirs();
            }
            KDPrintUtil.createPrintConfigFile();
            return;
        }
        KDPrintUtil.generateXMLToMap();
    }

    private static void generateXMLToMap() {
        Document doc = KDPrintUtil.analyzFile2Doc();
        Element rootEle = doc.getRootElement();
        try {
            List printerEleList = XPath.selectNodes((Object)rootEle, (String)"//printer_name");
            if (printerEleList == null || printerEleList.size() == 0) {
                return;
            }
            for (Element printerEle : printerEleList) {
                String printerName = printerEle.getAttributeValue(CONFIG_VALUE);
                List billEleList = printerEle.getChildren();
                if (billEleList == null || billEleList.size() == 0) continue;
                for (Element billEle : billEleList) {
                    String billName = billEle.getAttributeValue(CONFIG_VALUE);
                    directPrintConfigMap.put(billName, printerName);
                }
            }
        }
        catch (JDOMException e) {
            log.error((Object)"\u89e3\u6790\u76f4\u63a5\u6253\u5370\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            return;
        }
    }

    private static synchronized void createPrintConfigFile() {
        Document doc = new Document();
        doc.setRootElement(new Element(ROOT_ELEMENT));
        KDPrintUtil.saveToXml(doc);
        log.info((Object)"\u521b\u5efa\u76f4\u63a5\u6253\u5370\u914d\u7f6e\u6587\u4ef6\u6210\u529f\uff01");
    }

    public static synchronized void addConfigToXml(String templateType, String printer) {
        if (!StringUtils.isEmpty((String)directPrintConfigMap.get(templateType))) {
            return;
        }
        Document doc = KDPrintUtil.analyzFile2Doc();
        Element rootEle = doc.getRootElement();
        Element printerEle = null;
        try {
            printerEle = (Element)XPath.selectSingleNode((Object)rootEle, (String)("//printer_name[@value='" + printer + "']"));
        }
        catch (JDOMException e) {
            log.info((Object)("\u589e\u52a0\u76f4\u63a5\u6253\u5370\u914d\u7f6e\uff0c\u83b7\u53d6\u6253\u5370\u673a\u8282\u70b9\u5f02\u5e38\uff01\u6253\u5370\u673a\u540d\u79f0\uff1a" + printer), (Throwable)e);
        }
        if (printerEle == null) {
            printerEle = new Element(CONFIG_PRINTER_NAME);
            printerEle.setAttribute(CONFIG_VALUE, printer);
            rootEle.addContent((Content)printerEle);
        }
        Element billEle = new Element(CONFIG_BILL_NAME);
        billEle.setAttribute(CONFIG_VALUE, templateType);
        printerEle.addContent((Content)billEle);
        KDPrintUtil.saveToXml(doc);
        directPrintConfigMap.put(templateType, printer);
        log.info((Object)("\u589e\u52a0\u76f4\u63a5\u6253\u5370\u914d\u7f6e: \u5355\u636e\u7c7b\u578b:" + templateType + "\u6253\u5370\u673a\uff1a" + printer));
    }

    public static synchronized void deleteConfigInXml(String templateType, String printer) {
        Document doc = KDPrintUtil.analyzFile2Doc();
        Element rootEle = doc.getRootElement();
        try {
            Element printerEle = (Element)XPath.selectSingleNode((Object)rootEle, (String)("//printer_name[@value='" + printer + "']"));
            if (printerEle == null) {
                return;
            }
            Element billEle = (Element)XPath.selectSingleNode((Object)printerEle, (String)("//bill_name[@value='" + templateType + "']"));
            if (billEle == null) {
                return;
            }
            printerEle.removeContent((Content)billEle);
            KDPrintUtil.saveToXml(doc);
            directPrintConfigMap.remove(templateType);
            log.info((Object)("\u5220\u9664\u76f4\u63a5\u6253\u5370\u914d\u7f6e\uff1a\u5355\u636e\u7c7b\u578b:" + templateType + "\u6253\u5370\u673a\uff1a" + printer));
        }
        catch (JDOMException e) {
            log.error((Object)"\u5220\u9664\u76f4\u63a5\u6253\u5370\u5355\u636e\u8282\u70b9\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    public static synchronized void deleteNotExistPrinter(String printer) {
        Document doc = KDPrintUtil.analyzFile2Doc();
        Element rootEle = doc.getRootElement();
        try {
            Element printerEle = (Element)XPath.selectSingleNode((Object)rootEle, (String)("//printer_name[@value='" + printer + "']"));
            if (printerEle == null) {
                return;
            }
            rootEle.removeContent((Content)printerEle);
            log.info((Object)("\u5220\u9664\u76f4\u63a5\u6253\u5370\u914d\u7f6e\uff1a\u6253\u5370\u673a\uff1a" + printer));
            KDPrintUtil.saveToXml(doc);
            for (Map.Entry<String, String> entry : directPrintConfigMap.entrySet()) {
                if (!entry.getValue().equals(printer)) continue;
                directPrintConfigMap.remove(entry.getKey());
                log.info((Object)("\u5220\u9664\u76f4\u63a5\u6253\u5370\u914d\u7f6e\uff1a\u5355\u636e\u7c7b\u578b:" + entry.getKey() + "\u6253\u5370\u673a\uff1a" + printer));
            }
        }
        catch (JDOMException e) {
            log.error((Object)"\u5220\u9664\u76f4\u63a5\u6253\u5370\u6253\u5370\u673a\u8282\u70b9\u5f02\u5e38\uff01", (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveToXml(Document doc) {
        XMLOutputter outputter = new XMLOutputter();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(MessageFormat.format(directPrintConfigFilePath, KDPrintUtil.getDcName(), KDPrintUtil.getUserId()));
            outputter.output(doc, (OutputStream)out);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"\u4fdd\u5b58\u76f4\u63a5\u6253\u5370\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
            return;
        }
        catch (IOException e) {
            log.error((Object)"\u4fdd\u5b58\u76f4\u63a5\u6253\u5370\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
            return;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Document analyzFile2Doc() {
        SAXBuilder sax = new SAXBuilder();
        Document doc = new Document();
        try {
            doc = File.separatorChar == '\\' ? sax.build(MessageFormat.format("file:\\" + directPrintConfigFilePath, KDPrintUtil.getDcName(), KDPrintUtil.getUserId())) : sax.build(MessageFormat.format("file://" + directPrintConfigFilePath, KDPrintUtil.getDcName(), KDPrintUtil.getUserId()));
        }
        catch (Exception e) {
            log.error((Object)"\u89e3\u6790\u76f4\u63a5\u6253\u5370\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
        }
        return doc;
    }

    public static String getPrinterName(String billName) {
        return directPrintConfigMap.get(billName);
    }

    private static String getDcName() {
        return SysContext.getSysContext().getDcName();
    }

    private static String getUserId() {
        return SysContext.getSysContext().getCurrentUserInfo().getId().toString();
    }

    public static boolean isShowExcelButton() {
        String isShow = "0";
        try {
            if (!ConfigMDUtil.isClient()) {
                return false;
            }
            isShow = ParamManager.getParamValue(null, (String)"isShowExportExcelOrPDFButtons");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return "0".equals(isShow) || "1".equals(isShow);
    }

    public static boolean isShowPDFButton() {
        String isShow = "0";
        try {
            if (!ConfigMDUtil.isClient()) {
                return false;
            }
            isShow = ParamManager.getParamValue(null, (String)"isShowExportExcelOrPDFButtons");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return "0".equals(isShow) || "2".equals(isShow);
    }
}

