/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.util;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.print.printjob.table.ITableForPrint;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PrintSetupUtil {
    private PrintSetupUtil() {
    }

    public static List<ITableForPrint.IBlock> parserBlock(String areas) {
        ArrayList<ITableForPrint.IBlock> list = new ArrayList<ITableForPrint.IBlock>();
        if (areas == null || "".equals(areas)) {
            return list;
        }
        String temp = areas.toUpperCase();
        StringTokenizer str = new StringTokenizer(temp, ",");
        while (str.hasMoreElements()) {
            String mStr = str.nextToken();
            ITableForPrint.IBlock block = PrintSetupUtil.creatBlock(mStr);
            if (block == null) continue;
            list.add(block);
        }
        return list;
    }

    public static ITableForPrint.IBlock creatBlock(String str) {
        int delIndex;
        ITableForPrint.IBlock block = null;
        if (!StringUtil.isEmptyString((String)str) && (delIndex = str.indexOf(":")) >= 0) {
            block = PrintSetupUtil.creatEmptyBlock();
            String s1 = str.substring(0, delIndex);
            String s2 = str.substring(delIndex + 1);
            int[] p1 = PrintSetupUtil.parserRowColStr(s1);
            int[] p2 = PrintSetupUtil.parserRowColStr(s2);
            block.set(p1[0], p1[1], p2[0], p2[1]);
        }
        return block;
    }

    private static int[] parserRowColStr(String str) {
        int[] rowCol = new int[]{-1, -1};
        StringTokenizer oneM = null;
        oneM = new StringTokenizer(str, "$");
        while (oneM.hasMoreElements()) {
            String mStr = oneM.nextToken();
            try {
                rowCol[0] = Integer.parseInt(mStr) - 1;
            }
            catch (NumberFormatException e) {
                rowCol[1] = PrintSetupUtil.getColumnIndexByName(mStr);
            }
        }
        return rowCol;
    }

    private static ITableForPrint.IBlock creatEmptyBlock() {
        return new ITableForPrint.IBlock(){
            private int row = -1;
            private int col = -1;
            private int row2 = -1;
            private int col2 = -1;

            @Override
            public int getCol2() {
                return this.col2;
            }

            @Override
            public void set(int row, int col, int row2, int col2) {
                this.row = row;
                this.col = col;
                this.row2 = row2;
                this.col2 = col2;
            }

            @Override
            public int getRow() {
                return this.row;
            }

            @Override
            public int getCol() {
                return this.col;
            }

            @Override
            public int getRow2() {
                return this.row2;
            }

            @Override
            public int getMode() {
                return -1;
            }
        };
    }

    public static int getColumnIndexByName(String name) {
        int index = 0;
        char[] chars = name.toCharArray();
        int rate = 1;
        char a = 'A';
        for (int i = chars.length - 1; i >= 0; --i) {
            char bit = chars[i];
            if (bit < a || bit > 'z') {
                return -1;
            }
            index += (bit - a + 1) * rate;
            rate *= 26;
        }
        return --index;
    }
}

