/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.util;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.list.exception.OutOfCapacityException;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.util.PrintPageFileBuffer;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SyncPageList
extends PrintPageFileBuffer {
    private static final Logger log = LogUtil.getPackageLogger(SyncPageList.class);
    private boolean completed = false;
    private int waitingIndex = -1;

    public SyncPageList(int memoryCount) throws IOException {
        super(memoryCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(int index) {
        log.debug((Object)("Get page index " + index + ", list count " + this.size()));
        SyncPageList syncPageList = this;
        synchronized (syncPageList) {
            if (!this.completed && index >= this.size()) {
                log.debug((Object)("Waiting for get page index " + index));
                this.waitingIndex = index;
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.isCompleted() && index >= this.size()) {
                    log.debug((Object)"Notified by close(), no more pages.");
                    return null;
                }
                log.debug((Object)("Continue thread for get page index " + index));
                this.waitingIndex = -1;
            }
        }
        return (Page)this.get(index);
    }

    public int open() {
        this.completed = false;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPage(Page page) {
        try {
            this.add(page);
        }
        catch (OutOfCapacityException ex) {
            ex.printStackTrace();
            return -1;
        }
        log.debug((Object)("Add page, index " + (this.size() - 1)));
        SyncPageList syncPageList = this;
        synchronized (syncPageList) {
            if (this.waitingIndex != -1 && this.waitingIndex < this.size()) {
                log.debug((Object)"Notify waiting thread after add one more page.");
                ((Object)((Object)this)).notify();
            }
        }
        return 0;
    }

    public int getPageCount() {
        return this.size();
    }

    public synchronized boolean isCompleted() {
        return this.completed;
    }

    public synchronized int close() {
        this.completed = true;
        ((Object)((Object)this)).notify();
        return 0;
    }

    @Override
    public synchronized Object get(int index) {
        return super.get(index);
    }

    @Override
    public synchronized void add(Object obj) throws OutOfCapacityException {
        super.add(obj);
    }

    @Override
    public synchronized int size() {
        return super.size();
    }
}

