/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.meta.ui;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.ui.select.AObjectSelector;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.MetaManager;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.reportone.data.meta.ui.MetaTreeCtrl;
import com.kingdee.bos.ctrl.swing.KDTree;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MetaClassSelectTree
extends AObjectSelector {
    private MetaManager mm;
    private TreeUI treeUI;
    private MetaTreeCtrl treeCtrl;
    private MetaLibrary defaulLibrary;

    public MetaClassSelectTree() {
    }

    public MetaClassSelectTree(MetaManager mm) {
        this.mm = mm;
    }

    protected MetaManager initMeta() {
        return new MetaManager();
    }

    public void setMetaManager(MetaManager mm) {
        this.mm = mm;
    }

    protected void initUI() {
        this.treeUI = new TreeUI(true);
        this.treeCtrl = new MetaTreeCtrl((DefObj)this.mm);
        this.treeCtrl.initTreeUI(this.treeUI);
        this.treeUI.setRootVisible(false);
        this.treeUI.setRealtimeSelect(true);
        TreeUINode rootNode = this.treeUI.getRootNode();
        if (1 == rootNode.getChildCount()) {
            this.treeUI.expand(new TreePath(new TreeNode[]{rootNode, rootNode.getChildAt(0)}));
        }
        KDTree tree = this.treeUI.getTree();
        TreeEventHandler teh = new TreeEventHandler();
        tree.addMouseListener((MouseListener)teh);
        tree.addTreeSelectionListener((TreeSelectionListener)teh);
    }

    private void checkMeta() {
        if (this.mm == null) {
            this.mm = this.initMeta();
        }
    }

    private void checkUI() {
        if (this.treeUI == null) {
            this.checkMeta();
            this.initUI();
        }
    }

    public MetaLibrary getDefaulLibrary() {
        return this.defaulLibrary;
    }

    public void setDefaulLibrary(MetaLibrary defaulLibrary) {
        this.defaulLibrary = defaulLibrary;
    }

    public JComponent getUI() {
        this.checkUI();
        return this.treeUI;
    }

    public void setTitle(String title) {
        this.checkUI();
        this.treeUI.setTitle(title);
    }

    public String getSelectedInfo() {
        this.checkUI();
        String selPath = this.treeUI.getSelectionPathText();
        if (selPath == null || selPath.length() <= 1) {
            return null;
        }
        String mlName = PathUtil.getFirstName((String)selPath);
        MetaLibrary ml = this.mm.getLibrary(mlName);
        if (ml == null) {
            return null;
        }
        String mcPath = selPath.substring(1 + mlName.length());
        MetaClass mc = ml.getRootPackage().findClass(mcPath);
        if (mc == null) {
            return null;
        }
        FullPath fp = new FullPath();
        if (ml != this.defaulLibrary) {
            fp.setSpace(ml.getFullName());
        }
        if (mc != null) {
            fp.setPathx(this.buildPathx(mc));
        }
        return fp.getText();
    }

    protected String buildPathx(MetaClass mc) {
        return mc.getFullName();
    }

    public void setSelectedInfo(String fpText) {
        if (fpText == null) {
            return;
        }
        this.checkUI();
        FullPath fp = FullPath.parse((String)fpText);
        String selPath = FullPath.joinPath((FullPath)fp);
        this.treeUI.setSelectionPathText(selPath);
    }

    public Object getObject(String fpText) {
        MetaLibrary ml;
        if (fpText == null) {
            return null;
        }
        this.checkMeta();
        FullPath fp = FullPath.parse((String)fpText);
        MetaLibrary metaLibrary = ml = fp.getSpace() != null ? this.mm.findLibrary(fp.getSpace()) : this.defaulLibrary;
        if (ml == null) {
            return null;
        }
        return ml.getRootPackage().findClass(fp.getPathx());
    }

    public Object getSelectedObject() {
        return this.getObject(this.getSelectedInfo());
    }

    private class TreeEventHandler
    extends MouseAdapter
    implements TreeSelectionListener {
        private TreeEventHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                MetaClassSelectTree.this.fireSelectConfirm();
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            MetaClassSelectTree.this.fireSelectChanged();
        }
    }
}

