/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.modal.query.io;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Column;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Condition;
import com.kingdee.bos.ctrl.reportone.data.modal.query.IColumnList;
import com.kingdee.bos.ctrl.reportone.data.modal.query.IJoinList;
import com.kingdee.bos.ctrl.reportone.data.modal.query.IOrderList;
import com.kingdee.bos.ctrl.reportone.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.reportone.data.modal.query.ITable;
import com.kingdee.bos.ctrl.reportone.data.modal.query.ITableList;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Join;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Order;
import com.kingdee.bos.ctrl.reportone.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Query2Ksql {
    private static final String[] INDENTS = new String[4];
    private static final String UNDEFINED_QUERY_TABLE = "UNDEFINED-QUREY-TABLE:";
    private static final String UNDEFINED_META_CLASS = "UNDEFINED-META-CLASS:";
    private static final String UNDEFINED_META_FIELD = "UNDEFINED-META-FIELD:";
    public static final Pattern MC_AS;
    public static final Pattern QT_MF;

    public static final String getIndent(int level) {
        if (level >= 0 && level < INDENTS.length) {
            return INDENTS[level];
        }
        return INDENTS[0];
    }

    public static String makeQuery(IQuery qry) {
        if (qry.getQueryType() == QueryType.SQL_CUSTOM) {
            return qry.getContent();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT");
        if (qry.isDistinct()) {
            sql.append(" DISTINCT");
        }
        sql.append(Query2Ksql.makeSelect(qry.getColumns()));
        sql.append("\r\nFROM");
        sql.append(Query2Ksql.makeFrom(qry.getTables(), qry.getJoins()));
        String s = Query2Ksql.makeWhere(qry.getFilter());
        if (!StringUtil.isEmptyString((String)s)) {
            sql.append("\r\nWHERE\r\n ");
            sql.append(s);
        }
        if (!StringUtil.isEmptyString((String)(s = Query2Ksql.makeOrderBy(qry.getOrders())))) {
            sql.append("\r\nORDER BY");
            sql.append(s);
        }
        return sql.toString();
    }

    public static String makeSelect(IColumnList cols) {
        int z = cols.size();
        StringBuffer select = new StringBuffer();
        for (int i = 0; i < z; ++i) {
            if (i > 0) {
                select.append(",");
            }
            select.append("\r\n ");
            select.append(Query2Ksql.makeSelectColumn((Column)((Object)cols.get(i))));
        }
        return select.toString();
    }

    public static String makeSelectColumn(Column col) {
        return col.getExpr() + " AS " + col.getName();
    }

    public static String makeFrom(ITableList tbls, IJoinList joins) {
        JoinsParser jem = new JoinsParser(joins);
        List nodes = jem.getTopestNodes();
        StringBuffer sb = new StringBuffer();
        int tabCount = tbls.size();
        for (int i = 0; i < tabCount; ++i) {
            ITable tbl = (ITable)tbls.get(i);
            if (-1 != jem.findTopestNode(tbl.getName())) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("\r\n ");
            sb.append(Query2Ksql.makeFromTable(tbl));
        }
        int joinCount = nodes.size();
        for (int i = 0; i < joinCount; ++i) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("\r\n ");
            JoinNode joinExt = (JoinNode)nodes.get(i);
            sb.append(Query2Ksql.makeJoinNode(joinExt, tbls, 0));
        }
        return sb.toString();
    }

    public static String makeFromTable(ITable tbl) {
        StringBuffer content = new StringBuffer();
        if (tbl instanceof Table) {
            content.append("[");
            content.append(tbl.getExpr());
            content.append("]");
        } else if (tbl instanceof IQuery) {
            content.append("(");
            content.append(((IQuery)((Object)tbl)).getContent());
            content.append(")");
        }
        content.append(" AS ");
        content.append(tbl.getName());
        return content.toString();
    }

    public static String makeFromTable(ITableList tbls, String tblName) {
        ITable tbl = (ITable)tbls.get(tblName);
        if (tbl == null) {
            return UNDEFINED_QUERY_TABLE + tblName;
        }
        return Query2Ksql.makeFromTable(tbl);
    }

    public static String makeJoinNode(JoinNode node, ITableList tbls, int nest) {
        ArrayList joins = node.getJoins();
        Join join = (Join)((Object)joins.get(0));
        String[] s2 = new String[2];
        for (int i = 0; i < 2; ++i) {
            JoinNode jn;
            JoinNode joinNode = jn = i == 0 ? node.getLeft() : node.getRight();
            s2[i] = jn == null ? Query2Ksql.makeFromTable(tbls, i == 0 ? join.getLeftTable() : join.getRightTable()) : "(" + Query2Ksql.makeJoinNode(jn, tbls, nest + 1) + ")\r\n";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(s2[0] + " " + join.getJoinType().getName().toUpperCase() + " JOIN " + s2[1] + " ON ");
        int z = joins.size();
        for (int i = 0; i < z; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            join = (Join)((Object)joins.get(i));
            sb.append("(" + join.getCondition().getExpr() + ")");
        }
        return sb.toString();
    }

    public static String makeWhere(Condition cnd) {
        if (cnd == null) {
            return null;
        }
        return cnd.getExpr();
    }

    public static String makeOrderBy(IOrderList ords) {
        int z = ords.size();
        if (z == 0) {
            return null;
        }
        StringBuffer select = new StringBuffer();
        for (int i = 0; i < z; ++i) {
            if (i > 0) {
                select.append(", ");
            }
            select.append("\r\n ");
            select.append(Query2Ksql.makeOrderColumn((Order)((Object)ords.get(i))));
        }
        return select.toString();
    }

    public static String makeOrderColumn(Order ord) {
        return ord.getExpr() + (ord.isAscending() ? " ASC" : " DESC");
    }

    private static String replaceQtMf(String qtmf, ITableList tbls, MetaLibrary ml) {
        int i = qtmf.indexOf("].[");
        String qtName = qtmf.substring(1, i);
        String mfName = qtmf.substring(i + 3, qtmf.length() - 1);
        if (ml != null) {
            ITable tbl = (ITable)tbls.get(qtName);
            if (tbl != null) {
                MetaClass mc = null;
                if (tbl instanceof Table) {
                    mc = ml.getRootPackage().findClass(tbl.getExpr());
                } else if (tbl instanceof IQuery) {
                    return qtName + "." + mfName;
                }
                if (mc != null) {
                    MetaField mf = mc.getField(mfName);
                    mfName = mf != null ? ml.getLocaleFieldExpr(mf.getExpr()) : UNDEFINED_META_FIELD + mfName;
                } else {
                    qtName = UNDEFINED_META_CLASS + qtName;
                }
            } else {
                qtName = UNDEFINED_QUERY_TABLE + qtName;
            }
        }
        return qtName + "." + mfName;
    }

    private static String replaceMc(String mcExpr, MetaLibrary ml) {
        String mcPath = mcExpr.substring(1, mcExpr.length() - 1);
        if (ml != null) {
            MetaClass mc = ml.getRootPackage().findClass(mcPath);
            if (mc != null) {
                return mc.getExpr();
            }
            return UNDEFINED_META_CLASS + mcPath;
        }
        return mcPath;
    }

    public static String buildSQL(IQuery qry, MetaLibrary ml) {
        return Query2Ksql.replaceMeta(Query2Ksql.makeQuery(qry), qry, ml);
    }

    public static String makeSQL(IQuery qry, MetaLibrary ml) {
        String qryExpr = QueryType.SQL_WIZARD.equals(qry.getQueryType()) ? Query2Ksql.makeQuery(qry) : qry.getContent();
        return Query2Ksql.replaceMeta(qryExpr, qry, ml);
    }

    private static String replaceMeta(String qryExpr, IQuery qry, MetaLibrary ml) {
        int i;
        ITableList tbls = qry.getTables();
        Matcher mch = QT_MF.matcher(qryExpr);
        StringBuffer sb1 = new StringBuffer();
        int j = 0;
        while (mch.find()) {
            i = mch.start();
            sb1.append(qryExpr.substring(j, i));
            j = mch.end();
            sb1.append(Query2Ksql.replaceQtMf(qryExpr.substring(i, j), tbls, ml));
        }
        sb1.append(qryExpr.substring(j));
        mch = MC_AS.matcher(sb1);
        StringBuffer sb2 = new StringBuffer();
        j = 0;
        while (mch.find()) {
            i = mch.start() + 1;
            sb2.append(sb1.substring(j, i));
            j = mch.end() - 4;
            sb2.append(Query2Ksql.replaceMc(sb1.substring(i, j), ml));
        }
        sb2.append(sb1.substring(j));
        return sb2.toString();
    }

    static {
        Query2Ksql.INDENTS[0] = "";
        Query2Ksql.INDENTS[1] = " ";
        Query2Ksql.INDENTS[2] = "  ";
        Query2Ksql.INDENTS[3] = "   ";
        MC_AS = Pattern.compile("[^\\.]\\[[^\\[\\]]*\\]\\ AS ", 32);
        QT_MF = Pattern.compile("\\[[^\\[\\]]*\\]\\.\\[[^\\[\\]]*\\]", 32);
    }

    private static class JoinsParser {
        private ArrayList topestNodes;

        public JoinsParser(IJoinList joins) {
            this.parse(joins);
        }

        public List getTopestNodes() {
            return this.topestNodes;
        }

        private void parse(IJoinList joins) {
            this.topestNodes = new ArrayList();
            int z = joins.size();
            for (int i = 0; i < z; ++i) {
                JoinNode rightNode;
                Join join = (Join)((Object)joins.get(i));
                int left = this.findTopestNode(join.getLeftTable());
                int right = this.findTopestNode(join.getRightTable());
                if (left == -1) {
                    if (right == -1) {
                        this.topestNodes.add(new JoinNode(join));
                        continue;
                    }
                    JoinNode rightExt = (JoinNode)this.topestNodes.get(right);
                    this.topestNodes.set(right, new JoinNode(join, null, rightExt));
                    continue;
                }
                if (right == -1) {
                    JoinNode leftExt = (JoinNode)this.topestNodes.get(left);
                    this.topestNodes.set(left, new JoinNode(join, leftExt, null));
                    continue;
                }
                JoinNode leftNode = (JoinNode)this.topestNodes.get(left);
                if (leftNode == (rightNode = (JoinNode)this.topestNodes.get(right))) {
                    JoinNode node = this.findLowestNode(leftNode, join);
                    node.addJoin(join);
                    continue;
                }
                if (left > right) {
                    int tmp = left;
                    left = right;
                    right = tmp;
                }
                this.topestNodes.set(left, new JoinNode(join, leftNode, rightNode));
                this.topestNodes.remove(right);
            }
        }

        public int findTopestNode(String tblName) {
            for (int i = 0; i < this.topestNodes.size(); ++i) {
                JoinNode joinExt = (JoinNode)this.topestNodes.get(i);
                if (!joinExt.containsTable(tblName)) continue;
                return i;
            }
            return -1;
        }

        private JoinNode findLowestNode(JoinNode startNode, Join join) {
            for (int i = 0; i < 2; ++i) {
                JoinNode node;
                JoinNode joinNode = node = i == 0 ? startNode.getLeft() : startNode.getRight();
                if (node == null || !node.containsTables(join)) continue;
                return this.findLowestNode(node, join);
            }
            return startNode;
        }
    }

    private static class JoinNode {
        private ArrayList tables = new ArrayList();
        private ArrayList joins = new ArrayList();
        private JoinNode left;
        private JoinNode right;

        public JoinNode(Join join) {
            this.addJoin(join);
            this.tables.add(join.getLeftTable());
            this.tables.add(join.getRightTable());
        }

        public JoinNode(Join join, JoinNode left, JoinNode right) {
            this(join);
            if (left != null) {
                this.left = left;
                this.tables.addAll(left.getTables());
            }
            if (right != null) {
                this.right = right;
                this.tables.addAll(right.getTables());
            }
        }

        public void addJoin(Join join) {
            this.joins.add(join);
        }

        public ArrayList getJoins() {
            return this.joins;
        }

        public ArrayList getTables() {
            return this.tables;
        }

        public boolean containsTable(String name) {
            return this.tables.contains(name);
        }

        public boolean containsTables(Join join) {
            return this.tables.contains(join.getLeftTable()) && this.tables.contains(join.getRightTable());
        }

        public JoinNode getLeft() {
            return this.left;
        }

        public JoinNode getRight() {
            return this.right;
        }
    }
}

