/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.common;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.io.Meta2Xml;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Column;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.CommonResource;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.InputNavigationPanel;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.ParamTable;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.TableMultiLangUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;

public class OutPutTable
extends ParamTable {
    private List metaClasses;
    private List metaFields;

    public final List getMetaClasses() {
        if (this.metaClasses == null) {
            this.metaClasses = new ArrayList();
        }
        return this.metaClasses;
    }

    public final void setMetaClasses(List metaClasses) {
        this.metaClasses = metaClasses;
    }

    public OutPutTable() {
        this.init();
        this.installListener();
    }

    public OutPutTable(String txt) {
        this.title = txt;
        this.init();
        this.installListener();
    }

    public OutPutTable(boolean hideEXPR, boolean hideDESC, boolean hideBtnNewInput) {
        super(hideEXPR, hideDESC, hideBtnNewInput);
        this.init();
        this.installListener();
    }

    private void init() {
        this.metaFields = new ArrayList();
        this.metaClasses = new ArrayList();
    }

    private void installListener() {
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    protected void popSelectTree() {
        SimpleDialog simpleDlg = new SimpleDialog();
        MetaClass[] mcs = new MetaClass[this.metaClasses.size()];
        for (int i = 0; i < this.metaClasses.size(); ++i) {
            mcs[i] = (MetaClass)this.metaClasses.get(i);
        }
        InputNavigationPanel inputPanel = new InputNavigationPanel(mcs);
        simpleDlg.setComponent((Component)((Object)inputPanel));
        Dimension size = new Dimension(500, 400);
        if (WindowUtil.showSimpleDialog((Component)((Object)inputPanel), (Component)((Object)this), (String)CommonResource.getString("res_26"), (Dimension)size)) {
            List temp;
            this.metaFields = temp = inputPanel.getSelectedFields();
            this.modelInsertToTable(temp);
        }
    }

    private void modelInsertToTable(List list) {
        for (int i = 0; i < list.size(); ++i) {
            MetaField mf = (MetaField)list.get(i);
            this.addField2Row(mf);
        }
    }

    private void addField2Row(MetaField mf) {
        IRow row = this.table.addRow();
        row.getCell(0).setValue((Object)this.addSuffix(mf.getName(), 0));
        row.getCell(2).setValue((Object)mf.getType());
        row.getCell(4).setValue((Object)mf.getExpr());
        row.getCell(1).setValue((Object)TableMultiLangUI.toMultiLangItemList(mf.getProperties(), "alias"));
        row.getCell(3).setValue((Object)TableMultiLangUI.toMultiLangItemList(mf.getProperties(), "desc"));
    }

    private String addSuffix(String name, int col) {
        int count = this.metaFields.size();
        for (int i = 0; i < count; ++i) {
            String fieldName = ((MetaField)this.metaFields.get(i)).getName();
            int lenFieldName = fieldName.length();
            int suffix = 0;
            for (int j = 0; j < this.table.getRowCount(); ++j) {
                String temp;
                Object objTemp = this.table.getCell(j, col).getValue();
                if (objTemp == null || !(temp = this.table.getCell(j, col).getValue().toString()).startsWith(fieldName)) continue;
                temp = temp.substring(0, lenFieldName);
                String tempSuffix = temp.substring(lenFieldName);
                if (!StringUtil.equals((String)temp, (String)fieldName)) continue;
                try {
                    suffix = Integer.parseInt(tempSuffix);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++suffix;
            }
            if (suffix == 0) continue;
            return name + suffix;
        }
        return name;
    }

    public OutputColumns getOutputColumns() {
        OutputColumns ocs = new OutputColumns();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            Column c = new Column();
            if (this.table.getRow(i).getCell(0).getValue() != null) {
                c.setName(this.table.getRow(i).getCell(0).getValue().toString());
            }
            if (this.table.getRow(i).getCell(1).getValue() != null) {
                c.setAlias(this.table.getRow(i).getCell(1).getValue().toString());
            }
            if (this.table.getRow(i).getCell(2).getValue() != null) {
                c.setDataType((DataType)this.table.getRow(i).getCell(2).getValue());
            }
            OutputColumn oc = new OutputColumn(c);
            ocs.add(oc);
        }
        return ocs;
    }

    public MetaClass makeMetaClass() {
        MetaClass mc = new MetaClass();
        this.makeFields(mc);
        return mc;
    }

    private void makeFields(MetaClass mc) {
        int z = this.table.getRowCount();
        for (int i = 0; i < z; ++i) {
            mc.addField(this.makeField(this.table.getRow(i)));
        }
    }

    private MetaField makeField(IRow row) {
        MetaField mf = new MetaField();
        mf.setName((String)row.getCell(0).getValue());
        mf.setType((DataType)row.getCell(2).getValue());
        mf.setExpr((String)row.getCell(4).getValue());
        TableMultiLangUI.fromKDTableCellValue(row.getCell(1).getValue(), mf.getProperties(), "alias");
        TableMultiLangUI.fromKDTableCellValue(row.getCell(3).getValue(), mf.getProperties(), "desc");
        return mf;
    }

    public void setMetaClass(MetaClass metaClass) {
        MetaClass mc = metaClass;
        this.table.removeRows();
        Iterator itr = mc.getFields().iterator();
        while (itr.hasNext()) {
            this.addField2Row((MetaField)itr.next());
        }
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        MetaClass mc = new MetaClass();
        mc.setName("TestMC");
        mc.setAlias("Test Meta-Class");
        mc.setType(DataDefType.BOS_QUERY.getName());
        mc.setExpr("bos.query.test");
        mc.setDesc("Test BOS-Query MetaClass");
        MetaField mf = new MetaField();
        mf.setName("TestMC");
        mf.setAlias("Test Meta-Class");
        mf.setType(DataType.STRING);
        mf.setExpr("bos.query.test");
        mf.setDesc("Test BOS-Query MetaClass");
        MetaField mf2 = new MetaField();
        mf2.setName("TestMC2");
        mf2.setAlias("Test Meta-Class 2");
        mf2.setType(DataType.INTEGER);
        mf2.setExpr("bos.query.test2");
        mf2.setDesc("Test BOS-Query MetaClass 2");
        mc.addField(mf);
        mc.addField(mf2);
        OutPutTable xmp = new OutPutTable("Eric");
        xmp.setMetaClass(mc);
        SimpleDialog dlg = new SimpleDialog();
        dlg.setComponent((Component)((Object)xmp));
        dlg.showDialog();
        MetaClass mc2 = xmp.makeMetaClass();
        Element xml = Meta2Xml.makeClass((MetaClass)mc2, null);
        XmlUtil.printElement((Element)xml);
    }

    public final List getMetaFields() {
        if (this.metaFields == null) {
            this.metaFields = new ArrayList();
        }
        return this.metaFields;
    }

    public final void setMetaFields(List metaFields) {
        this.metaFields = metaFields;
    }
}

