/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.process;

import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.data.process.IDataProcessModel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.BasicProcessWizard;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.DataSetProcessList;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.ProcessResource;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.ProcessWizard;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.WizardContext;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom2.Element;

public class Wizard_SelectProcessor
extends ProcessWizard
implements IWizardStep {
    public static final String T_SELECT_PROCESSOR = "Processor";
    public static final String A_PROCESSOR = "processor";
    private String description = "";
    private DataSetProcessList dsProcessList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wizard_SelectProcessor(WizardContext context) {
        super(context);
        InputStream in = null;
        try {
            in = ((Object)((Object)this)).getClass().getResourceAsStream(context.getWizardConfigFile());
            Element e = XmlUtil.loadXmlStream((InputStream)in);
            this.initProcessList(e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void initProcessList(Element e) {
        this.dsProcessList = new DataSetProcessList(e);
        this.dsProcessList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                Wizard_SelectProcessor.this.description = Wizard_SelectProcessor.this.dsProcessList.getSelectedDescription();
                Wizard_SelectProcessor.this.updateStepDesc();
                boolean b = Wizard_SelectProcessor.this.dsProcessList.currentIsValidProcess();
                Wizard_SelectProcessor.this.manager.setNextStepEnabled(b);
            }
        });
        this.dsProcessList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && Wizard_SelectProcessor.this.dsProcessList.currentIsValidProcess()) {
                    Wizard_SelectProcessor.this.manager.getNextStepButton().doClick();
                }
            }
        });
    }

    @Override
    protected String getStepDescription() {
        return this.description;
    }

    @Override
    protected JComponent getMainBodyCtrl() {
        return this.dsProcessList;
    }

    @Override
    protected String getTitle() {
        return ProcessResource.getString("res_41");
    }

    @Override
    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        super.intoThisStep(prevStep, isOppose);
        this.manager.getNextStepButton().setText(ProcessResource.getString("res_26"));
        this.manager.setFinishEnabled(true);
        this.dsProcessList.setCurrentSourceType(this.context.getLastDataSetType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IWizardStep outThisStep(boolean isOppose) {
        if (!isOppose) {
            String selProcessor = this.dsProcessList.getSelectedWizardClass();
            if (selProcessor == null) return null;
            try {
                Class<?> wizardClass = Class.forName(selProcessor);
                Constructor<?> c = wizardClass.getConstructor(WizardContext.class);
                Object wizardObj = c.newInstance(this.context);
                if (!(wizardObj instanceof BasicProcessWizard)) return (IWizardStep)wizardObj;
                ((BasicProcessWizard)((Object)wizardObj)).initProcessWizardInfo(this.dsProcessList.getSelectedDes());
                return (IWizardStep)wizardObj;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        } else {
            this.context.discardOutput();
        }
        return null;
    }

    protected Element getDesignInfo(String processor) {
        Element e = new Element(T_SELECT_PROCESSOR);
        e.setAttribute(A_PROCESSOR, processor);
        return e;
    }

    @Override
    public IDataProcessModel getModel() {
        return null;
    }

    @Override
    public void setModel(IDataProcessModel model) {
    }
}

