/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.process.add_columns;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.ui.MultiLangUI;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.formulawizard.FormulaWizard;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.MultiLangItemList;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Column;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.reportone.data.wizard.formula.FormulaWizardUIHelper;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.PKIncludedTablePanel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.Process2Resource;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;

public class ColumnsTablePanel
extends PKIncludedTablePanel {
    private static int COL_NAME = 0;
    private static int COL_ALIAS = 1;
    private static int COL_DATA_TYPE = 2;
    private static int COL_EXPR = 3;
    protected List externalPs;
    protected List externalEnv;
    protected List readOnlyColumns;
    protected HashSet reservedColumns = new HashSet();
    protected KDMultiLangBox mlbAlias;

    public ColumnsTablePanel() {
        super(3, true);
        this.initTable();
    }

    private void initTable() {
        this.table.addColumns(4);
        IRow headRow = this.table.addHeadRow();
        headRow.getCell(COL_NAME).setValue((Object)Process2Resource.getString("res_2"));
        headRow.getCell(COL_ALIAS).setValue((Object)Process2Resource.getString("res_3"));
        headRow.getCell(COL_DATA_TYPE).setValue((Object)Process2Resource.getString("res_4"));
        headRow.getCell(COL_EXPR).setValue((Object)Process2Resource.getString("res_5"));
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)new KDComboBox((Object[])DataType.ALL_TYPES));
        this.table.getColumn(COL_DATA_TYPE).setEditor((ICellEditor)cellEditor);
        this.table.getColumn(COL_NAME).setWidth(180);
        this.table.getColumn(COL_ALIAS).setWidth(140);
        this.mlbAlias = MultiLangUI.newKDMultiLangBox();
        this.mlbAlias.setMaxLength(32);
        this.table.getColumn(COL_ALIAS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.mlbAlias));
        this.mlbAlias.putClientProperty((Object)"All_Modal", (Object)Boolean.TRUE);
        this.setPkColumn(COL_NAME);
        this.table.getSelectManager().addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                if (e.getColumnIndex() == COL_EXPR) {
                    ColumnsTablePanel.this.table.getColumn(COL_EXPR).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)ColumnsTablePanel.this.makeFormulaWizardBox()));
                }
            }
        });
    }

    @Override
    protected void onClickBT(int btVal) {
        if (btVal != 1) {
            boolean enable;
            int row = this.table.getSelectManager().getActiveRowIndex();
            Object selName = this.table.getRow(row).getCell(COL_NAME).getValue();
            boolean bl = enable = !this.reservedColumns.contains(selName);
            if (!enable) {
                return;
            }
        }
        super.onClickBT(btVal);
        if (btVal == 1) {
            this.table.getRow(this.table.getRowCount() - 1).getCell(COL_DATA_TYPE).setValue((Object)DataType.STRING);
        }
    }

    public void setReservedColumns(String[] columns) {
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                this.reservedColumns.add(columns[i]);
            }
        }
    }

    public String[] getNewColumns() {
        int rows = this.table.getRowCount();
        String[] rv = new String[rows - this.reservedColumns.size()];
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = (String)this.table.getRow(this.reservedColumns.size() + i).getCell(COL_NAME).getValue();
        }
        return rv;
    }

    public DataType[] getNewDataTypes() {
        int rows = this.table.getRowCount();
        DataType[] rv = new DataType[rows - this.reservedColumns.size()];
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = (DataType)this.table.getRow(this.reservedColumns.size() + i).getCell(COL_DATA_TYPE).getValue();
        }
        return rv;
    }

    public String[] getNewExprs() {
        int rows = this.table.getRowCount();
        String[] rv = new String[rows - this.reservedColumns.size()];
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = (String)this.table.getRow(this.reservedColumns.size() + i).getCell(COL_EXPR).getValue();
        }
        return rv;
    }

    public Map[] getNewAliases() {
        List list = this.getAddedColumns();
        Map[] aliases = new Map[list.size()];
        for (int i = 0; i < aliases.length; ++i) {
            aliases[i] = ((Column)((Object)list.get(i))).getProperties();
        }
        return aliases;
    }

    public void setColumns(List ocs) {
        this.table.removeRows();
        this.readOnlyColumns = new ArrayList();
        for (int i = 0; i < ocs.size(); ++i) {
            OutputColumn oc = (OutputColumn)((Object)ocs.get(i));
            IRow newRow = this.table.addRow();
            newRow.getCell(COL_NAME).setValue((Object)oc.getName());
            newRow.getCell(COL_ALIAS).setValue((Object)oc.getAlias());
            newRow.getCell(COL_DATA_TYPE).setValue((Object)oc.getDataType());
            newRow.getCell(COL_EXPR).setValue((Object)oc.getExpr());
            if (this.reservedColumns.contains(oc.getName())) {
                newRow.getStyleAttributes().setLocked(true);
                newRow.getStyleAttributes().setBackground(Color.lightGray);
                this.readOnlyColumns.add(oc);
                continue;
            }
            MultiLangItem[] items = MultiLangUI.toMultiLangItems((Map)oc.getProperties(), (String)"alias");
            MultiLangItemList itemList = new MultiLangItemList(items);
            itemList.setCurrentItem(items[1]);
            newRow.getCell(COL_ALIAS).setValue((Object)itemList);
        }
        if (this.table.getRowCount() > 0) {
            KDTableUtil.setSelectedRow((KDTable)this.table, (int)0);
        }
    }

    private List getAllColumns() {
        ArrayList list = new ArrayList();
        list.addAll(this.readOnlyColumns);
        list.addAll(this.getAddedColumns());
        return list;
    }

    public List getAddedColumns() {
        OutputColumns list = new OutputColumns();
        int rows = this.table.getRowCount();
        for (int i = this.reservedColumns.size(); i < rows; ++i) {
            IRow row = this.table.getRow(i);
            OutputColumn oc = new OutputColumn();
            MultiLangItemList itemList = (MultiLangItemList)row.getCell(COL_ALIAS).getValue();
            if (itemList != null) {
                Map alias_attrs = oc.getProperties();
                MultiLangUI.fromMultiLangItems((MultiLangItem[])itemList.getItems(), (Map)alias_attrs, (String)"alias");
                alias_attrs.put("alias", "#1");
            }
            oc.setName((String)row.getCell(COL_NAME).getValue());
            oc.setDataType((DataType)row.getCell(COL_DATA_TYPE).getValue());
            oc.setExpr((String)row.getCell(COL_EXPR).getValue());
            list.add(oc);
        }
        return list;
    }

    @Override
    protected void notifyPKConflict(KDTEditEvent e) {
        WindowUtil.alert((Component)((Component)e.getSource()), (String)Process2Resource.getString("res_6"));
    }

    private KDPromptBox makeFormulaWizardBox() {
        KDPromptBox box = new KDPromptBox();
        box.setEditable(true);
        KDPromptSelector wizardSelector = new KDPromptSelector(){
            private String value;
            private boolean isCanceled = false;

            public void show() {
                FormulaWizardUIHelper uiHelper = new FormulaWizardUIHelper();
                uiHelper.update(ColumnsTablePanel.this.externalPs, ColumnsTablePanel.this.getAllColumns());
                FormulaWizard wizardPanel = uiHelper.getFormulaWizardPanel();
                Object valObj = KDTableUtil.getSelectedRow((KDTable)ColumnsTablePanel.this.table).getCell(COL_EXPR).getValue();
                if (valObj instanceof String) {
                    wizardPanel.setResult((String)valObj);
                } else {
                    wizardPanel.setResult("");
                }
                boolean bl = this.isCanceled = !WindowUtil.showSimpleDialog((Component)wizardPanel, (Component)((Object)ColumnsTablePanel.this), (String)Process2Resource.getString("res_7"), null);
                if (!this.isCanceled) {
                    this.value = wizardPanel.getResult();
                }
            }

            public boolean isCanceled() {
                return this.isCanceled;
            }

            public Object getData() {
                return this.value;
            }
        };
        box.setSelector(wizardSelector);
        return box;
    }

    public final void setExternalPs(List externalPs) {
        this.externalPs = externalPs;
    }

    public final void setExternalEnv(List externalEnv) {
        this.externalEnv = externalEnv;
    }
}

