/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.query;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.MultiLangUI;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.MultiLangItemList;
import com.kingdee.bos.ctrl.reportone.data.modal.Outputs;
import com.kingdee.bos.ctrl.reportone.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Column;
import com.kingdee.bos.ctrl.reportone.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.reportone.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.reportone.data.wizard.framework.datadef.DefaultCommonQueryWizardModel;
import com.kingdee.bos.ctrl.reportone.data.wizard.framework.query.AbstractQueryWizardTabbedUI;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.PKIncludedTablePanel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.Process2Resource;
import com.kingdee.bos.ctrl.reportone.data.wizard.query.PreviewKSQLPanel;
import com.kingdee.bos.ctrl.reportone.reportimpl.xquery.IXQueryRptExecutor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class OutputFieldsWizardUI
extends AbstractQueryWizardTabbedUI {
    private static final Logger log = LogUtil.getPackageLogger(OutputFieldsWizardUI.class);
    private WizardPanel wizardPanel;

    @Override
    protected KDPanel createPanel() {
        this.wizardPanel = new WizardPanel();
        return this.wizardPanel;
    }

    @Override
    public void syncModel2Ui() {
        DefaultCommonQueryWizardModel model = (DefaultCommonQueryWizardModel)this.getModel();
        Outputs outputs = model.getCommonQuery().getOutputs();
        if (outputs != null) {
            this.wizardPanel.fieldsPanel.setFields((OutputColumns)outputs.get(0));
        }
    }

    @Override
    public void syncUi2Model() {
        DefaultCommonQueryWizardModel model = (DefaultCommonQueryWizardModel)this.getModel();
        Outputs outputs = model.getCommonQuery().getOutputs();
        if (outputs == null) {
            outputs = new Outputs();
            model.getCommonQuery().setOutputs(outputs);
        }
        outputs.clear();
        outputs.add(this.wizardPanel.fieldsPanel.getFields());
    }

    public String getTabbedTitle() {
        return "\u8f93\u51fa\u5b57\u6bb5";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fillOutputFieldsTable() throws Exception {
        DefaultCommonQueryWizardModel model = (DefaultCommonQueryWizardModel)this.getModel();
        IQuery quer = model.getQuery();
        if (quer.getQueryType() != QueryType.SQL_WIZARD && quer.getQueryType() != QueryType.SQL_CUSTOM) throw new UnsupportedOperationException();
        Object columns = null;
        if (quer.getQueryType() == QueryType.SQL_WIZARD) {
            columns = quer.getColumns();
        } else {
            IXQueryRptExecutor executor = model.getXQueryExecutor();
            try {
                List list = model.getCommonQuery().getParameters();
                HashMap args = ParamUtil.makeDefaultArgs2(list);
                executor.execute(args == null ? new HashMap() : args);
                IRowSet rs100 = executor.nextPage(1);
                columns = PreviewKSQLPanel.parseRSMD(rs100.getMetaData());
                rs100.close();
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    executor.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.wizardPanel.fieldsPanel.setFields((List)columns);
    }

    public static class OutputFieldsPanel
    extends PKIncludedTablePanel {
        private static int COL_NAME = 0;
        private static int COL_ALIAS = 1;
        private static int COL_DATA_TYPE = 2;
        protected List externalPs;
        protected List externalEnv;
        protected List readOnlyColumns;
        protected KDMultiLangBox mlbAlias;

        public OutputFieldsPanel() {
            super(0, true);
            this.initTable();
        }

        private void initTable() {
            this.table.addColumns(4);
            IRow headRow = this.table.addHeadRow();
            headRow.getCell(COL_NAME).setValue((Object)Process2Resource.getString("res_2"));
            headRow.getCell(COL_ALIAS).setValue((Object)Process2Resource.getString("res_3"));
            headRow.getCell(COL_DATA_TYPE).setValue((Object)Process2Resource.getString("res_4"));
            KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)new KDComboBox((Object[])DataType.ALL_TYPES));
            this.table.getColumn(COL_DATA_TYPE).setEditor((ICellEditor)cellEditor);
            this.table.getColumn(COL_NAME).setWidth(180);
            this.table.getColumn(COL_ALIAS).setWidth(140);
            this.mlbAlias = MultiLangUI.newKDMultiLangBox();
            this.mlbAlias.setMaxLength(32);
            this.table.getColumn(COL_ALIAS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.mlbAlias));
            this.mlbAlias.putClientProperty((Object)"All_Modal", (Object)Boolean.TRUE);
            this.setPkColumn(COL_NAME);
        }

        public void setFields(List ocs) {
            this.table.removeRows();
            this.readOnlyColumns = new ArrayList();
            for (int i = 0; i < ocs.size(); ++i) {
                Column oc = (Column)((Object)ocs.get(i));
                IRow newRow = this.table.addRow();
                newRow.getCell(COL_NAME).setValue((Object)oc.getName());
                newRow.getCell(COL_ALIAS).setValue((Object)oc.getAlias());
                newRow.getCell(COL_DATA_TYPE).setValue((Object)oc.getDataType());
                MultiLangItem[] items = MultiLangUI.toMultiLangItems((Map)oc.getProperties(), (String)"alias");
                MultiLangItemList itemList = new MultiLangItemList(items);
                itemList.setCurrentItem(items[1]);
                newRow.getCell(COL_ALIAS).setValue((Object)itemList);
            }
            if (this.table.getRowCount() > 0) {
                KDTableUtil.setSelectedRow((KDTable)this.table, (int)0);
            }
        }

        public OutputColumns getFields() {
            OutputColumns list = new OutputColumns();
            int rows = this.table.getRowCount();
            for (int i = 0; i < rows; ++i) {
                IRow row = this.table.getRow(i);
                OutputColumn oc = new OutputColumn();
                MultiLangItemList itemList = (MultiLangItemList)row.getCell(COL_ALIAS).getValue();
                if (itemList != null) {
                    Map alias_attrs = oc.getProperties();
                    MultiLangUI.fromMultiLangItems((MultiLangItem[])itemList.getItems(), (Map)alias_attrs, (String)"alias");
                    alias_attrs.put("alias", "#1");
                }
                oc.setName((String)row.getCell(COL_NAME).getValue());
                oc.setDataType((DataType)row.getCell(COL_DATA_TYPE).getValue());
                list.add(oc);
            }
            return list;
        }
    }

    class WizardPanel
    extends KDPanel {
        private KDWorkButton btMakeOutputColumns = new KDWorkButton("\u751f\u6210\u8f93\u51fa\u5b57\u6bb5");
        private OutputFieldsPanel fieldsPanel = new OutputFieldsPanel();

        public WizardPanel() {
            TableLayout layout = TableLayout.split((int)2, (int)1);
            this.setLayout((LayoutManager)layout);
            Table top = layout.cell(0).split(1, 2);
            this.add((Component)this.btMakeOutputColumns, top.cell(1));
            top.colStyle(0).setPriX(1);
            top.colStyle(1).setWidth(100);
            this.add((Component)((Object)this.fieldsPanel), layout.cell(1));
            layout.rowStyle(1).setPriY(1);
            this.btMakeOutputColumns.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        OutputFieldsWizardUI.this.fillOutputFieldsTable();
                    }
                    catch (Exception ex) {
                        log.error((Object)"", (Throwable)ex);
                    }
                }
            });
        }
    }
}

