/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas;

import com.kingdee.bos.ctrl.common.ui.tree.INodeFilter;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.reportone.data.engine.BindVariants;
import com.kingdee.bos.ctrl.reportone.data.engine.KsqlTextVariantsSolver;
import com.kingdee.bos.ctrl.reportone.data.framework.bos.BosUtil;
import com.kingdee.bos.ctrl.reportone.data.framework.connection.DataSourceType;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.ADataSource;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.DataSourceException;
import com.kingdee.bos.ctrl.reportone.data.invoke.IDataExecutor;
import com.kingdee.bos.ctrl.reportone.data.invoke.SimpleSqlTempTableResult;
import com.kingdee.bos.ctrl.reportone.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_DataEnvProvider;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_KdrsUtil;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_Query2SQL;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;

public class Eas_DataSource
extends ADataSource {
    public static final String ArgsKey_BosConnectionWrapper = "bosConnectionWrapper";
    private IBizContent bizCnt;
    private INodeFilter filter;

    public Eas_DataSource(IBizContent bizCnt, INodeFilter filter) throws KDRSException {
        this.bizCnt = bizCnt;
        this.filter = filter;
    }

    @Override
    public MetaLibrary getMetaLibrary() throws DataSourceException {
        MetaLibrary lib = super.getMetaLibrary();
        if (lib == null) {
            try {
                lib = Eas_KdrsUtil.newEasMetaLibrary(this.bizCnt, this.filter);
                this.setMetaLibrary(lib);
            }
            catch (KDRSException e) {
                throw new DataSourceException("\u521d\u59cb\u5316\u5143\u6570\u636e\u5e93\u5931\u8d25", e);
            }
        }
        return lib;
    }

    @Override
    public DataSourceType getDSType() {
        return DataSourceType.BOS;
    }

    @Override
    public Object execute(String category, Object object, HashMap args, IDataExecutor externalExec) throws Exception {
        if (object instanceof IQuery) {
            IQuery query = (IQuery)object;
            String sql = Eas_Query2SQL.newServerInstance().buildSQL(query);
            sql = !sql.startsWith("/*dialect*/") ? KsqlTextVariantsSolver.solve(sql, args, true) : BindVariants.replaceVariants2(sql, args, true);
            Object mode = args.get("executeMode");
            if ("SQL".equals(mode)) {
                return sql;
            }
            if ("SQL_TEMP".equals(mode)) {
                return new SimpleSqlTempTableResult(sql, new Eas_DataEnvProvider(null).getTempTableManager());
            }
            if ("RESULT_SET".equals(mode)) {
                Connection connection = (Connection)args.get(ArgsKey_BosConnectionWrapper);
                if (connection == null) {
                    try {
                        throw new R1Exception("Who call me without connection.");
                    }
                    catch (R1Exception ex) {
                        LogUtil.getPackageLogger(Eas_DataSource.class).info((Object)"", (Throwable)ex);
                        connection = BosUtil.getDBConnection();
                    }
                }
                try {
                    return DBUtil.executeSql((Connection)connection, (String)sql);
                }
                catch (SQLException ex) {
                    throw new DataSourceException(ex);
                }
            }
            throw new Exception("Illegal execute_mode parameter. ");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getMCTemplate(String pathX) throws DataSourceException {
        try {
            return this.bizCnt.readTemplate("/EAS_Report.kdrs" + pathX);
        }
        catch (KDRSException ex) {
            throw new DataSourceException("", ex);
        }
    }
}

