/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.actions;

import com.kingdee.bos.ctrl.common.ui.RenameDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUtil;
import com.kingdee.bos.ctrl.common.util.MapUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.ClientResource;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.actions.AbstractStorageResActionHandler;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.actions.ClipPathsInfo;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreePath;

public class ActionPaste
extends AbstractStorageResActionHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onAction() throws Exception {
        ClipPathsInfo clipInfo = super.getBizStorageTreeCtrl().getClipPathsInfo();
        String[] fromPaths = clipInfo.getPathTexts();
        if (fromPaths == null) {
            return true;
        }
        String fromFolder = PathUtil.getParentPath((String)fromPaths[0]);
        String toFolder = this.getResNode().getResPath();
        boolean isSameFolder = toFolder.equals(fromFolder);
        if (isSameFolder && clipInfo.isCut()) {
            return true;
        }
        String[] toPaths_relative = new String[fromPaths.length];
        IBizStorage bizSto = this.getBizStorage();
        RenameDialog dlg = null;
        boolean dirty = false;
        HashMap alias = null;
        try {
            for (int i = 0; i < fromPaths.length; ++i) {
                Path destPath;
                String fromPath = fromPaths[i];
                String name = PathUtil.getLastName((String)fromPath);
                String toPath = PathUtil.makeChildPath((String)toFolder, (String)name);
                String error = null;
                Path srcPath = Path.valueOf(fromPath);
                if (srcPath.isFatherOf(destPath = Path.valueOf(toPath), false)) {
                    error = ClientResource.getString("res_173");
                }
                if (error != null) {
                    WindowUtil.showException((String)error, null, (String)ClientResource.getString("res_132"), (Component)this.getTreeUI());
                    break;
                }
                if (isSameFolder) {
                    while (bizSto.isExist(toPath)) {
                        if (dlg == null) {
                            dlg = (RenameDialog)WindowUtil.createWindow(RenameDialog.class, (Component)this.getTreeUI());
                        }
                        dlg.setHideExtNames(RenameDialog.SupportHideAllExtName);
                        dlg.setOldName(name);
                        if (!dlg.showDialog()) {
                            throw new UserCancelException();
                        }
                        name = dlg.getNewName();
                        alias = dlg.getNewAlias();
                        toPath = PathUtil.makeChildPath((String)toFolder, (String)name);
                    }
                } else if (bizSto.isExist(toPath)) {
                    if (!this.checkHasOverwritePermission(toPath)) continue;
                    if (!WindowUtil.msgboxYesNo((Component)this.getTreeUI(), (Object)(toPath + ClientResource.getString("res_133")), (String)ClientResource.getString("res_134"))) {
                        throw new UserCancelException();
                    }
                    if (clipInfo.isCut()) {
                        bizSto.delete(toPath);
                    }
                }
                if (clipInfo.isCut()) {
                    bizSto.rename(fromPath, toPath);
                    dirty = true;
                } else {
                    bizSto.copy(fromPath, toPath);
                    this.delPermission(toPath);
                    this.giveCopierPermission(toPath);
                    dirty = true;
                }
                if (alias != null) {
                    HashMap atts = new HashMap();
                    MapUtil.addKeyPrefix((Map)alias, (String)"alias.", atts);
                    bizSto.setAttributes(toPath, atts);
                    alias = null;
                }
                toPaths_relative[i] = this.getTreeController().getRelativePathText(toPath);
            }
        }
        finally {
            if (dirty) {
                TreeUINode tnFromFolder;
                TreeUI tree = this.getTreeUI();
                TreeUINode tnRoot = tree.getRootNode();
                ResObjectNode tnToFolder = this.getResNode();
                if (tnToFolder.isChildrenLoaded()) {
                    tree.refreshNode((TreeUINode)tnToFolder);
                } else {
                    tree.expand(new TreePath(tnToFolder.getPath()));
                }
                if (!isSameFolder && clipInfo.isCut() && (tnFromFolder = TreeUtil.findTreeNode((TreeUINode)tnRoot, (String)this.getTreeController().getRelativePathText(fromFolder))) != null) {
                    tnFromFolder.setChildrenLoaded(true);
                    tree.refreshNode(tnFromFolder);
                    tree.setSelectionNode(tnFromFolder);
                }
            }
            clipInfo.setEmpty();
            clipInfo.setPathTexts(null);
            this.promptNoOverwritePermission();
        }
        return true;
    }

    protected boolean checkHasOverwritePermission(String toPath) throws Exception {
        return true;
    }

    protected void promptNoOverwritePermission() {
    }

    protected void giveCopierPermission(String toPath) throws Exception {
    }

    protected void delPermission(String toPath) throws Exception {
    }
}

