/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.content;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.ReflectUtil;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.IDataSourceFactory;
import com.kingdee.bos.ctrl.reportone.data.invoke.IDataEnvProvider;
import com.kingdee.bos.ctrl.reportone.data.invoke.IDataExecutor;
import com.kingdee.bos.ctrl.reportone.data.invoke.SimpleDataEnvProvider;
import com.kingdee.bos.ctrl.reportone.data.invoke.SimpleDataExecutor;
import com.kingdee.bos.ctrl.reportone.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.KdrsResource;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContentStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent_DSFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.ReportManager;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.objects.CustomDataX;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.objects.IStoredDataX;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidParameterException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.IStoredObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.StoredObjectFactory;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.execute.IReportExecutor;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BizContent
extends BizContentStorage
implements IBizContent {
    public static final Logger log = LogUtil.getLogger(BizContent.class);
    public static final String ARG_String_category = ParamUtil.makeArgName("ARG_String_category", BizContent.class);
    public static final String ARG_bytes_template = ParamUtil.makeArgName("ARG_bytes_template", BizContent.class);
    public static final String ANONYMOUS_REPORT = "0xffff";
    private IDataSourceFactory dsFactory;
    private IDataEnvProvider envProvider;

    public BizContent() {
    }

    public BizContent(StoredObjectFactory objectFactory) {
        super(objectFactory);
    }

    protected IDataSourceFactory newDSFactory() {
        return new BizContent_DSFactory(this);
    }

    protected IDataSourceFactory getDSFactory() {
        this.dsFactory = this.newDSFactory();
        return this.dsFactory;
    }

    protected IDataEnvProvider newEnvProvider() {
        return new SimpleDataEnvProvider();
    }

    protected IDataEnvProvider getEnvProvider() {
        if (this.envProvider == null) {
            this.envProvider = this.newEnvProvider();
        }
        return this.envProvider;
    }

    private String makeAnonymousCall(String rptPath, HashMap args) throws KDRSException {
        return this.executeStart(rptPath, args);
    }

    @Override
    public Object executeCall(String objId, String method, String[] argTypeNames, Object[] args) throws KDRSException {
        boolean isAnonymousCall = false;
        if (ANONYMOUS_REPORT.equals(objId)) {
            isAnonymousCall = true;
            objId = this.makeAnonymousCall((String)args[0], (HashMap)args[1]);
            String[] typeNames2 = new String[argTypeNames.length - 2];
            System.arraycopy(argTypeNames, 2, typeNames2, 0, typeNames2.length);
            argTypeNames = typeNames2;
            Object[] args2 = new Object[args.length - 2];
            System.arraycopy(args, 2, args2, 0, args2.length);
            args = args2;
        }
        Class[] argTypes = null;
        if (argTypeNames != null) {
            argTypes = new Class[argTypeNames.length];
            try {
                for (int i = 0; i < argTypeNames.length; ++i) {
                    argTypes[i] = ReflectUtil.getTypeClass((String)argTypeNames[i]);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidParameterException(ex);
            }
        }
        try {
            Object ex = ReportManager.invokeReport(objId, method, argTypes, args);
            return ex;
        }
        catch (Throwable ex) {
            throw KDRSException.makeException(KdrsResource.getString("res_11"), ex);
        }
        finally {
            if (isAnonymousCall) {
                this.executeEnd(objId);
            }
        }
    }

    @Override
    public void executeEnd(String objId) throws KDRSException {
        try {
            ReportManager.closeReport(objId);
        }
        catch (ReportException ex) {
            throw KDRSException.makeException(KdrsResource.getString("res_12"), ex);
        }
    }

    @Override
    public String executeStart(String objPath, HashMap args) throws KDRSException {
        IStoredDataX execObject = null;
        if (objPath != null) {
            IStoredObject obj = this.checkObject(Path.valueOf(objPath), null, true);
            if (obj instanceof IStoredDataX) {
                execObject = (IStoredDataX)obj;
            }
        } else {
            byte[] template = (byte[])args.get(ARG_bytes_template);
            execObject = new CustomDataX((String)args.remove(ARG_String_category), template);
        }
        if (args == null) {
            args = new HashMap();
        }
        try {
            IDataExecutor dataExecutor = this.newDataExecutor();
            IReportExecutor executor = execObject.getReportExecutor(dataExecutor);
            return ReportManager.executeReport(executor, args, this);
        }
        catch (ReportException ex) {
            throw KDRSException.makeException(KdrsResource.getString("res_13"), ex);
        }
    }

    protected IDataExecutor newDataExecutor() {
        return new SimpleDataExecutor(this.getDSFactory());
    }

    @Override
    public String viewHistory(String pathText, String name) throws KDRSException {
        return null;
    }

    @Override
    public String viewSnapshot(String pathText) throws KDRSException {
        return null;
    }

    @Override
    public String createSnapshot(String objPath, HashMap atts) throws KDRSException {
        return null;
    }
}

