/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.content;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.MapUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.actions.MutiLanguage;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.NameDialog;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BizResource;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent_StreamStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.reportone.reportframework.AObjectStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class BizContent_LazyObjectStorage
extends AObjectStorage {
    private Class realObjectStorageCls;
    private IBizContent bizContent;
    private String parentPath;
    private String category;
    private Component uiOwner;
    private Object object;
    private IOutputObjectHook outputObjectHook;

    public BizContent_LazyObjectStorage(IBizContent bizContent, String parentPath, Class realObjectStorageCls, String category, Component uiOwner) {
        this.bizContent = bizContent;
        this.realObjectStorageCls = realObjectStorageCls;
        this.parentPath = parentPath;
        this.category = category;
        this.uiOwner = uiOwner;
    }

    @Override
    public Object getInputObject() throws ReportException {
        return this.object;
    }

    protected String getObjectCategory(Object obj) {
        return this.category;
    }

    @Override
    public void setOutputObject(Object obj) throws ReportException {
        HashMap attrs = null;
        boolean success = false;
        String objPath = null;
        if (this.object == null) {
            try {
                this.category = this.getObjectCategory(obj);
                attrs = new HashMap();
                objPath = this.createWithinNameDialog(this.category, attrs);
            }
            catch (Exception ex) {
                throw ReportException.makeException(BizResource.getString("res_4"), ex);
            }
        }
        this.object = obj;
        BizContent_StreamStorage stremStoage = new BizContent_StreamStorage(this.bizContent, objPath);
        try {
            Constructor c = this.realObjectStorageCls.getConstructor(IStreamStorage.class);
            AObjectStorage objSto = (AObjectStorage)c.newInstance(stremStoage);
            if (this.outputObjectHook != null) {
                this.outputObjectHook.prepairOutputObject(obj, this.category, attrs);
            }
            objSto.setOutputObject(obj);
            success = true;
        }
        catch (Exception ex) {
            throw ReportException.makeException(null, ex);
        }
        finally {
            if (this.outputObjectHook != null) {
                this.outputObjectHook.afterOutputObject(obj, this.category, objPath, attrs, success);
            }
        }
    }

    private String createWithinNameDialog(String category, HashMap atts) throws KDRSException {
        if (atts == null) {
            atts = new HashMap<String, String>();
        }
        NameDialog dlg = (NameDialog)((Object)WindowUtil.createWindow(NameDialog.class, (Component)this.uiOwner));
        while (true) {
            if (!dlg.showDialog()) {
                throw new UserCancelException();
            }
            String objPath = PathUtil.makeChildPath((String)this.parentPath, (String)(dlg.getNewName() + "." + category));
            if (!this.bizContent.isExist(objPath)) break;
            WindowUtil.msgboxError((Object)MutiLanguage.getMLS("nameUsed", BizResource.getString("res_5")), (String)MutiLanguage.getMLS("new", BizResource.getString("res_6")), (Component)((Object)dlg));
        }
        atts.put("alias", "#1");
        MapUtil.addKeyPrefix((Map)dlg.getNewAlias(), (String)"alias.", atts);
        String namex = FullPath.addCategory((String)dlg.getNewName(), (String)category);
        String objPath = PathUtil.makeChildPath((String)this.parentPath, (String)namex);
        atts.put("category", category);
        atts.put("name", namex);
        this.bizContent.create(objPath, atts);
        return objPath;
    }

    public void setOutputObjectHook(IOutputObjectHook outputObjectHook) {
        this.outputObjectHook = outputObjectHook;
    }

    public static interface IOutputObjectHook {
        public void prepairOutputObject(Object var1, String var2, HashMap var3);

        public void afterOutputObject(Object var1, String var2, String var3, HashMap var4, boolean var5);
    }
}

