/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.storage;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.ArrayUtil;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.KdrsResource;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.ISession;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.AbstractServerSideBizObject;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.IServerSideSession;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidParameterException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizStorage
extends AbstractServerSideBizObject
implements IBizStorage {
    public static final Logger log = LogUtil.getPackageLogger(BizStorage.class);
    public static final Object NOT_META_ATT = new Object();
    private static final String[] META_ATT_NAMES = new String[]{"name", "type", "size"};
    private IStorage storage;

    public BizStorage() {
        this(null);
    }

    public BizStorage(IStorage storage) {
        this.storage = storage;
    }

    @Override
    public void disconnetSession() throws KDRSException {
        super.disconnetSession();
        this.storage = null;
    }

    @Override
    public void attachToSessoin(ISession session) throws KDRSException {
        super.attachToSessoin(session);
        this.storage = ((IServerSideSession)session).getStorage();
    }

    private final Object getOriginalAttrVal(Path path, HashMap defaultAttrs, Object key) throws KDRSException {
        if ("type".equals(key)) {
            String resType = defaultAttrs == null ? null : (String)defaultAttrs.get(key);
            return resType != null ? resType : this.storage.getType(path).getName();
        }
        if ("size".equals(key) && this.storage.getType(path) == ResourceType.FILE) {
            return String.valueOf(this.storage.getFileLength(path));
        }
        return NOT_META_ATT;
    }

    @Override
    public boolean isExist(String pathText) throws KDRSException {
        Path path = super.checkPath(pathText);
        if (log.isDebugEnabled()) {
            log.debug((Object)("isExist('" + path + "')"));
        }
        return this.storage.isExist(path);
    }

    @Override
    public boolean isAtomic(String pathText) throws KDRSException {
        Path path = super.checkPath(pathText);
        if (log.isDebugEnabled()) {
            log.debug((Object)("isAtomic('" + path + "')"));
        }
        return this.storage.getType(path) == ResourceType.FILE;
    }

    @Override
    public void create(String pathText, HashMap attrs) throws KDRSException {
        Path path = super.checkPath(pathText);
        if (log.isDebugEnabled()) {
            log.debug((Object)("create('" + path + "'," + attrs + ")"));
        }
        StorageUtil.checkIsNotRoot(path);
        StorageUtil.checkResourceName(path.getName());
        StorageUtil.checkAttrsNameLength(attrs);
        ResourceType resType = ResourceType.FILE;
        int policy = 1;
        if (attrs != null) {
            Object type = (attrs = (HashMap)attrs.clone()).get("type");
            if (type != null && (resType = ResourceType.valueOf(type.toString())) == null) {
                throw new InvalidParameterException("Invalid resource type:" + type);
            }
            Object policyObj = attrs.remove("create_policy");
            if (policyObj != null) {
                policy = 1 | Integer.parseInt(String.valueOf(policyObj));
            }
        }
        this.create(path, resType, policy, attrs, true);
    }

    private void create(Path path, ResourceType resType, int policy, HashMap attrs, boolean needPatchSysAttrs) throws KDRSException {
        attrs = CtrlUtil.Obj.cloneHashMap((HashMap)attrs);
        if (needPatchSysAttrs) {
            attrs = this.addCreationAttrs(attrs);
        }
        KDRSException kdrsException = null;
        if ((policy & 1) == 1) {
            try {
                this.storage.create(path, resType, attrs);
                return;
            }
            catch (AlreadyExistsException ex) {
                if ((policy & 0x10) == 16) {
                    policy |= 4;
                }
                kdrsException = ex;
            }
            catch (NotFoundException ex) {
                if ((policy & 0x10) == 16) {
                    policy |= 2;
                }
                kdrsException = ex;
            }
        }
        boolean done = false;
        if (kdrsException instanceof AlreadyExistsException || this.storage.isExist(path)) {
            if ((policy & 4) == 4) {
                this.setAttributes(path.getPathText(), attrs);
                done = true;
            }
            if ((policy & 8) == 8) {
                if (this.storage.getType(path) == ResourceType.FOLDER) {
                    this.delete(path, true);
                } else {
                    StorageUtil.clearFileData(this.storage, path);
                }
                done = true;
            }
        } else if ((policy & 2) == 2) {
            Path[] pathes = path.paths();
            for (int i = 1; i < pathes.length; ++i) {
                try {
                    if (i == pathes.length - 1) {
                        this.create(pathes[i], resType, 1, attrs, false);
                        continue;
                    }
                    this.create(pathes[i], ResourceType.FOLDER, 1, null, true);
                    continue;
                }
                catch (AlreadyExistsException alreadyExistsException) {
                    // empty catch block
                }
            }
            done = true;
        }
        if (!done) {
            if (kdrsException != null) {
                throw kdrsException;
            }
            throw new InvalidParameterException("Unkown policy for creating resource. policy=" + policy);
        }
    }

    protected HashMap addCreationAttrs(HashMap attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, String>();
        }
        if (null != null) {
            // empty if block
        }
        long current = System.currentTimeMillis();
        attrs.put("time", "" + current);
        attrs.put("last-modified", "" + current);
        return attrs;
    }

    @Override
    public void delete(String pathText) throws KDRSException {
        Path path = super.checkPath(pathText);
        if (log.isDebugEnabled()) {
            log.debug((Object)("delete('" + path + "')"));
        }
        this.delete(path, false);
    }

    private void delete(Path path, boolean onlyClearChildren) throws KDRSException {
        boolean isFolder;
        boolean bl = isFolder = ResourceType.FOLDER == this.storage.getType(path);
        if (isFolder) {
            String[] children = this.storage.listChildren(path);
            for (int i = 0; i < children.length; ++i) {
                this.delete(path.getChild(children[i]), false);
            }
        } else {
            onlyClearChildren = false;
        }
        if (!onlyClearChildren) {
            this.storage.delete(path);
        }
    }

    @Override
    public void rename(String pathText, String newText) throws KDRSException {
        Path path = super.checkPath(pathText);
        if (log.isDebugEnabled()) {
            log.debug((Object)("rename('" + path + "','" + newText + "')"));
        }
        Path toPath = null;
        boolean isMove = false;
        if (!Path.isSimpleName(newText)) {
            toPath = StorageUtil.checkPathText(newText);
            if (!toPath.getParent().equals(path.getParent())) {
                isMove = true;
            } else {
                newText = toPath.getName();
            }
        }
        if (isMove) {
            StorageUtil.checkResourceName(toPath.getName());
            this.storage.move(path, toPath);
        } else {
            StorageUtil.checkResourceName(newText);
            this.storage.rename(path, newText);
        }
    }

    private final Object getAttrVal(Path path, HashMap attrs, Object key) throws KDRSException {
        Object val = this.getOriginalAttrVal(path, attrs, key);
        if (val != NOT_META_ATT) {
            return val;
        }
        if (attrs == null) {
            return null;
        }
        val = attrs.get(key);
        if ("#1".equals(val)) {
            if (attrs == null) {
                return null;
            }
            ISession session = super.getSession();
            val = session != null ? attrs.get(key + "." + session.getProperty("lang")) : attrs.get(key + "." + LangUtil.makeDefaultLang());
        }
        return val;
    }

    @Override
    public HashMap getAttributes(String pathText, String[] keys) throws KDRSException {
        HashMap rv;
        Path path = super.checkPath(pathText);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAttributes('" + path + "',{" + ArrayUtil.objectArray2String((Object[])keys, (String)",") + "})"));
        }
        HashMap atts = this.storage.getAttributes(path);
        if (keys == null) {
            rv = atts != null ? atts : new HashMap();
            keys = META_ATT_NAMES;
        } else {
            rv = new HashMap();
        }
        for (int i = 0; i < keys.length; ++i) {
            rv.put(keys[i], this.getAttrVal(path, atts, keys[i]));
        }
        return rv;
    }

    @Override
    public void setAttributes(String pathText, HashMap attrs) throws KDRSException {
        Path path = super.checkPath(pathText);
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAttributes('" + path + "'," + attrs + ")"));
        }
        StorageUtil.checkAttrsNameLength(attrs);
        HashMap oldAttrs = this.storage.getAttributes(path);
        if (oldAttrs == null) {
            oldAttrs = attrs;
        } else {
            oldAttrs.putAll(attrs);
        }
        CtrlUtil.Map.removeNullVals((Map)oldAttrs);
        this.storage.setAttributes(path, oldAttrs);
    }

    @Override
    public byte[] readFile(String pathText, int offset, int length) throws KDRSException {
        Path path = super.checkPath(pathText);
        if (log.isDebugEnabled()) {
            log.debug((Object)("readFile('" + path + "'," + offset + "," + length + ")"));
        }
        if (offset < 0) {
            throw new InvalidParameterException("Bad offset for read file!!!");
        }
        if (length < 0) {
            throw new InvalidParameterException("Bad length for read file!!!");
        }
        byte[] data = null;
        IRandomAccessStream stream = null;
        try {
            stream = this.storage.getFileStream(path, false, true);
            int fileSize = (int)stream.length();
            if (fileSize > 0 && offset >= fileSize) {
                throw new InvalidParameterException("Invalid offset for read from");
            }
            if (length > fileSize - offset) {
                length = fileSize - offset;
            }
            stream.seek(offset);
            data = new byte[length];
            stream.read(data);
        }
        catch (IOException ex) {
            throw KDRSException.makeException(KdrsResource.getString("res_14"), ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    throw KDRSException.makeException(KdrsResource.getString("res_15"), ex);
                }
            }
        }
        return data;
    }

    @Override
    public void writeFile(String pathText, int offset, byte[] data) throws KDRSException {
        Path path = super.checkPath(pathText);
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeFile('" + path + "'," + offset + "," + data + ")"));
        }
        IRandomAccessStream stream = null;
        try {
            if (offset < 0) {
                offset = 0;
                stream = this.storage.getFileStream(path, true, false);
            } else {
                stream = this.storage.getFileStream(path, false, false);
            }
            stream.seek(offset);
            stream.write(data);
            this.storage.setAttribute(path, "last-modified", "" + System.currentTimeMillis());
        }
        catch (IOException ex) {
            throw KDRSException.makeException(KdrsResource.getString("res_16"), ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ex) {
                    throw KDRSException.makeException(KdrsResource.getString("res_15"), ex);
                }
            }
        }
    }

    @Override
    public void copy(String srcPathText, String destPathText) throws KDRSException {
        Path srcPath = super.checkPath(srcPathText);
        Path destPath = super.checkPath(destPathText);
        if (log.isDebugEnabled()) {
            log.debug((Object)("copy('" + srcPath + "','" + destPath + ')'));
        }
        if (destPath.isFatherOf(srcPath, true)) {
            return;
        }
        if (srcPath.equals(destPath)) {
            throw new InvalidParameterException("Couldn't copy it to self.");
        }
        if (srcPath.isFatherOf(destPath, false)) {
            throw new UnsupportedOperationException("Couldn't copy " + srcPath + " to " + destPath);
        }
        this.cloneStyleCopy(srcPath, destPath);
    }

    private void classicalCopy(Path srcPath, Path dest) throws KDRSException {
        if (ResourceType.FOLDER == this.storage.getType(srcPath)) {
            this.copyFolder(srcPath, dest, srcPath.getName());
        } else {
            this.copyFile(srcPath, dest);
        }
    }

    private void cloneStyleCopy(Path srcPath, Path dest) throws KDRSException {
        if (ResourceType.FOLDER == this.storage.getType(srcPath)) {
            this.copyFolder(srcPath, dest.getParent(), dest.getName());
        } else {
            this.copyFile(srcPath, dest);
        }
    }

    private void copyFolder(Path srcFolder, Path destParentFolder, String newName) throws KDRSException {
        if (ResourceType.FILE == this.storage.getType(destParentFolder)) {
            throw new UnsupportedOperationException("Couldn't copy folder '" + srcFolder + "' to file '" + destParentFolder + "'");
        }
        Path destFolder = destParentFolder.getChild(newName);
        boolean destFolderExists = true;
        try {
            if (ResourceType.FILE == this.storage.getType(destFolder)) {
                throw new UnsupportedOperationException("Couldn't recover file '" + destFolder + "' with folder '" + srcFolder + "'");
            }
        }
        catch (NotFoundException ex) {
            destFolderExists = false;
        }
        HashMap srcAttrs = this.getAttributes(srcFolder.getPathText(), null);
        if (destFolderExists) {
            this.setAttributes(destFolder.getPathText(), srcAttrs);
        } else {
            this.create(destFolder.getPathText(), srcAttrs);
        }
        String[] children = this.storage.listChildren(srcFolder);
        for (int i = 0; i < children.length; ++i) {
            this.classicalCopy(srcFolder.getChild(children[i]), destFolder);
        }
    }

    private void copyFile(Path srcFile, Path destFile) throws KDRSException {
        try {
            if (this.storage.getType(destFile) == ResourceType.FOLDER) {
                destFile = destFile.getChild(srcFile.getName());
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.storage.copyFile(srcFile, destFile);
    }

    @Override
    public HashMap list(String pathText, HashMap keys) throws KDRSException {
        String[] children;
        Path path = super.checkPath(pathText);
        if (log.isDebugEnabled()) {
            log.debug((Object)("list('" + path + "'," + keys + ")"));
        }
        int childCount = (children = this.storage.listChildren(path)) != null ? children.length : 0;
        HashMap<Object, String[]> rv = new HashMap<Object, String[]>();
        Object[] rvKeys = keys.keySet().toArray();
        String[][] rvVals = new String[rvKeys.length][];
        for (int i = 0; i < rvKeys.length; ++i) {
            rvVals[i] = new String[childCount];
            rv.put(rvKeys[i], rvVals[i]);
        }
        for (int j = 0; j < childCount; ++j) {
            Path childPath = path.getChild(children[j]);
            HashMap atts = this.storage.getAttributes(childPath);
            for (int i = 0; i < rvKeys.length; ++i) {
                Object val = this.getAttrVal(childPath, atts, rvKeys[i]);
                rvVals[i][j] = (String)val;
            }
        }
        return rv;
    }

    @Override
    public HashMap[] list2(String pathText, HashMap atts) throws KDRSException {
        throw new RuntimeException("Unsupported");
    }
}

