/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.ReflectUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.ISession;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.KdrsConfigure;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.FSStorageConfigure;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.IServerSideBizObject;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.IServerSideEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.IServerSideSession;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.ServerSideSessionManager;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.AbstractKdrsBosEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.BosStorageLoaderFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.HookFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.IAisStartupHook;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.KdrsConfigLoader;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.StoredObjectFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageProxy;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class KdrsBosServerEngine
extends AbstractKdrsBosEngine
implements IServerSideEngine {
    private static final String HOOKS_CONFIGURE_FILE = "engine_hook.xml";
    private static final String STORAGE_CONFIGURE_FILE = "StorageConfig.xml";
    public static final Logger log = LogUtil.getLogger(KdrsBosServerEngine.class);
    protected ServerSideSessionManager sessionManager = new ServerSideSessionManager();
    protected HashMap storages = new HashMap();
    protected HookFactory hookFactory;
    protected Object storageConfig;
    private static KdrsBosServerEngine instance;
    private ReflectUtil.IvkListenerList bizListeners = new ReflectUtil.IvkListenerList();

    public static synchronized KdrsBosServerEngine getInstance() throws KDRSException {
        if (instance == null) {
            instance = new KdrsBosServerEngine();
        }
        return instance;
    }

    private KdrsBosServerEngine() {
        log.info((Object)("Create " + this));
        HashMap hookConf = KdrsConfigLoader.loadHooksDef(CtrlUtil.Stream.loadResource(KdrsBosServerEngine.class, (String)HOOKS_CONFIGURE_FILE));
        if (hookConf != null) {
            this.hookFactory = new HookFactory(hookConf);
        }
        this.storageConfig = KdrsConfigLoader.loadStorageConfigure(CtrlUtil.Stream.loadResource(KdrsBosServerEngine.class, (String)STORAGE_CONFIGURE_FILE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStorage getStorage(String ais) throws KDRSException {
        IStorage sto;
        Object stoConf = this.storageConfig;
        log.info((Object)("ais=" + ais));
        if (ais == null || ais.length() == 0) {
            if (this.storageConfig instanceof FSStorageConfigure) {
                throw new KDRSException("");
            }
            stoConf = new FSStorageConfigure(null);
        }
        if (stoConf instanceof FSStorageConfigure) {
            ais = "";
        }
        HashMap hashMap = this.storages;
        synchronized (hashMap) {
            sto = (IStorage)this.storages.get(ais);
            if (sto == null) {
                Path orgPath;
                sto = BosStorageLoaderFactory.createLoader(stoConf, this).loadStorage(ais);
                if (!sto.isExist(orgPath = Path.valueOf("/eas"))) {
                    sto.create(orgPath, ResourceType.FOLDER, null);
                }
                sto = new StorageProxy(sto, orgPath);
                if (this.hookFactory != null) {
                    IAisStartupHook hook = (IAisStartupHook)this.hookFactory.createHook(IAisStartupHook.class);
                    hook.onAisStartup(ais, sto, this);
                }
                this.storages.put(ais, sto);
            }
        }
        return sto;
    }

    @Override
    public IServerSideSession lookupSession(String sid) throws KDRSException {
        return this.sessionManager.getSession(sid);
    }

    public final IServerSideSession createSession(IStorage storage, String lang) {
        IServerSideSession session = this.sessionManager.createSession();
        session.setStorage(storage);
        session.setBizObjectFactory(new StoredObjectFactory(storage, KdrsConfigure.typesConf, "category"));
        session.setProperty("lang", lang);
        session.setProperty("user", "administrator");
        return session;
    }

    @Override
    public ISession login(String ais, String lang) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ais=" + ais + ",lang=" + lang));
        }
        IStorage storage = this.getStorage(ais);
        IServerSideSession session = this.createSession(storage, lang);
        session.setProperty("ais", ais);
        return session;
    }

    @Override
    protected Object createBizObject(Class objCls, ISession session) throws KDRSException {
        IServerSideBizObject bizObject = null;
        String bizClass = null;
        if (objCls == IBizStorage.class) {
            bizClass = "com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorage";
        } else if (objCls == IBizContent.class) {
            bizClass = "com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_BizContent";
        }
        try {
            bizObject = (IServerSideBizObject)Class.forName(bizClass).newInstance();
        }
        catch (Exception ex) {
            throw KDRSException.makeException("Create bizObject,", ex);
        }
        bizObject.attachToSessoin(session);
        return ReflectUtil.makeMonitableObject((Object)bizObject, (ReflectUtil.IIvkListener)this.getBizListeners());
    }

    @Override
    public void logout(ISession session) throws KDRSException {
        if (session != null) {
            this.sessionManager.removeSession(session.getSid());
            super.logout(session);
        }
    }

    @Override
    public ReflectUtil.IvkListenerList getBizListeners() {
        return this.bizListeners;
    }
}

