/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.KdrsResource;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.HookDef;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class KdrsConfigLoader {
    public static final Logger log = LogUtil.getLogger(KdrsConfigLoader.class);

    public static Object loadStorageConfigure(String resPath) {
        try {
            InputStream in = GlobalLocator.getInstance().loadResourceFile(resPath);
            return KdrsConfigLoader.loadStorageConfigure(in);
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
    }

    public static Object loadStorageConfigure(InputStream in) {
        try {
            Element e = XmlUtil.loadXmlStream((InputStream)in);
            String useConf = e.getAttributeValue("useConf");
            if (useConf == null) {
                log.error((Object)KdrsResource.getString("res_3"));
                return null;
            }
            List children = e.getChildren("Configure");
            if (children == null) {
                log.error((Object)KdrsResource.getString("res_4"));
                return null;
            }
            Iterator i = children.listIterator();
            while (i.hasNext()) {
                Element confE = (Element)i.next();
                if (!useConf.equals(confE.getAttributeValue("name"))) continue;
                String confType = confE.getAttributeValue("type");
                if (confType == null) {
                    log.error((Object)KdrsResource.getString("res_5"));
                    return null;
                }
                children = e.getChildren("ConfigureType");
                if (children == null) {
                    log.error((Object)KdrsResource.getString("res_6"));
                    return null;
                }
                for (Element confTE : children) {
                    if (!confType.equals(confTE.getAttributeValue("name"))) continue;
                    String confCls = confTE.getAttributeValue("configure-class");
                    Class<?> cls = Class.forName(confCls);
                    Constructor<?> c = cls.getConstructor(Element.class);
                    return c.newInstance(confE);
                }
            }
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
        return null;
    }

    public static final HashMap loadHooksDef(String resPath) {
        try {
            InputStream in = GlobalLocator.getInstance().loadResourceFile(resPath);
            if (in != null) {
                return KdrsConfigLoader.loadHooksDef(in);
            }
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
        }
        return null;
    }

    public static final HashMap loadHooksDef(InputStream in) {
        HashMap<Class, ArrayList<HookDef>> defs = new HashMap<Class, ArrayList<HookDef>>();
        try {
            Element e = XmlUtil.loadXmlStream((InputStream)in);
            for (Element eChild : e.getChildren()) {
                HookDef def;
                ArrayList<HookDef> hookDefs;
                String type = eChild.getAttributeValue("type");
                String hookImpl = eChild.getAttributeValue("class");
                HashMap properties = null;
                Element eProperties = eChild.getChild("Properties");
                if (eProperties != null) {
                    properties = XmlUtil.makeMap((List)eProperties.getChildren());
                }
                if ((hookDefs = (ArrayList<HookDef>)defs.get((def = new HookDef(Class.forName(type), Class.forName(hookImpl), properties)).getHookType())) == null) {
                    hookDefs = new ArrayList<HookDef>();
                    defs.put(def.getHookType(), hookDefs);
                }
                hookDefs.add(def);
            }
            return defs;
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
    }
}

