/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.IServerSideSession;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.ServerSideSessionManager;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.KdrsServerSideSession;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class KdrsServerSideSessionManager
extends ServerSideSessionManager {
    private static final Logger log = LogUtil.getPackageLogger(KdrsServerSideSessionManager.class);

    public KdrsServerSideSessionManager(long timeout, long delay) {
        new Timer().schedule((TimerTask)new ClearExpiredSession(this.sessions, timeout), delay, delay);
        log.info((Object)("Create session manager, timeout:" + timeout + "(ms), clear period:" + delay + "(ms)"));
    }

    @Override
    public IServerSideSession createSession() {
        KdrsServerSideSession session = new KdrsServerSideSession(String.valueOf(System.currentTimeMillis()));
        this.addSession(session);
        return session;
    }

    private static class ClearExpiredSession
    extends TimerTask {
        private HashMap sessions;
        private long timeout;

        public ClearExpiredSession(HashMap sessions, long timeout) {
            this.sessions = sessions;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            log.info((Object)"Clear exprired sessions ...");
            if (this.sessions.size() == 0) {
                log.info((Object)"No session to clear.");
                return;
            }
            int clearCount = 0;
            int remainCount = 0;
            long expriedTime = System.currentTimeMillis() - this.timeout;
            Object[] vals = this.sessions.values().toArray();
            for (int i = 0; i < vals.length; ++i) {
                KdrsServerSideSession ssn = (KdrsServerSideSession)vals[i];
                if (expriedTime > ssn.getLastAccess()) {
                    log.info((Object)("Remove exprired session:" + ssn.getSid()));
                    ++clearCount;
                    this.sessions.remove(ssn.getSid());
                    continue;
                }
                ++remainCount;
            }
            log.info((Object)("Cleared " + clearCount + " expired, remain " + remainCount + " sessions"));
        }
    }
}

