/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.client;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.IBizSecurity;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.IKdrsEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.ISession;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.client.ClientSideSession;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.SessionException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.AbstractKdrsEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.HoldSessionQueue;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.ISessionHolder;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.client.RpcBizObjectFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.common.IRpcContent;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.common.IRpcSecurity;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.common.IRpcStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.common.IRpcSystem;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.service.RpcContentService;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.service.RpcSecurityService;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.service.RpcStorageService;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.service.RpcSystemService;
import com.kingdee.bos.rpcwrapper.IRPCEngine;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import org.apache.log4j.Logger;

public class KdrsRpcClientEngine
extends AbstractKdrsEngine
implements IKdrsEngine {
    public static final Logger log = LogUtil.getLogger(KdrsRpcClientEngine.class);
    private String rpcSvcUrl = "tcp://localhost:2006";
    private IRPCEngine rpcEngine;

    public final String getRpcSvcUrl() {
        return this.rpcSvcUrl;
    }

    public final void setRpcSvcUrl(String svcUrl) {
        this.rpcSvcUrl = svcUrl;
    }

    @Override
    protected Object createBizObject(Class objCls, ISession session) throws KDRSException {
        Object serviceObject = this.createRemoteByBizClass(session, objCls);
        return RpcBizObjectFactory.createBizObject(session, serviceObject, objCls);
    }

    protected IRPCEngine getRPCEngine() throws KDRSException {
        try {
            if (this.rpcEngine == null) {
                this.rpcEngine = RPCEngineFactory.getEngine((String)this.getRpcSvcUrl());
            }
            return this.rpcEngine;
        }
        catch (Exception ex) {
            throw KDRSException.makeException(ex);
        }
    }

    @Override
    public ISession login(String org, String user, String pwd, String lang) throws KDRSException {
        long l0 = System.currentTimeMillis();
        IRPCEngine rpcEngine = this.getRPCEngine();
        IRpcSystem system = (IRpcSystem)this.createRpcObject(RpcSystemService.class.getName(), IRpcSystem.class);
        String sid = system.login(org, user, pwd, lang);
        ClientSideSession session = new ClientSideSession(sid);
        session.setProperty(IRPCEngine.class, rpcEngine);
        session.setProperty(IRpcSystem.class, system);
        session.setProperty("user", user);
        session.setProperty("org", org);
        HoldSessionQueue.getInstance().addHolder(new SessionHolder(system, session), 600000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("login spent:" + (System.currentTimeMillis() - l0)));
        }
        return session;
    }

    @Override
    public void logout(ISession session) throws KDRSException {
        if (session == null) {
            return;
        }
        IRpcSystem system = (IRpcSystem)session.getProperty(IRpcSystem.class);
        if (system != null) {
            system.logout(session.getSid());
        }
        super.logout(session);
    }

    private Object createRpcObject(String objectName, Class model) throws KDRSException {
        try {
            return this.rpcEngine.createObject(objectName, model);
        }
        catch (RuntimeException ex) {
            throw KDRSException.makeException(ex);
        }
    }

    protected Object createRemoteByBizClass(ISession session, Object bizObjCls) throws KDRSException {
        if (session == null) {
            IRPCEngine rpcEngine = this.getRPCEngine();
        } else {
            IRPCEngine rpcEngine = (IRPCEngine)session.getProperty(IRPCEngine.class);
            if (rpcEngine == null) {
                throw new SessionException("Session was expired.");
            }
        }
        if (IBizStorage.class == bizObjCls) {
            return this.createRpcObject(RpcStorageService.class.getName(), IRpcStorage.class);
        }
        if (IBizContent.class == bizObjCls) {
            return this.createRpcObject(RpcContentService.class.getName(), IRpcContent.class);
        }
        if (IBizSecurity.class == bizObjCls) {
            return this.createRpcObject(RpcSecurityService.class.getName(), IRpcSecurity.class);
        }
        throw new KDRSException("Unsupport " + bizObjCls);
    }

    public class SessionHolder
    implements ISessionHolder {
        private IRpcSystem system;
        private ISession session;

        public SessionHolder(IRpcSystem system, ISession session) {
            this.system = system;
            this.session = session;
        }

        @Override
        public boolean holdSession() {
            try {
                if (this.session.isValid()) {
                    this.system.hold(this.session.getSid());
                    return true;
                }
                return false;
            }
            catch (SessionException ex) {
                return false;
            }
            catch (Exception ex) {
                log.warn(null, (Throwable)ex);
                return true;
            }
        }
    }
}

