/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.service;

import com.kingdee.bos.ctrl.common.util.ExceptionUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.common.IRpcContent;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.service.RpcStorageService;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RpcContentService
extends RpcStorageService
implements IRpcContent {
    public static final Logger log = LogUtil.getLogger(RpcContentService.class);

    public RpcContentService() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"create RpcContentService");
        }
    }

    @Override
    protected IBizStorage getBizStorage(String sid) throws KDRSException {
        return this.getBizContent(sid);
    }

    protected IBizContent getBizContent(String sid) throws KDRSException {
        return (IBizContent)((Object)this.checkBizObject(sid, IBizContent.class));
    }

    @Override
    public String executeStart(String sid, String path, HashMap args) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("executeStart(sid=" + sid + ",path=" + path + ",args=" + args + ")"));
        }
        try {
            return this.getBizContent(sid).executeStart(path, args);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
    }

    @Override
    public Object executeCall(String sid, String objId, String method, String[] argTypeNames, Object[] args) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("executeCall(sid=" + sid + ",objId=" + objId + ",method=" + method + ",argTypeNames=" + argTypeNames + ",args=" + args + ")"));
        }
        try {
            return this.getBizContent(sid).executeCall(objId, method, argTypeNames, args);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
    }

    @Override
    public void executeEnd(String sid, String objId) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("executeEnd(sid=" + sid + ",objId=" + objId + ")"));
        }
        try {
            this.getBizContent(sid).executeEnd(objId);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
    }

    @Override
    public String viewHistory(String sid, String path, String name) throws KDRSException {
        return null;
    }

    @Override
    public String viewSnapshot(String sid, String path) throws KDRSException {
        return null;
    }

    @Override
    public String createSnapshot(String sid, String objPath, HashMap atts) throws KDRSException {
        return null;
    }

    @Override
    public void deleteHistory(String sid, String objPath, String name) throws KDRSException {
    }

    @Override
    public void deleteSnapshot(String sid, String objPath) throws KDRSException {
    }

    @Override
    public HashMap listHistory(String sid, String objPath, HashMap atts) throws KDRSException {
        return null;
    }

    @Override
    public byte[] readConfig(String sid, String objPath) throws KDRSException {
        byte[] rv;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getConfig('" + sid + "', '" + objPath + "')"));
        }
        try {
            rv = this.getBizContent(sid).readConfig(objPath);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getConfig return " + rv + ",size:" + (rv == null ? 0 : rv.length)));
        }
        return rv;
    }

    @Override
    public void writeConfig(String sid, String objPath, byte[] data) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeConfig('" + sid + "', '" + objPath + "',byte[" + data.length + "])"));
        }
        try {
            this.getBizContent(sid).writeConfig(objPath, data);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"writeConfig return OK");
        }
    }

    @Override
    public byte[] readTemplate(String sid, String objPath) throws KDRSException {
        byte[] rv;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTemplate('" + sid + "', '" + objPath + "')"));
        }
        try {
            rv = this.getBizContent(sid).readTemplate(objPath);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTemplate return " + rv));
        }
        return rv;
    }

    @Override
    public void writeTemplate(String sid, String objPath, byte[] data) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeTemplate('" + sid + "', '" + objPath + "',byte[" + data.length + "])"));
        }
        try {
            this.getBizContent(sid).writeTemplate(objPath, data);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"writeTemplate return OK");
        }
    }
}

