/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.service;

import com.kingdee.bos.ctrl.common.util.ExceptionUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.IBizSecurity;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.AbstractService;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.common.IRpcSecurity;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RpcSecurityService
extends AbstractService
implements IRpcSecurity {
    public static final Logger log = LogUtil.getLogger(RpcSecurityService.class);

    public RpcSecurityService() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating security service.");
        }
    }

    protected IBizSecurity getBizSecurity(String sid) throws KDRSException {
        return (IBizSecurity)((Object)this.checkBizObject(sid, IBizSecurity.class));
    }

    @Override
    public int createObject(String sid, int objType, HashMap attrs) throws KDRSException {
        int rv;
        if (log.isDebugEnabled()) {
            log.debug((Object)("createObject,sid=" + sid + ",objType=" + objType + ",attrs=" + attrs));
        }
        try {
            rv = this.getBizSecurity(sid).createObject(objType, attrs);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("createObject,return:" + rv));
        }
        return rv;
    }

    @Override
    public void deleteObject(String sid, int objType, int id) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteObject,sid=" + sid + ",objType=" + objType + ",id=" + id));
        }
        try {
            this.getBizSecurity(sid).deleteObject(objType, id);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"createObject,successed");
        }
    }

    @Override
    public HashMap getObjectInfo(String sid, int objType, int id, String[] attrsNames) throws KDRSException {
        HashMap rv;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getObjectInfo,sid=" + sid + ",objType=" + objType + ",id=" + id + ",attrsNames=" + attrsNames));
        }
        try {
            rv = this.getBizSecurity(sid).getObjectInfo(objType, id, attrsNames);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getObjectInfo,return:" + rv));
        }
        return rv;
    }

    @Override
    public HashMap getRule(String sid, String path) throws KDRSException {
        HashMap rv;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getRule,sid=" + sid + ",path=" + path));
        }
        try {
            rv = this.getBizSecurity(sid).getRule(path);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getRule,return:" + rv));
        }
        return rv;
    }

    @Override
    public HashMap listObjects(String sid, int objType, String[] attrNames) throws KDRSException {
        HashMap rv;
        if (log.isDebugEnabled()) {
            log.debug((Object)("listObjects,sid=" + sid + ",objType=" + objType + ",attrNames=" + attrNames));
        }
        try {
            rv = this.getBizSecurity(sid).listObjects(objType, attrNames);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("listObjects,return:" + rv));
        }
        return rv;
    }

    @Override
    public void setObjectInfo(String sid, int objType, int id, HashMap attrs) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setObjectInfo,sid=" + sid + ",objType=" + objType + ",id=" + id + ",attrs=" + attrs));
        }
        try {
            this.getBizSecurity(sid).setObjectInfo(objType, id, attrs);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"setObjectInfo,successed");
        }
    }

    @Override
    public void setRule(String sid, String path, HashMap ruleDef) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setRule,sid=" + sid + ",path=" + path + ",ruleDef=" + ruleDef));
        }
        try {
            this.getBizSecurity(sid).setRule(path, ruleDef);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"setRule,successed");
        }
    }
}

