/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.service;

import com.kingdee.bos.ctrl.common.util.ArrayUtil;
import com.kingdee.bos.ctrl.common.util.ExceptionUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.AbstractService;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.common.IRpcStorage;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RpcStorageService
extends AbstractService
implements IRpcStorage {
    public static final Logger log = LogUtil.getLogger(RpcStorageService.class);

    public RpcStorageService() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating storage service.");
        }
    }

    protected IBizStorage getBizStorage(String sid) throws KDRSException {
        return (IBizStorage)((Object)this.checkBizObject(sid, IBizStorage.class));
    }

    @Override
    public boolean isExist(String sid, String resPath) throws KDRSException {
        boolean rv;
        if (log.isDebugEnabled()) {
            log.debug((Object)("isExist('" + sid + "','" + resPath + "')"));
        }
        try {
            rv = this.getBizStorage(sid).isExist(resPath);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("isExist return " + rv));
        }
        return rv;
    }

    @Override
    public boolean isAtomic(String sid, String resPath) throws KDRSException {
        boolean rv;
        if (log.isDebugEnabled()) {
            log.debug((Object)("isAtomic('" + sid + "','" + resPath + "')"));
        }
        try {
            rv = this.getBizStorage(sid).isAtomic(resPath);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("isAtomic return " + rv));
        }
        return rv;
    }

    @Override
    public void create(String sid, String resPath, HashMap attrs) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("create('" + sid + "','" + resPath + "'," + attrs + ")"));
        }
        try {
            this.getBizStorage(sid).create(resPath, attrs);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"create return OK");
        }
    }

    @Override
    public void delete(String sid, String resPath) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("delete('" + sid + "','" + resPath + "'," + resPath + ")"));
        }
        try {
            this.getBizStorage(sid).delete(resPath);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"delete return OK");
        }
    }

    @Override
    public void rename(String sid, String resPath, String toName) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("rename('" + sid + "','" + resPath + "','" + toName + "')"));
        }
        try {
            this.getBizStorage(sid).rename(resPath, toName);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"rename return OK");
        }
    }

    @Override
    public HashMap getAttributes(String sid, String resPath, String[] attr_names) throws KDRSException {
        HashMap rv;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAttributes('" + sid + "','" + resPath + "'," + resPath + "',{" + ArrayUtil.objectArray2String((Object[])attr_names, (String)",") + "})"));
        }
        try {
            rv = this.getBizStorage(sid).getAttributes(resPath, attr_names);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAttributes return " + rv));
        }
        return rv;
    }

    @Override
    public void setAttributes(String sid, String resPath, HashMap attrs) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAttributes('" + sid + "','" + resPath + "'," + attrs + ")"));
        }
        try {
            this.getBizStorage(sid).setAttributes(resPath, attrs);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"setAttributes return OK");
        }
    }

    @Override
    public byte[] readFile(String sid, String resPath, int offset, int length) throws KDRSException {
        byte[] rv;
        if (log.isDebugEnabled()) {
            log.debug((Object)("readFile('" + sid + "','" + resPath + "'," + offset + "'," + length + ")"));
        }
        try {
            rv = this.getBizStorage(sid).readFile(resPath, offset, length);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("readFile return " + rv));
        }
        return rv;
    }

    @Override
    public void writeFile(String sid, String resPath, int offset, byte[] data) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeFile('" + sid + "','" + resPath + "'," + offset + "',byte[" + data.length + "])"));
        }
        try {
            this.getBizStorage(sid).writeFile(resPath, offset, data);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"writeFile return OK");
        }
    }

    @Override
    public void copy(String sid, String fromPath, String toPath) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("copy('" + sid + "','" + fromPath + "','" + toPath + "')"));
        }
        try {
            this.getBizStorage(sid).copy(fromPath, toPath);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"copy return OK");
        }
    }

    @Override
    public HashMap list(String sid, String resPath, HashMap attrs) throws KDRSException {
        HashMap rv;
        if (log.isDebugEnabled()) {
            log.debug((Object)("list('" + sid + "','" + resPath + "'," + attrs + ")"));
        }
        try {
            rv = this.getBizStorage(sid).list(resPath, attrs);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("list return " + rv));
        }
        return rv;
    }

    @Override
    public HashMap[] list2(String sid, String path, HashMap attrs) throws KDRSException {
        try {
            return this.getBizStorage(sid).list2(path, attrs);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
    }
}

