/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.objectx;

import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.IStoredObject;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import java.util.HashMap;

public abstract class AbstractStoredObject
implements IStoredObject {
    protected IStorage storage;
    protected Path path;
    protected String type;
    private HashMap attrs_cache;
    private boolean attrsCache_initialized = false;

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public IStorage getStorage() {
        return this.storage;
    }

    public AbstractStoredObject(IStorage storage, Path path, String type) {
        this.storage = storage;
        this.path = path;
        this.type = type;
    }

    public void preSetAttributesCache(HashMap attrs) {
        this.attrs_cache = attrs;
        this.attrsCache_initialized = true;
    }

    @Override
    public HashMap getAttributes() throws KDRSException {
        if (!this.attrsCache_initialized) {
            this.attrs_cache = this.storage.getAttributes(this.path);
            this.attrsCache_initialized = true;
        }
        return this.attrs_cache == null ? null : (HashMap)this.attrs_cache.clone();
    }

    @Override
    public void setAttributes(HashMap attrs, boolean mode_overwrite) throws KDRSException {
        if (!mode_overwrite) {
            HashMap oldAttrs = this.getAttributes();
            if (oldAttrs == null) {
                oldAttrs = new HashMap();
            }
            oldAttrs.putAll(attrs);
            attrs = oldAttrs;
        }
        this.storage.setAttributes(this.path, attrs);
        this.attrs_cache = attrs;
    }

    @Override
    public void setAttribute(String name, Object val) throws KDRSException {
        this.storage.setAttribute(this.path, name, val);
        this.attrsCache_initialized = false;
    }

    @Override
    public Object getAttribute(String name) throws KDRSException {
        HashMap attrs = this.getAttributes();
        return attrs == null ? null : attrs.get(name);
    }

    @Override
    public void setName(String name) throws KDRSException {
        this.storage.rename(this.path, name);
        this.path = this.path.getBrother(name);
    }

    @Override
    public String getName() throws KDRSException {
        return this.path.getName();
    }

    @Override
    public void moveTo(Path path2) throws KDRSException {
        this.storage.move(this.path, path2);
        this.path = path2;
    }

    @Override
    public Path getPath() throws KDRSException {
        return this.path;
    }

    @Override
    public void delete() throws KDRSException {
        new BizStorage(this.storage).delete(this.path.getPathText());
    }

    @Override
    public void copyTo(IStoredObject target) throws KDRSException {
        new BizStorage(this.storage).copy(this.path.getPathText(), target.getPath().getPathText());
    }

    public String toString() {
        return "[" + this.getType() + "]" + this.path;
    }
}

