/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.db;

import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.common.util.IntIDMaker;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.CircularReferenceException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.DeleteException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidPathException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ISpaceProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.DBAccess;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.DBStoredFile;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.FileTable;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.IDataSource;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.WrongDBTablesException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.bean.FileInfoBean;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class DBSpaceProvider
implements ISpaceProvider {
    private static final Logger log = LogUtil.getPackageLogger(DBSpaceProvider.class);
    private IDataSource connPool;
    private HashMap streams;
    private FileTable fileTable;
    private IntIDMaker idMaker;

    public DBSpaceProvider() {
    }

    public DBSpaceProvider(IDataSource connPool) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Create DBSpaceProvider...");
        }
        this.connPool = connPool;
        this.idMaker = new IntIDMaker();
        this.streams = new HashMap();
        this.buildFileTable();
    }

    private final void buildFileTable() throws KDRSException {
        long l0 = System.currentTimeMillis();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.connPool.getConnection();
            stmt = conn.createStatement();
            if (!DBAccess.isValidTables(stmt)) {
                throw new WrongDBTablesException();
            }
            if (DBAccess.readRootInfo(stmt) == null) {
                log.warn((Object)"Not found any file,will insert a root entry.");
                DBAccess.insertFileEntry(stmt, new FileInfoBean(this.idMaker.next(), -1, "ROOT", false));
            }
            HashMap allBeans = DBAccess.readFileEntries(stmt);
            Iterator beanIds = allBeans.keySet().iterator();
            while (beanIds.hasNext()) {
                this.idMaker.markUsed(((Integer)beanIds.next()).intValue());
            }
            try {
                this.fileTable = new FileTable(allBeans);
            }
            catch (CircularReferenceException e) {
                log.error((Object)("beans:\n" + allBeans));
                throw e;
            }
            log.info((Object)("build file table,spent:" + (System.currentTimeMillis() - l0)));
            this.fileTable.lookup(Path.ROOT).setName(Path.ROOT.getName());
        }
        catch (SQLException ex) {
            try {
                throw KDRSException.makeException("Internal error.", ex);
            }
            catch (Throwable throwable) {
                DBUtil.closeStatement(stmt);
                DBUtil.closeDBConn((Connection)conn);
                throw throwable;
            }
        }
        DBUtil.closeStatement((Statement)stmt);
        DBUtil.closeDBConn((Connection)conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    FileInfoBean _allocate(Path resPath, boolean isFile) throws KDRSException {
        FileInfoBean bean;
        Statement stmt;
        Connection conn;
        block6: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("allocate:" + resPath));
            }
            StorageUtil.checkPath(resPath, false);
            conn = null;
            stmt = null;
            FileInfoBean parent_bean = this.checkFile(resPath.getParent(), false);
            this.checkExist(resPath, false);
            int fid = this.idMaker.next();
            bean = new FileInfoBean(fid, parent_bean.getFid(), resPath.getName(), isFile);
            boolean success = false;
            try {
                conn = this.connPool.getConnection();
                stmt = conn.createStatement();
                DBAccess.insertFileEntry(stmt, bean);
                success = true;
                this.fileTable.addFileEntry(resPath, bean);
                if (success) break block6;
            }
            catch (SQLException ex) {
                try {
                    throw KDRSException.makeException("Internal error.", ex);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        this.idMaker.free(fid);
                    }
                    DBUtil.closeStatement(stmt);
                    DBUtil.closeDBConn((Connection)conn);
                    throw throwable;
                }
            }
            this.idMaker.free(fid);
        }
        DBUtil.closeStatement((Statement)stmt);
        DBUtil.closeDBConn((Connection)conn);
        return bean;
    }

    @Override
    public void allocate(Path resPath, boolean isFile) throws KDRSException {
        this._allocate(resPath, isFile);
    }

    void _copyFile(FileInfoBean bean1, FileInfoBean bean2) throws KDRSException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.connPool.getConnection();
            stmt = conn.createStatement();
            DBAccess.copyFile(stmt, bean1.getFid(), bean2.getFid());
        }
        catch (SQLException ex) {
            try {
                throw KDRSException.makeException("Internal error.", ex);
            }
            catch (Throwable throwable) {
                DBUtil.closeStatement(stmt);
                DBUtil.closeDBConn((Connection)conn);
                throw throwable;
            }
        }
        DBUtil.closeStatement((Statement)stmt);
        DBUtil.closeDBConn((Connection)conn);
    }

    @Override
    public void copyFile(Path fromPath, Path toPath) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("copyFile:" + fromPath + "," + toPath));
        }
        StorageUtil.checkPath(fromPath, false);
        StorageUtil.checkPath(toPath, false);
        if (fromPath.equals(toPath)) {
            return;
        }
        this._copyFile(this.checkFile(fromPath, true), this.checkFile(toPath, true));
    }

    @Override
    public int exist(Path resPath) throws KDRSException {
        FileInfoBean bean;
        if (log.isDebugEnabled()) {
            log.debug((Object)("exist:" + resPath));
        }
        if ((bean = this.getFileInfo(resPath)) != null) {
            return bean.isFile() ? 1 : 2;
        }
        return 0;
    }

    void _free(Path resPath, FileInfoBean bean) throws KDRSException {
        if (!bean.isFile() && this.fileTable.listChildren(resPath, true) != null) {
            throw new DeleteException("The folder '" + resPath + "' is not empty.");
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.connPool.getConnection();
            stmt = conn.createStatement();
            int fid = bean.getFid();
            DBAccess.removeFileEntry(stmt, fid);
            if (bean.isFile()) {
                DBAccess.eraseFileData(stmt, fid);
            }
            this.fileTable.remove(resPath);
            this.idMaker.free(fid);
        }
        catch (SQLException ex) {
            try {
                throw KDRSException.makeException("Internal error,", ex);
            }
            catch (Throwable throwable) {
                DBUtil.closeStatement(stmt);
                DBUtil.closeDBConn((Connection)conn);
                throw throwable;
            }
        }
        DBUtil.closeStatement((Statement)stmt);
        DBUtil.closeDBConn((Connection)conn);
    }

    @Override
    public void free(Path resPath) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("free:" + resPath));
        }
        StorageUtil.checkPath(resPath, false);
        this._free(resPath, this.checkExist(resPath, true));
    }

    @Override
    public int getLength(Path resPath) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getLength:" + resPath));
        }
        int len = -1;
        DBStoredFile file = (DBStoredFile)this.openStream(resPath, false, false, false);
        try {
            len = (int)file.length();
            file.close();
        }
        catch (IOException ex) {
            throw KDRSException.makeException("Internal error:", ex);
        }
        return len;
    }

    @Override
    public HashMap list(Path resPath) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("list:" + resPath));
        }
        this.checkFile(resPath, false);
        HashMap<String, ResourceType> map = new HashMap<String, ResourceType>();
        List children = this.fileTable.listChildren(resPath, false);
        if (children != null) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                FileInfoBean fb = (FileInfoBean)children.get(i);
                map.put(fb.getName(), fb.isFile() ? ResourceType.FILE : ResourceType.FOLDER);
            }
        }
        return map;
    }

    @Override
    public void move(Path path1, Path path2) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("move:" + path1 + "," + path2));
        }
        StorageUtil.checkPath(path1, false);
        StorageUtil.checkPath(path2, false);
        if (path1.getParent().equals(path2.getParent())) {
            this.rename(path1, path2.getName());
            return;
        }
        FileInfoBean source = this.checkExist(path1, true);
        FileInfoBean target_parent = this.checkFile(path2.getParent(), false);
        this.checkExist(path2, false);
        boolean success = false;
        int bk_source_parent_id = source.getPid();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.connPool.getConnection();
            stmt = conn.createStatement();
            source.setPid(target_parent.getFid());
            source.setName(path2.getName());
            DBAccess.updateFileEntry(stmt, source);
            success = true;
            source.setName(path1.getName());
            this.fileTable.move(path1, path2);
        }
        catch (SQLException ex) {
            try {
                throw KDRSException.makeException("Internal error,", ex);
            }
            catch (Throwable throwable) {
                DBUtil.closeStatement(stmt);
                DBUtil.closeDBConn((Connection)conn);
                if (!success) {
                    source.setName(path1.getName());
                    source.setPid(bk_source_parent_id);
                }
                throw throwable;
            }
        }
        DBUtil.closeStatement((Statement)stmt);
        DBUtil.closeDBConn((Connection)conn);
        if (!success) {
            source.setName(path1.getName());
            source.setPid(bk_source_parent_id);
        }
    }

    @Override
    public IRandomAccessStream openStream(Path resPath, boolean clear, boolean autoCreate, boolean readOnly) throws KDRSException {
        FileInfoBean bean;
        block10: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("openStream:" + resPath + "," + clear + "," + autoCreate));
            }
            StorageUtil.checkPath(resPath, false);
            bean = null;
            try {
                bean = this.checkFile(resPath, true);
            }
            catch (KDRSException ex) {
                if (ex instanceof NotFoundException && autoCreate) break block10;
                throw ex;
            }
        }
        boolean notFound = bean == null;
        boolean needClear = false;
        if (notFound) {
            bean = this._allocate(resPath, true);
        } else {
            needClear = clear;
        }
        Integer fidObj = new Integer(bean.getFid());
        DBStoredFile stream = (DBStoredFile)this.streams.get(fidObj);
        if (stream == null) {
            stream = new DBStoredFile(bean.getFid(), notFound, this);
            this.streams.put(fidObj, stream);
        } else {
            stream.addRef();
        }
        if (needClear) {
            try {
                stream.clearFileData();
            }
            catch (IOException ex) {
                throw KDRSException.makeException("Failed in clear file data.", ex);
            }
        }
        return stream;
    }

    @Override
    public void rename(Path resPath, String newName) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("rename:" + resPath + "," + newName));
        }
        StorageUtil.checkPath(resPath, false);
        if (resPath.getName().equalsIgnoreCase(newName)) {
            return;
        }
        FileInfoBean bean = this.checkExist(resPath, true);
        this.checkExist(resPath.getBrother(newName), false);
        boolean success = false;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.connPool.getConnection();
            stmt = conn.createStatement();
            bean.setName(newName);
            DBAccess.updateFileEntry(stmt, bean);
            success = true;
        }
        catch (SQLException ex) {
            try {
                throw KDRSException.makeException("Internal error,", ex);
            }
            catch (Throwable throwable) {
                DBUtil.closeStatement(stmt);
                DBUtil.closeDBConn((Connection)conn);
                if (!success) {
                    bean.setName(resPath.getName());
                }
                throw throwable;
            }
        }
        DBUtil.closeStatement((Statement)stmt);
        DBUtil.closeDBConn((Connection)conn);
        if (!success) {
            bean.setName(resPath.getName());
        }
    }

    FileInfoBean getFileInfo(Path path) {
        return this.fileTable.lookup(path);
    }

    public final FileInfoBean checkExist(Path path, boolean checkExist) throws KDRSException {
        FileInfoBean bean = this.getFileInfo(path);
        if (bean == null) {
            if (checkExist) {
                throw new NotFoundException("Not found '" + path + "'");
            }
        } else if (!checkExist) {
            throw new AlreadyExistsException("Resource '" + path + "' was already exist.");
        }
        return bean;
    }

    public final FileInfoBean checkFile(Path path, boolean checkExistFile) throws KDRSException {
        FileInfoBean bean = this.checkExist(path, true);
        if (bean.isFile()) {
            if (!checkExistFile) {
                throw new InvalidPathException("This operation requir folder type resource.");
            }
        } else if (checkExistFile) {
            throw new InvalidPathException("This operation requir file type resource.");
        }
        return bean;
    }

    void removeStream(DBStoredFile stream) {
        this.streams.remove(new Integer(stream.getFid()));
    }

    IDataSource getDataSource() {
        return this.connPool;
    }

    public String toString() {
        return "DBSpaceProvider@" + this.hashCode() + "[dbSource=" + this.connPool + "]";
    }
}

