/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.db;

import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ISpaceProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.DBSpaceProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.DBStoredFile;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.IDataSource;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.bean.FileInfoBean;
import java.util.HashMap;

public class DBSpaceProviderProxy
extends DBSpaceProvider
implements ISpaceProvider {
    private Path basePath;
    private DBSpaceProvider impl;

    public DBSpaceProviderProxy(DBSpaceProvider impl, Path basePath) {
        this.impl = impl;
        this.basePath = basePath;
    }

    @Override
    FileInfoBean _allocate(Path resPath, boolean isFile) throws KDRSException {
        return this.impl._allocate(this.getAbsolutePath(resPath), isFile);
    }

    @Override
    void _free(Path resPath, FileInfoBean bean) throws KDRSException {
        this.impl._free(this.getAbsolutePath(resPath), bean);
    }

    @Override
    FileInfoBean getFileInfo(Path path) {
        return this.impl.getFileInfo(this.getAbsolutePath(path));
    }

    @Override
    public void allocate(Path resPath, boolean isFile) throws KDRSException {
        this.impl.allocate(this.getAbsolutePath(resPath), isFile);
    }

    @Override
    public void copyFile(Path fromPath, Path toPath) throws KDRSException {
        this.impl.copyFile(this.getAbsolutePath(fromPath), this.getAbsolutePath(toPath));
    }

    @Override
    public int exist(Path resPath) throws KDRSException {
        return this.impl.exist(this.getAbsolutePath(resPath));
    }

    @Override
    public void free(Path resPath) throws KDRSException {
        this.impl.free(this.getAbsolutePath(resPath));
    }

    @Override
    public int getLength(Path resPath) throws KDRSException {
        return this.impl.getLength(this.getAbsolutePath(resPath));
    }

    @Override
    public HashMap list(Path resPath) throws KDRSException {
        return this.impl.list(this.getAbsolutePath(resPath));
    }

    @Override
    public void move(Path resPath, Path newPath) throws KDRSException {
        this.impl.move(this.getAbsolutePath(resPath), this.getAbsolutePath(newPath));
    }

    @Override
    public IRandomAccessStream openStream(Path resPath, boolean clear, boolean autoCreate, boolean readOnly) throws KDRSException {
        return this.impl.openStream(this.getAbsolutePath(resPath), clear, autoCreate, false);
    }

    @Override
    public void rename(Path resPath, String newName) throws KDRSException {
        this.impl.rename(this.getAbsolutePath(resPath), newName);
    }

    private Path getAbsolutePath(Path resPath) {
        return Path.contact(this.basePath, resPath);
    }

    @Override
    void _copyFile(FileInfoBean bean1, FileInfoBean bean2) throws KDRSException {
        this.impl._copyFile(bean1, bean2);
    }

    @Override
    IDataSource getDataSource() {
        return this.impl.getDataSource();
    }

    @Override
    void removeStream(DBStoredFile stream) {
        this.impl.removeStream(stream);
    }

    @Override
    public String toString() {
        return "base:" + this.basePath + "," + super.toString();
    }
}

