/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.db;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.BasicStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.DBAccess;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.DBSpaceProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.bean.Attributes;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.bean.FileInfoBean;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class DBStorage
extends BasicStorage {
    private DBSpaceProvider dbSpace;

    public DBStorage(DBSpaceProvider dbSpace) {
        this.dbSpace = dbSpace;
    }

    Attributes ensureAttributes(FileInfoBean bean) throws KDRSException {
        HashMap<String, String> attrs;
        Attributes attributes = bean.getAttributes();
        if (attributes == null) {
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = this.dbSpace.getDataSource().getConnection();
                stmt = conn.createStatement();
                HashMap attrs2 = DBAccess.loadAttributes(stmt, bean.getFid());
                attributes = new Attributes(attrs2);
                bean.setAttributes(attributes);
            }
            catch (SQLException ex) {
                try {
                    throw KDRSException.makeException("Internal error,", ex);
                }
                catch (Throwable throwable) {
                    CtrlUtil.DB.closeStatement(stmt);
                    CtrlUtil.DB.closeDBConn((Connection)conn);
                    throw throwable;
                }
            }
            CtrlUtil.DB.closeStatement((Statement)stmt);
            CtrlUtil.DB.closeDBConn((Connection)conn);
        }
        if ((attrs = attributes.getAttributes()) == null) {
            attrs = new HashMap<String, String>();
            attributes.setAttributes(attrs);
        }
        attrs.put("type", bean.isFile() ? "File" : "Folder");
        return attributes;
    }

    void internal_setAttributes(FileInfoBean bean, HashMap newAttrs, boolean justCreated, boolean updateNow) throws KDRSException {
        if (justCreated && newAttrs == null) {
            return;
        }
        if (newAttrs != null) {
            newAttrs.remove("name");
            newAttrs.remove("type");
        }
        HashMap oldAttrs = this.ensureAttributes(bean).getAttributes();
        bean.setAttributes(new Attributes(newAttrs));
        if (!updateNow) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.dbSpace.getDataSource().getConnection();
            DBAccess.saveAttributes(conn, bean.getFid(), newAttrs, oldAttrs);
        }
        catch (SQLException ex) {
            try {
                throw KDRSException.makeException("Internal error,", ex);
            }
            catch (Throwable throwable) {
                CtrlUtil.DB.closeDBConn(conn);
                throw throwable;
            }
        }
        CtrlUtil.DB.closeDBConn((Connection)conn);
    }

    @Override
    public void copyFile(Path source, Path target) throws KDRSException {
        if (!StorageUtil.checkCopyParameters(source, target)) {
            return;
        }
        boolean isNewFile = false;
        FileInfoBean srcFile = this.dbSpace.checkFile(source, true);
        FileInfoBean targetFile = this.dbSpace.getFileInfo(target);
        if (targetFile == null) {
            isNewFile = true;
            targetFile = this.dbSpace._allocate(target, true);
        }
        this.dbSpace.copyFile(source, target);
        HashMap attrs_source = this.ensureAttributes(srcFile).getAttributes();
        if (attrs_source != null) {
            attrs_source = (HashMap)attrs_source.clone();
        }
        if (!isNewFile) {
            this.ensureAttributes(targetFile);
        }
        this.internal_setAttributes(targetFile, attrs_source, isNewFile, true);
    }

    @Override
    protected void setAttributes(Path path, HashMap attrs, boolean updateNow) throws KDRSException {
        FileInfoBean bean = this.dbSpace.checkExist(path, true);
        ResourceType resType = bean.isFile() ? ResourceType.FILE : ResourceType.FOLDER;
        StorageUtil.checkAttrsForSet(path, resType, attrs);
        this.internal_setAttributes(bean, attrs, false, updateNow);
    }

    @Override
    public void create(Path path, ResourceType type, HashMap attrs) throws KDRSException {
        StorageUtil.checkIsNotRoot(path);
        StorageUtil.checkAttrsNameLength(attrs);
        FileInfoBean bean = this.dbSpace._allocate(path, type == ResourceType.FILE);
        this.internal_setAttributes(bean, CtrlUtil.Obj.cloneHashMap((HashMap)attrs), true, true);
    }

    @Override
    public HashMap getAttributesRef(Path path) throws KDRSException {
        return this.ensureAttributes(this.dbSpace.checkExist(path, true)).getAttributes();
    }

    @Override
    public void delete(Path path) throws KDRSException {
        FileInfoBean bean = this.dbSpace.checkExist(path, true);
        this.dbSpace._free(path, bean);
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.dbSpace.getDataSource().getConnection();
            stmt = conn.createStatement();
            DBAccess.removeAttributes(stmt, bean.getFid());
        }
        catch (SQLException ex) {
            try {
                throw KDRSException.makeException("Interanl error,", ex);
            }
            catch (Throwable throwable) {
                CtrlUtil.DB.closeDBConn(conn);
                CtrlUtil.DB.closeStatement(stmt);
                throw throwable;
            }
        }
        CtrlUtil.DB.closeDBConn((Connection)conn);
        CtrlUtil.DB.closeStatement((Statement)stmt);
    }

    @Override
    public int getFileLength(Path path) throws KDRSException {
        return this.dbSpace.getLength(path);
    }

    @Override
    public IRandomAccessStream getFileStream(Path path, boolean clear, boolean readOnly) throws KDRSException {
        return this.dbSpace.openStream(path, clear, false, false);
    }

    @Override
    public ResourceType getType(Path path) throws KDRSException {
        int existCode = this.dbSpace.exist(path);
        if (existCode == 0) {
            throw new NotFoundException("Not found resource'" + path + "'");
        }
        return existCode == 1 ? ResourceType.FILE : ResourceType.FOLDER;
    }

    @Override
    public void move(Path path1, Path path2) throws KDRSException {
        this.dbSpace.move(path1, path2);
    }

    @Override
    public void refresh(Path path, boolean recursion) throws KDRSException {
    }

    @Override
    public void rename(Path path, String newName) throws KDRSException {
        this.dbSpace.rename(path, newName);
    }

    @Override
    public String[] listChildren(Path path) throws KDRSException {
        HashMap temp = this.dbSpace.list(path);
        String[] children = new String[temp.size()];
        temp.keySet().toArray(children);
        return children;
    }

    @Override
    public boolean isExist(Path path) throws KDRSException {
        return this.dbSpace.exist(path) != 0;
    }
}

