/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.db2;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.data.framework.bos.BosUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.MakeSql;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.bean.FileBlocksInfoBean;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.bean.FileInfoBean;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class DBAccess {
    private static final Logger log = LogUtil.getPackageLogger(DBAccess.class);
    private static int MAX_SIMPLE_ATTRVAL_LEN = 48;

    public static void eraseFileData(Statement stmt, String fid) throws SQLException {
        String sql = MakeSql.clear_file_data(fid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql));
        }
        try {
            stmt.execute(sql);
        }
        catch (SQLException ex) {
            log.debug((Object)("sql:" + sql));
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileInfoBean lookupFile(Connection conn, Path path) throws SQLException {
        PreparedStatement pst;
        long l0;
        ResultSet rs;
        block11: {
            FileInfoBean fileInfoBean;
            block10: {
                String curCompany = DBAccess.getCurrentCtrlUnitNumber();
                List<String> upperCtrlUnits = null;
                if (curCompany != null) {
                    upperCtrlUnits = DBAccess.queryAllUpperCtrlUnit(conn, curCompany);
                }
                String pathText = path.getPathText();
                boolean isKdrsForm = pathText.endsWith(".kdrs-form");
                rs = null;
                String sql = MakeSql.lookup_file(false);
                l0 = 0L;
                if (log.isDebugEnabled()) {
                    l0 = System.currentTimeMillis();
                    log.debug((Object)("Will exec:" + sql));
                }
                pst = null;
                try {
                    pst = conn.prepareStatement(sql);
                    pst.setInt(1, path.deep());
                    pst.setString(2, path.getPathText().toLowerCase());
                    rs = pst.executeQuery();
                    while (rs.next()) {
                        FileInfoBean bean;
                        String id;
                        String curCompanyNum;
                        boolean isFile;
                        String fid = rs.getString(1);
                        Path fpath = Path.valueOf(rs.getString("FPath"));
                        boolean bl = isFile = "1".equals(rs.getString("FType"));
                        if ((isFile || isKdrsForm) && (curCompanyNum = ContextUtils.getCtrlNumFromId(conn, id = rs.getString("FCompanyNumber"))) != null && !curCompanyNum.equals("null") && upperCtrlUnits != null && !upperCtrlUnits.contains(curCompanyNum)) continue;
                        fileInfoBean = bean = new FileInfoBean(fid, fpath, isFile);
                        break block10;
                    }
                    break block11;
                }
                catch (SQLException ex) {
                    try {
                        log.debug((Object)("sql:" + sql));
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("spent:" + (System.currentTimeMillis() - l0) + " ms!"));
                        }
                        CtrlUtil.DB.closeResultSet(rs);
                        CtrlUtil.DB.closeStatement((Statement)pst);
                        throw throwable;
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("spent:" + (System.currentTimeMillis() - l0) + " ms!"));
            }
            CtrlUtil.DB.closeResultSet((ResultSet)rs);
            CtrlUtil.DB.closeStatement((Statement)pst);
            return fileInfoBean;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("spent:" + (System.currentTimeMillis() - l0) + " ms!"));
        }
        CtrlUtil.DB.closeResultSet((ResultSet)rs);
        CtrlUtil.DB.closeStatement((Statement)pst);
        return null;
    }

    public static String[] listFolder(Connection conn, Path path) throws SQLException {
        String[] stringArray;
        String sql = MakeSql.lookup_folder_children_p(path);
        int leavel = path.deep() + 1;
        String pathText = path.getPathText();
        String curCompany = DBAccess.getCurrentCtrlUnitNumber();
        List<String> upperCtrlUnits = null;
        if (curCompany != null) {
            upperCtrlUnits = DBAccess.queryAllUpperCtrlUnit(conn, curCompany);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql));
        }
        ResultSet rs = null;
        PreparedStatement pst = null;
        try {
            pst = conn.prepareStatement(sql);
            pst.setInt(1, leavel);
            pst.setString(2, pathText + "/%");
            rs = pst.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                boolean isFile = "1".equals(rs.getString("ftype"));
                String childPath = rs.getString("FPath");
                boolean isKdrsForm = childPath.endsWith(".kdrs-form");
                if (isFile || isKdrsForm) {
                    String curCompanyId = rs.getString("FCompanyNumber");
                    if (curCompanyId != null && !curCompanyId.equals("null") && upperCtrlUnits != null && !upperCtrlUnits.contains(curCompanyId)) continue;
                    list.add(rs.getString(1));
                    continue;
                }
                list.add(rs.getString(1));
            }
            String[] pathes = new String[list.size()];
            stringArray = list.toArray(pathes);
        }
        catch (SQLException ex) {
            try {
                log.debug((Object)("sql:" + sql));
                throw ex;
            }
            catch (Throwable throwable) {
                CtrlUtil.DB.closeResultSet(rs);
                CtrlUtil.DB.closeStatement((Statement)pst);
                throw throwable;
            }
        }
        CtrlUtil.DB.closeResultSet((ResultSet)rs);
        CtrlUtil.DB.closeStatement((Statement)pst);
        return stringArray;
    }

    public static List<String> queryAllUpperCtrlUnit(Connection conn, String curCtrlUnitNumber) throws SQLException {
        ArrayList<String> arrayList;
        String sql = "select FLONGNUMBER from T_ORG_CTRLUNIT where FNUMBER = ?";
        if (curCtrlUnitNumber != null && curCtrlUnitNumber.startsWith("_!!_")) {
            sql = "select FLONGNUMBER from T_ORG_CTRLUNIT where fid = ? ";
            curCtrlUnitNumber = curCtrlUnitNumber.split("_!!_")[1];
        }
        ResultSet rs = null;
        ArrayList<String> longNumberList = new ArrayList<String>();
        PreparedStatement pst = null;
        try {
            pst = conn.prepareStatement(sql);
            pst.setString(1, curCtrlUnitNumber);
            rs = pst.executeQuery();
            String[] longNumbers = new String[]{};
            while (rs.next()) {
                longNumbers = rs.getString("FLONGNUMBER").split("!");
            }
            for (String number : longNumbers) {
                longNumberList.add(number);
            }
            arrayList = longNumberList;
        }
        catch (SQLException ex) {
            try {
                log.debug((Object)("sql:" + sql));
                throw ex;
            }
            catch (Throwable throwable) {
                CtrlUtil.DB.closeResultSet(rs);
                CtrlUtil.DB.closeStatement((Statement)pst);
                throw throwable;
            }
        }
        CtrlUtil.DB.closeResultSet((ResultSet)rs);
        CtrlUtil.DB.closeStatement((Statement)pst);
        return arrayList;
    }

    public static void renameFile(Statement stmt, String fid, Path newPath) throws SQLException {
        String sql = MakeSql.rename_file(fid, newPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql));
        }
        try {
            stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            log.debug((Object)("sql:" + sql));
            throw ex;
        }
    }

    public static void moveFolder(Statement stmt, Path path1, Path path2) throws SQLException {
        String sql = MakeSql.move_folder(path1, path2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql));
        }
        try {
            stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            log.debug((Object)("sql:" + sql));
            throw ex;
        }
    }

    public static void copyFile(Statement stmt, String fid0, String fid1, boolean isNewFile) throws SQLException {
        String sql0 = isNewFile ? null : MakeSql.clear_file_data(fid1);
        String sql1 = MakeSql.cp_data_toNewFile(fid0, fid1);
        String sql2 = isNewFile ? null : MakeSql.clear_file_attrs(fid1);
        String sql3 = MakeSql.cp_attrs_toNewFile(fid0, fid1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec0:" + sql0));
            log.debug((Object)("Will exec1:" + sql1));
            log.debug((Object)("Will exec2:" + sql2));
            log.debug((Object)("Will exec3:" + sql3));
        }
        try {
            if (sql0 != null) {
                stmt.addBatch(sql0);
            }
            stmt.addBatch(sql1);
            if (sql2 != null) {
                stmt.addBatch(sql2);
            }
            stmt.addBatch(sql3);
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            log.debug((Object)("sql0:" + sql0 + "\nsql1:" + sql1 + "\nsql2:" + sql2 + "\nsql3:" + sql3));
            throw ex;
        }
    }

    public static void deleteFile(Statement stmt, String fid, boolean isFile) throws SQLException {
        String sql2;
        String sql0 = MakeSql.remove_file_entry(fid);
        String sql1 = MakeSql.clear_file_attrs(fid);
        String string = sql2 = isFile ? MakeSql.clear_file_data(fid) : null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec0:" + sql0));
            log.debug((Object)("Will exec1:" + sql1));
            log.debug((Object)("Will exec2:" + sql2));
        }
        try {
            stmt.addBatch(sql0);
            stmt.addBatch(sql1);
            if (sql2 != null) {
                stmt.addBatch(sql2);
            }
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            log.debug((Object)("sql0:" + sql0 + "\nsql1:" + sql1 + "\nsql2:" + sql2));
            throw ex;
        }
    }

    public static void insertFileEntry(Connection conn, String fid, Path path, boolean isFile) throws SQLException {
        int flag = isFile ? 1 : 0;
        String curCompany = DBAccess.getCurrentCtrlUnitNumber();
        String sql = MakeSql.insert_file_entry();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql));
        }
        PreparedStatement pst = null;
        try {
            pst = conn.prepareStatement(sql);
            pst.setString(1, fid);
            pst.setString(2, path.getPathText());
            pst.setInt(3, flag);
            pst.setInt(4, path.deep());
            pst.setString(5, curCompany);
            pst.execute();
        }
        catch (SQLException ex) {
            log.debug((Object)("sql:" + sql));
            throw ex;
        }
        finally {
            CtrlUtil.DB.closeStatement((Statement)pst);
        }
    }

    public static FileBlocksInfoBean readFileBlocksInfo(Statement stmt, String fid) throws SQLException {
        FileBlocksInfoBean fileBlocksInfoBean;
        String sql = MakeSql.load_file_blocks_info(fid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql));
        }
        ResultSet rs = null;
        try {
            int lastUsed = 0;
            int blockCount = 0;
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                lastUsed = rs.getInt(1);
                ++blockCount;
            }
            fileBlocksInfoBean = new FileBlocksInfoBean(fid, blockCount, lastUsed);
        }
        catch (SQLException ex) {
            try {
                log.debug((Object)("sql:" + sql));
                throw ex;
            }
            catch (Throwable throwable) {
                CtrlUtil.DB.closeResultSet(rs);
                throw throwable;
            }
        }
        CtrlUtil.DB.closeResultSet((ResultSet)rs);
        return fileBlocksInfoBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readFileBlock(Statement stmt, String fid, int blockIndex, byte[] blockData) throws SQLException, IOException {
        String sql = MakeSql.read_block(fid, blockIndex);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql));
        }
        ResultSet rs = null;
        try {
            InputStream stream22;
            rs = stmt.executeQuery(sql);
            if (rs.next() && (stream22 = rs.getBinaryStream(1)) != null) {
                try {
                    int n = stream22.read(blockData);
                    return n;
                }
                finally {
                    CtrlUtil.Stream.closeStream((InputStream)stream22);
                }
            }
            int stream22 = 0;
            return stream22;
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            CtrlUtil.DB.closeResultSet((ResultSet)rs);
        }
    }

    public static void writeFileBlock(Connection conn, String fid, int blockIndex, byte[] blockData, int length, boolean isNewBlock) throws SQLException {
        String sql = null;
        sql = isNewBlock ? MakeSql.insert_new_block(fid, blockIndex, length) : MakeSql.update_block(fid, blockIndex, length);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql));
        }
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(blockData, 0, length), length);
            ps.execute();
        }
        catch (SQLException ex) {
            log.debug((Object)("sql:" + sql));
            throw ex;
        }
        finally {
            CtrlUtil.DB.closeStatement((Statement)ps);
        }
    }

    public static int getFileLength(Statement stmt, String fid) throws SQLException {
        ResultSet rs = null;
        String sql = MakeSql.file_length(fid);
        try {
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException ex) {
            log.debug((Object)("sql:" + sql));
            throw ex;
        }
        finally {
            CtrlUtil.DB.closeResultSet((ResultSet)rs);
        }
    }

    public static void insertEmptyFileBlocks(Statement stmt, String fid, int blockCount, int indexFrom, int blockSize) throws SQLException {
        ArrayList<String> sqls = new ArrayList<String>();
        for (int i = 0; i < blockCount; ++i) {
            int blockId = indexFrom + i;
            String sql = MakeSql.insert_empty_block(fid, blockId, blockSize);
            stmt.addBatch(sql);
            sqls.add(sql);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:\n" + sqls));
        }
        stmt.executeBatch();
    }

    public static HashMap loadAttributes(Connection conn, String fid) throws SQLException {
        String sql = MakeSql.load_attributes();
        long l0 = 0L;
        if (log.isDebugEnabled()) {
            l0 = System.currentTimeMillis();
            log.debug((Object)("Will exec:" + sql));
        }
        ResultSet rs = null;
        HashMap<String, String> attrs = null;
        PreparedStatement pst = null;
        try {
            pst = conn.prepareStatement(sql);
            pst.setString(1, fid);
            rs = pst.executeQuery();
            while (rs.next()) {
                String attrName = rs.getString(1);
                String attrVal = null;
                if (rs.getBoolean(2)) {
                    attrVal = rs.getString(3);
                } else {
                    byte[] valBytes = rs.getBytes(4);
                    attrVal = new String(valBytes);
                }
                if (attrs == null) {
                    attrs = new HashMap<String, String>();
                }
                attrs.put(attrName, attrVal);
            }
        }
        catch (SQLException ex) {
            try {
                log.debug((Object)("sql:" + sql));
                throw ex;
            }
            catch (Throwable throwable) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("spent:" + (System.currentTimeMillis() - l0) + " ms!"));
                }
                CtrlUtil.DB.closeResultSet(rs);
                CtrlUtil.DB.closeStatement((Statement)pst);
                throw throwable;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("spent:" + (System.currentTimeMillis() - l0) + " ms!"));
        }
        CtrlUtil.DB.closeResultSet((ResultSet)rs);
        CtrlUtil.DB.closeStatement((Statement)pst);
        return attrs;
    }

    public static void saveAttribute(Connection conn, String fid, String attrName, Object attrVal) throws SQLException {
        HashMap oldAttrs = DBAccess.loadAttributes(conn, fid);
        HashMap newAttrs = oldAttrs == null ? new HashMap() : (HashMap)oldAttrs.clone();
        newAttrs.put(attrName, attrVal);
        DBAccess.saveAttributes(conn, fid, newAttrs, oldAttrs);
    }

    public static void saveAttributes(Connection conn, String fid, HashMap newAttrs) throws SQLException {
        HashMap oldAttrs = DBAccess.loadAttributes(conn, fid);
        DBAccess.saveAttributes(conn, fid, newAttrs, oldAttrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAttributes(Connection conn, String fid, HashMap newAttrs, HashMap oldAttrs) throws SQLException {
        ArrayList alters = DBAccess.collectAttrs(oldAttrs, newAttrs);
        ArrayList<String> batchSqls = new ArrayList<String>();
        StringBuffer deleteSql = null;
        int len = alters.size();
        for (int i = 0; i < len; ++i) {
            String sql;
            AlterAttr alter = (AlterAttr)alters.get(i);
            if (alter.alterType == 0) {
                if (deleteSql == null) {
                    deleteSql = new StringBuffer();
                    deleteSql.append("DELETE FROM T_RPTS_Attributes WHERE FID=");
                    deleteSql.append("'").append(fid).append("'");
                    deleteSql.append(" AND (");
                } else {
                    deleteSql.append(" OR ");
                }
                deleteSql.append("FAttrName='");
                deleteSql.append(alter.name);
                deleteSql.append("' ");
                continue;
            }
            int attrValLen = alter.value.length();
            if (attrValLen <= MAX_SIMPLE_ATTRVAL_LEN) {
                sql = alter.alterType == 1 ? MakeSql.update_attr_standard(fid, alter.name, alter.value) : MakeSql.insert_attr_standard(fid, alter.name, alter.value);
                batchSqls.add(sql);
                continue;
            }
            PreparedStatement ps = null;
            try {
                sql = alter.alterType == 2 ? MakeSql.insert_attr_complex(fid, alter.name) : MakeSql.update_attr_complex(fid, alter.name);
                ps = conn.prepareStatement(sql);
                ps.setBytes(1, alter.value.getBytes());
                ps.execute();
            }
            catch (Throwable throwable) {
                CtrlUtil.DB.closeStatement(ps);
                throw throwable;
            }
            CtrlUtil.DB.closeStatement((Statement)ps);
        }
        if (deleteSql != null) {
            deleteSql.append(")");
            batchSqls.add(deleteSql.toString());
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            for (int i = 0; i < batchSqls.size(); ++i) {
                stmt.addBatch((String)batchSqls.get(i));
            }
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            CtrlUtil.DB.closeStatement((Statement)stmt);
        }
    }

    private static String getCurrentCtrlUnitNumber() {
        try {
            if (ContextUtils.isTemplateSharedGlobally()) {
                return null;
            }
            return ContextUtils.getCurrentCtrlUnitNumber();
        }
        catch (Throwable t) {
            log.warn((Object)t.getMessage(), t);
            return null;
        }
    }

    private static String getCurrentCtrlUnitId() {
        try {
            if (ContextUtils.isTemplateSharedGlobally()) {
                return null;
            }
            return ContextUtils.getCurrentCtrlUnitId();
        }
        catch (Throwable t) {
            log.warn((Object)t.getMessage(), t);
            return null;
        }
    }

    static ArrayList collectAttrs(HashMap oldAttrs, HashMap newAttrs) {
        ArrayList<AlterAttr> alters = new ArrayList<AlterAttr>();
        if (oldAttrs == null) {
            oldAttrs = new HashMap();
        }
        if (newAttrs == null) {
            newAttrs = new HashMap();
        }
        for (Object oldAttrName : oldAttrs.keySet()) {
            Object newAttrVal = newAttrs.get(oldAttrName);
            if (newAttrVal != null) continue;
            alters.add(new AlterAttr((String)oldAttrName, null, 0));
        }
        Iterator names = newAttrs.keySet().iterator();
        Iterator values = newAttrs.values().iterator();
        while (names.hasNext()) {
            Object newAttrName = names.next();
            Object newAttrVal = values.next();
            if (!oldAttrs.containsKey(newAttrName)) {
                if (newAttrVal == null) continue;
                alters.add(new AlterAttr((String)newAttrName, (String)newAttrVal, 2));
                continue;
            }
            if (newAttrVal == null || newAttrVal.equals(oldAttrs.get(newAttrName))) continue;
            alters.add(new AlterAttr((String)newAttrName, (String)newAttrVal, 1));
        }
        return alters;
    }

    public static void deleteDefaultTemplate(Connection conn, Path path) throws SQLException {
        PreparedStatement pstt = conn.prepareStatement("delete from t_rpt_defTemplate where FDEFTEMPLATE = ?");
        pstt.setString(1, "/" + path.getName());
        pstt.execute();
    }

    public static class AlterAttr {
        String name;
        String value;
        int alterType;
        public static final int ALERT_REMOVE = 0;
        public static final int ALERT_UPDATE = 1;
        public static final int ALERT_INSERT = 2;

        AlterAttr(String name, String value, int alterType) {
            this.name = name;
            this.value = value;
            this.alterType = alterType;
        }

        public static String getAlterTypeName(int type) {
            switch (type) {
                case 0: {
                    return "remove";
                }
                case 1: {
                    return "update";
                }
                case 2: {
                    return "insert";
                }
            }
            return "unknown";
        }

        public String toString() {
            return "[" + AlterAttr.getAlterTypeName(this.alterType) + "] name=" + this.name + ",value=" + this.value;
        }
    }

    private static class ContextUtils {
        private ContextUtils() {
        }

        public static String getCurrentCtrlUnitNumber() {
            Context ctx = BosUtil.getBosContext();
            CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String number = ctrlUnitInfo.getNumber();
            return number;
        }

        public static boolean isTemplateSharedGlobally() {
            boolean shareGlobally = true;
            try {
                String shareValue = ParamManager.getParamValue((Context)BosUtil.getBosContext(), null, (String)"templateSharedGlobally");
                shareGlobally = Boolean.parseBoolean(shareValue);
            }
            catch (Throwable t) {
                log.warn((Object)t.getMessage(), t);
            }
            return shareGlobally;
        }

        public static String getCtrlNumFromId(Connection conn, String id) throws SQLException {
            String sql = "select FNUMBER from T_ORG_CTRLUNIT where fid = ? ";
            PreparedStatement pst = conn.prepareStatement(sql);
            pst.setString(1, id);
            ResultSet rs = pst.executeQuery();
            String num = null;
            while (rs.next()) {
                num = rs.getString(1);
            }
            pst.close();
            rs.close();
            return num;
        }

        public static String getCurrentCtrlUnitId() {
            Context ctx = BosUtil.getBosContext();
            CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String id = ctrlUnitInfo.getId().toString();
            return id;
        }
    }
}

