/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.db2;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.BasicRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.IDataSource;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.DBAccess;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ReadOnlyDBStoredFile
extends BasicRandomAccessStream {
    private static final Logger log = LogUtil.getPackageLogger(ReadOnlyDBStoredFile.class);
    private IDataSource connPool;
    private String fid;
    private int offset = 0;
    private int curBlockIdx = 0;
    private int bufferLength = 0;
    private byte[] buffer;
    private byte[] oneByte = new byte[1];

    public ReadOnlyDBStoredFile(String fid, IDataSource connPool) {
        this.fid = fid;
        this.connPool = connPool;
    }

    @Override
    public void close() {
    }

    @Override
    public long length() throws IOException {
        long l;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.connPool.getConnection();
            stmt = conn.createStatement();
            l = DBAccess.getFileLength(stmt, this.fid);
        }
        catch (SQLException ex) {
            try {
                throw new IOException("Internal error");
            }
            catch (Throwable throwable) {
                CtrlUtil.DB.closeStatement(stmt);
                CtrlUtil.DB.closeDBConn((Connection)conn);
                throw throwable;
            }
        }
        CtrlUtil.DB.closeStatement((Statement)stmt);
        CtrlUtil.DB.closeDBConn((Connection)conn);
        return l;
    }

    @Override
    public int read() throws IOException {
        int r = this.read(this.oneByte, 0, 1);
        return r == 0 ? -1 : this.oneByte[0];
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() throws IOException {
        super.checkStatus();
        return this.curBlockIdx * 32768 + this.offset;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("position can't be negative.");
        }
        super.checkStatus();
        if (this.position() == pos) {
            return;
        }
        int newBlkIdx = (int)(pos % 32768L);
        this.offset = (int)(pos % 32768L);
        if (newBlkIdx != this.curBlockIdx || this.buffer == null) {
            this.bufBlockData(newBlkIdx, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bufBlockData(int blockIdx, boolean resetOffset) throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[32768];
        }
        try {
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = this.connPool.getConnection();
                stmt = conn.createStatement();
                this.bufferLength = DBAccess.readFileBlock(stmt, this.fid, blockIdx, this.buffer);
            }
            catch (Throwable throwable) {
                CtrlUtil.DB.closeStatement(stmt);
                CtrlUtil.DB.closeDBConn((Connection)conn);
                throw throwable;
            }
            CtrlUtil.DB.closeStatement((Statement)stmt);
            CtrlUtil.DB.closeDBConn((Connection)conn);
            if (resetOffset) {
                this.offset = 0;
            }
        }
        catch (SQLException ex) {
            log.error((Object)"", (Throwable)ex);
            throw new IOException("Internal error," + ex.getMessage());
        }
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (buf == null || off < 0 || len < 0 || off + len > buf.length) {
            throw new IOException("Bad parameters.");
        }
        super.checkStatus();
        int leftBytes = len;
        int readBytes = 0;
        while (leftBytes > 0) {
            int canRead;
            if (this.offset == this.bufferLength) {
                if (this.buffer != null && this.bufferLength < 32768) break;
                if (this.buffer != null) {
                    ++this.curBlockIdx;
                }
                this.bufBlockData(this.curBlockIdx, true);
            }
            if ((canRead = this.bufferLength - this.offset) == 0) break;
            if (canRead > leftBytes) {
                canRead = leftBytes;
            }
            System.arraycopy(this.buffer, this.offset, buf, off, canRead);
            leftBytes -= canRead;
            off += canRead;
            readBytes += canRead;
            this.offset += canRead;
        }
        return readBytes == 0 ? -1 : readBytes;
    }
}

