/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.meta;

import com.kingdee.bos.ctrl.common.NullValue;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.BasicMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.IFolderMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.IResourceMeta;
import java.util.HashMap;
import java.util.Iterator;

public abstract class FolderMeta
extends BasicMeta
implements IFolderMeta {
    protected HashMap children;
    static final String[] EMPTY_CHILDREN = new String[0];

    public FolderMeta(String name) {
        super(name, ResourceType.FOLDER);
    }

    @Override
    public boolean hasChild() {
        return this.children != null && this.children.size() > 0;
    }

    @Override
    public final String[] listChildren() {
        if (this.children == null) {
            return EMPTY_CHILDREN;
        }
        String[] names = new String[this.children.size()];
        Iterator iterator = this.children.values().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            names[i++] = ((IResourceMeta)iterator.next()).getName();
        }
        return names;
    }

    @Override
    public final IResourceMeta getChild(String name) {
        return this.children == null ? null : (IResourceMeta)this.children.get(name);
    }

    @Override
    public final Iterator getChildren() {
        return this.children == null ? NullValue.NULL_ITERATOR : this.children.values().iterator();
    }

    @Override
    public final boolean addChild(IResourceMeta child) {
        if (this.children == null) {
            this.children = new HashMap();
        }
        child.setParent(this);
        return this.children.put(child.getName(), child) == null;
    }

    public final void addChildren(Iterator iterator) {
        while (iterator.hasNext()) {
            this.addChild((IResourceMeta)iterator.next());
        }
    }

    @Override
    public final boolean removeChild(String child) {
        if (child != null && this.children.remove(child) != null) {
            if (this.children.size() == 0) {
                this.children = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public final void removeChildren() {
        if (this.children != null) {
            this.children.clear();
            this.children = null;
        }
    }

    @Override
    public String toString() {
        return "Folder:" + this.getName() + ", children:" + this.children;
    }
}

