/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.meta;

import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.fs.FSSpaceProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.BasicMetas;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.FileMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.ILazyFolderMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.IResourceMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.LazyFolderMeta;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class LocalFileMetas
extends BasicMetas {
    private String rootDir;

    public LocalFileMetas(String rootDir) throws KDRSException {
        this.rootDir = rootDir;
    }

    @Override
    protected Iterator loadChildren(Path folderPath) {
        String localPath = FSSpaceProvider.makeFilePath(folderPath, this.rootDir);
        File folder = new File(localPath);
        if (folder.exists()) {
            ArrayList<LazyFolderMeta> childList = new ArrayList<LazyFolderMeta>();
            File[] children = folder.listFiles();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    String childName = children[i].getName();
                    childList.add((LazyFolderMeta)(children[i].isDirectory() ? new LazyFolderMeta(childName) : new FileMeta(childName)));
                }
            }
            return childList.iterator();
        }
        return null;
    }

    @Override
    public void updateFolderMeta(Path folderPath, ILazyFolderMeta folderMeta) throws KDRSException {
    }

    @Override
    public void updateMeta(Path resPath, IResourceMeta meta) throws KDRSException {
    }
}

