/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions;

import com.kingdee.bos.ctrl.common.ui.XmlMenuBuilder;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.IActionExit;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.IActionManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.menu.AbstractR1DesignerAction;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.menu.ActionExit;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.menu.ActionSave;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.menu.IR1DesignerAction;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.IOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.CopyOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.CutOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.DeleteOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.PasteOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.RedoOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.UndoOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.alignment.BottomAlignmentOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.alignment.HCenterAlignmentOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.alignment.HLayoutAlignmentOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.alignment.LeftAlignmentOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.alignment.RightAlignmentOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.alignment.TopAlignmentOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.alignment.VCenterAlignmentOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.alignment.VLayoutAlignmentOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.location.HCenterLocationOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.location.VMiddleLocationOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.size.SameHeightOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.size.SameSizeOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.edit.size.SameWidthOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.format.PropertyOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.format.PropertyValidateOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.format.StyleOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.toolbar.ISimilarAction;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.toolbar.LockAction;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.event.StateChangedEvent;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.event.StateChangedListener;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.AbstractR1Designer;
import com.kingdee.bos.ctrl.swing.KDMenu;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import org.jdom2.Element;

public abstract class AbstractActionManager
extends XmlMenuBuilder
implements IActionManager {
    public static final String Key_Exit = "exit";
    private static final String Key_Save = "save";
    private static final String Key_Validate = "validate";
    private static final String Key_Properties = "properties";
    private static final String Key_Style = "style";
    private static final String Key_Undo = "undo";
    private static final String Key_Redo = "redo";
    private static final String Key_Cut = "cut";
    private static final String Key_Copy = "copy";
    private static final String Key_Paste = "paste";
    private static final String Key_Delete = "delete";
    private static final String Key_LeftAlignment = "leftAlignment";
    private static final String Key_HCenterAlignment = "centerAlignment";
    private static final String Key_RightAlignment = "rightAlignment";
    private static final String Key_TopAlignment = "topAlignment";
    private static final String Key_VCenterAlignment = "middleAlignment";
    private static final String Key_BottomAlignment = "bottomAlignment";
    private static final String Key_HLayoutAlignment = "hLayout";
    private static final String Key_VLayoutAlignment = "vLayout";
    private static final String Key_SameHeight = "sameHeight";
    private static final String Key_SameWidth = "sameWidth";
    private static final String Key_SameSize = "sameSize";
    private static final String Key_HCenter = "centerLocation";
    private static final String Key_VMiddle = "middleLocation";
    private static final String Key_Lock = "lock";
    private AbstractR1Designer _designer;

    public AbstractActionManager(AbstractR1Designer designer, Element root) {
        super(root);
        this._designer = designer;
    }

    @Override
    public IActionExit getActoinExit() {
        Action acExit = this.getAction(Key_Exit);
        if (acExit instanceof IActionExit) {
            return (IActionExit)((Object)acExit);
        }
        return null;
    }

    protected Object wrapAction(Object obj) {
        if (obj instanceof IOperate) {
            return new ActionWrapOperate((IOperate)obj);
        }
        return obj;
    }

    protected Action createDefaultAction(String id) {
        if (StringUtil.equalsIgnoreCase((String)id, (String)Key_Save)) {
            return new ActionSave();
        }
        if (StringUtil.equalsIgnoreCase((String)id, (String)Key_Exit)) {
            return new ActionExit();
        }
        if (StringUtil.equalsIgnoreCase((String)id, (String)Key_Lock)) {
            return new LockAction();
        }
        Action result = this.createAction(id);
        if (result != null) {
            return result;
        }
        return this.operate2Action(id);
    }

    private Action operate2Action(String id) {
        IOperate op = null;
        if (StringUtil.equalsIgnoreCase((String)id, (String)Key_Properties)) {
            op = new PropertyOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_Validate)) {
            op = new PropertyValidateOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_Style)) {
            op = new StyleOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_Undo)) {
            op = new UndoOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_Redo)) {
            op = new RedoOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_Cut)) {
            op = new CutOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_Copy)) {
            op = new CopyOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_Paste)) {
            op = new PasteOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_Delete)) {
            op = new DeleteOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_LeftAlignment)) {
            op = new LeftAlignmentOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_HCenterAlignment)) {
            op = new HCenterAlignmentOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_RightAlignment)) {
            op = new RightAlignmentOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_HLayoutAlignment)) {
            op = new HLayoutAlignmentOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_TopAlignment)) {
            op = new TopAlignmentOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_VCenterAlignment)) {
            op = new VCenterAlignmentOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_BottomAlignment)) {
            op = new BottomAlignmentOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_VLayoutAlignment)) {
            op = new VLayoutAlignmentOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_SameHeight)) {
            op = new SameHeightOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_SameWidth)) {
            op = new SameWidthOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_SameSize)) {
            op = new SameSizeOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_HCenter)) {
            op = new HCenterLocationOperate();
        } else if (StringUtil.equalsIgnoreCase((String)id, (String)Key_VMiddle)) {
            op = new VMiddleLocationOperate();
        }
        if (op == null) {
            op = this.createOperate(id);
        }
        if (op != null) {
            return new ActionWrapOperate(op);
        }
        return AbstractActionManager.getDoNothingAction();
    }

    protected abstract Action createAction(String var1);

    protected abstract IOperate createOperate(String var1);

    private String autoAddDotDotDot(String text, boolean isDotDotDot) {
        if (isDotDotDot) {
            return new StringBuffer(text).append("...").toString();
        }
        return text;
    }

    protected void cacheMenu(String id, KDMenu menu) {
    }

    protected void initMenuItemExtended(JMenuItem ctrl, Action action) {
        if (action instanceof AbstractR1DesignerAction) {
            AbstractR1DesignerAction ac = (AbstractR1DesignerAction)action;
            ctrl.setText(this.autoAddDotDotDot(ctrl.getText(), ac.isNeedShowUI()));
            this.bindDesigner(ac);
        }
    }

    protected void initButtonExtended(JComponent ctrl, Object action) {
        IR1DesignerAction ac;
        if (action instanceof IR1DesignerAction && (ac = (IR1DesignerAction)action).getDesigner() == null) {
            this.bindDesigner(ac);
        }
        if (action instanceof ISimilarAction) {
            ISimilarAction sa = (ISimilarAction)action;
            sa.setBindCtrl(ctrl);
        }
    }

    private void bindDesigner(IR1DesignerAction ac) {
        ac.setDesigner(this._designer);
        this._designer.addStateChangedListener(new StateChangedHandler(ac));
    }

    static class ActionWrapOperate
    extends AbstractR1DesignerAction {
        private IOperate operate;

        public ActionWrapOperate(IOperate op) {
            this.operate = op;
            KeyStroke ks = op.getAccelerator();
            if (ks != null) {
                this.putValue("AcceleratorKey", ks);
            }
        }

        @Override
        protected IOperate createOperate() {
            return this.operate;
        }
    }

    protected static class StateChangedHandler
    implements StateChangedListener {
        private IR1DesignerAction _action;

        public StateChangedHandler(IR1DesignerAction action) {
            this._action = action;
        }

        @Override
        public void stateChanged(StateChangedEvent evt) {
            this._action.todoStateChanged(evt);
        }

        @Override
        public void selectionChanged(ChangeEvent evt) {
            this._action.todoSelectionChanged(evt);
        }
    }
}

