/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.data;

import com.kingdee.bos.ctrl.common.ui.RenameDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.MapUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.data.AbstractDataOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.DataTree;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class RenameDataOperate
extends AbstractDataOperate {
    @Override
    public void setSelectedData(DataExtend[] data) {
        this.isValid = data != null && data.length == 1;
    }

    @Override
    public boolean operate() {
        DataExtend[] dataExts = null;
        try {
            dataExts = this.getCore().getDataTree().getSelectedData();
        }
        catch (DataTree.SelectErrorException e) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("data.RenameDataOperate.notDataNoRename", ""), (String)MultiLanguageUtil.getMLS("data.RenameDataOperate.rename", ""), (Component)this.getParentCtrl());
            return false;
        }
        if (dataExts.length > 1) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("data.RenameDataOperate.onlyOneName", ""), (String)MultiLanguageUtil.getMLS("data.RenameDataOperate.rename", ""), (Component)this.getParentCtrl());
            return false;
        }
        DataExtend ext = dataExts[0];
        HashMap oldAlias = new HashMap();
        MapUtil.subKeyPrefix((Map)ext.getProperties(), (String)"alias.", oldAlias);
        Window parentWin = SwingUtilities.getWindowAncestor(this.getParentCtrl());
        DataRenameDialog dlg = parentWin instanceof Dialog ? new DataRenameDialog((Dialog)parentWin) : (parentWin instanceof Frame ? new DataRenameDialog((Frame)parentWin) : new DataRenameDialog());
        dlg.setTarget(ext);
        dlg.setTitle(MultiLanguageUtil.getMLS("data.RenameDataOperate.rename", ""));
        dlg.setOldName(ext.getName());
        dlg.setOldAlias(oldAlias);
        if (dlg.showDialog()) {
            String oldName = ext.getName();
            String newName = dlg.getNewName();
            ext.setName(newName);
            HashMap newAlias = dlg.getNewAlias();
            Map map = ext.getProperties();
            map.put("alias", "#1");
            MapUtil.addKeyPrefix((Map)newAlias, (String)"alias.", (Map)map);
            this.getDataManager().renameData(ext, oldName, newName);
            this.getDataManager().realiasData(ext);
            return true;
        }
        return false;
    }

    class DataRenameDialog
    extends RenameDialog {
        private DataExtend target;

        public DataRenameDialog() {
        }

        public DataRenameDialog(Dialog parent) {
            super(parent);
        }

        public DataRenameDialog(Frame parent) {
            super(parent);
        }

        public void setTarget(DataExtend t) {
            this.target = t;
        }

        protected boolean verify() {
            if (super.verify()) {
                if (RenameDataOperate.this.getDataManager().isNameExist(this.getNewName(), this.target)) {
                    WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("data.RenameDataOperate.nameHaveExist", ""), (String)this.getTitle(), (Component)((Object)this));
                    return false;
                }
                if (RenameDataOperate.this.getDataManager().isNameKeyWord(this.getNewName())) {
                    WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("data.RenameDataOperate.keyWordNoUse", ""), (String)this.getTitle(), (Component)((Object)this));
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

