/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.grid;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.AbstractOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractLayoutGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractLayoutGridCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportSelectionModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;

public class MergeOperate
extends AbstractOperate {
    @Override
    public boolean operate() {
        ElementPath[] eps = this.getSelecteds();
        if (eps.length > 1 && eps[0].getRootPathComponent() instanceof AbstractGrid) {
            AbstractGrid grid = (AbstractGrid)eps[0].getRootPathComponent();
            Point[] ptMinMax = this.searchMinMax(eps);
            if (ptMinMax == null) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("grid.MergeOperate.onlyUnit", ""), (String)this.getPromptTitle(), (Component)this.getParentCtrl());
                return false;
            }
            int rMin = ptMinMax[0].x;
            int cMin = ptMinMax[0].y;
            int rMax = ptMinMax[1].x;
            int cMax = ptMinMax[1].y;
            if (this.checkSelection(grid, rMin, cMin, rMax, cMax)) {
                if (MergeOperate.checkChildren(grid, rMin, cMin, rMax, cMax) && !WindowUtil.msgboxYesNo((Component)this.getParentCtrl(), (Object)MultiLanguageUtil.getMLS("grid.MergeOperate.yesNo", ""), (String)this.getPromptTitle())) {
                    return false;
                }
                this.getCore().storeUndoState(MultiLanguageUtil.getMLS("grid.MergeOperate.coaltionMerge", ""));
                MergeBlock mb = MergeBlock.create(cMin, cMax, rMin, rMax);
                for (int i = 0; i < eps.length; ++i) {
                    AbstractCell cell = (AbstractCell)eps[i].getLastPathComponent();
                    cell.setMergeBlock(mb);
                    ElementPath epCell = grid.makeElementPath(cell);
                    if (mb.isFirstCell(grid.getIndexOfCell(cell))) {
                        this.getCore().setSelection(epCell);
                        continue;
                    }
                    if (cell instanceof IContainer) {
                        this.getCore().getModel().removeAllChildren((IContainer)((Object)cell));
                    }
                    this.getCore().getModel().fireRemoveEvent(epCell);
                }
                ContainerUtil.layoutChildren(grid);
                this.getCore().getPageContainer().repaint();
                return true;
            }
            WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("grid.MergeOperate.cantCoalition", ""), (String)this.getPromptTitle(), (Component)this.getParentCtrl());
            return false;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        if (this.isMultiSelected()) {
            ElementPath elePath = this.getSelected();
            return elePath.getLastPathComponent() instanceof AbstractCell;
        }
        return false;
    }

    @Override
    public boolean isNeedShowUI() {
        return false;
    }

    private Point[] searchMinMax(ElementPath[] epSelected) {
        AbstractGrid grid = null;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < epSelected.length; ++i) {
            AbstractCell cell;
            MergeBlock mb;
            Object obj = epSelected[i].getLastPathComponent();
            if (!(obj instanceof AbstractCell)) {
                return null;
            }
            if (grid == null) {
                grid = (AbstractGrid)epSelected[i].getRootPathComponent();
            }
            if ((mb = (cell = (AbstractCell)obj).getMergeBlock()) == null) {
                list.add(cell);
                continue;
            }
            Point pt = grid.getIndexOfCell(cell);
            if (!mb.isFirstCell(pt)) continue;
            for (int x = mb.getLeft(); x <= mb.getRight(); ++x) {
                for (int y = mb.getTop(); y <= mb.getBottom(); ++y) {
                    list.add(new Point(y, x));
                }
            }
        }
        int rMin = Integer.MAX_VALUE;
        int rMax = 0;
        int cMin = Integer.MAX_VALUE;
        int cMax = 0;
        for (int i = 0; i < list.size(); ++i) {
            Point pt;
            Object obj = list.get(i);
            if (obj instanceof AbstractCell) {
                AbstractCell cell = (AbstractCell)obj;
                pt = grid.getIndexOfCell(cell);
            } else {
                pt = (Point)obj;
            }
            if (pt.x < rMin) {
                rMin = pt.x;
            }
            if (pt.x > rMax) {
                rMax = pt.x;
            }
            if (pt.y < cMin) {
                cMin = pt.y;
            }
            if (pt.y <= cMax) continue;
            cMax = pt.y;
        }
        return new Point[]{new Point(rMin, cMin), new Point(rMax, cMax)};
    }

    private boolean checkSelection(AbstractGrid grid, int rMin, int cMin, int rMax, int cMax) {
        ReportSelectionModel model = this.getCore().getSelectionModel();
        for (int i = rMin; i <= rMax; ++i) {
            AbstractRow row = grid.getRow(i);
            for (int j = cMin; j <= cMax; ++j) {
                AbstractCell cell = row.getCell(j);
                MergeBlock mb = cell.getMergeBlock();
                if (mb != null) {
                    cell = grid.getCell(mb.getTop(), mb.getLeft());
                }
                if (model.contains(grid.makeElementPath(cell))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkChildren(AbstractGrid grid, int rMin, int cMin, int rMax, int cMax) {
        if (grid instanceof AbstractLayoutGrid) {
            for (int i = rMin; i <= rMax; ++i) {
                AbstractRow row = grid.getRow(i);
                for (int j = cMin; j <= cMax; ++j) {
                    AbstractLayoutGridCell cell;
                    if (i == rMin && j == cMin || (cell = (AbstractLayoutGridCell)row.getCell(j)).getChildrenCount() <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

