/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.IDataTreeOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IBind;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.exception.R1DesignerException;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PageContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.icon.R1DesignerIcons;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.CursorManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.DataUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DataTree {
    private ComboPanel _core;
    private KDTree _treeCtrl;
    private KDTreeView _treeView;
    private List _actions = new ArrayList();

    public DataTree(ComboPanel core) {
        this._core = core;
        this.init();
        this.initListener();
    }

    private void init() {
        this._treeCtrl = new KDTree((ITreeNode)new DefaultKingdeeTreeNode(), false);
        this._treeCtrl.setRootVisible(false);
        this._treeCtrl.setShowsRootHandles(true);
        this._treeCtrl.setShowPopMenuDefaultItem(false);
        ((DefaultTreeModel)this._treeCtrl.getModel()).setAsksAllowsChildren(true);
        this._treeView = new KDTreeView(this._treeCtrl);
        this._treeView.setShowButton(false);
    }

    private void initListener() {
        MouseHandler mouseHandler = new MouseHandler(this._core);
        this._treeCtrl.addMouseListener((MouseListener)mouseHandler);
        this._treeCtrl.addMouseMotionListener((MouseMotionListener)mouseHandler);
        this._treeCtrl.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DataExtend[] selected = null;
                try {
                    selected = DataTree.this.getSelectedData();
                }
                catch (SelectErrorException selectErrorException) {
                    // empty catch block
                }
                for (PackOperate po : DataTree.this._actions) {
                    IDataTreeOperate oprImpl = po.getOperate();
                    oprImpl.setSelectedData(selected);
                    po.setEnabled(oprImpl.isValid());
                }
            }
        });
    }

    public void addButton(IDataTreeOperate operate, Icon icon, String tooltip) {
        PackOperate po = new PackOperate(operate, icon, tooltip);
        KDWorkButton btnAdd = new KDWorkButton((Action)po);
        this._treeView.getControlPane().add((Component)btnAdd);
        this._actions.add(po);
    }

    public JComponent getCtrl() {
        return this._treeView;
    }

    public void addTreePopupMenuListener(TreePopupMenuListener listener) {
        this._treeCtrl.addTreePopupMenu(listener);
    }

    public void update() {
        DataUtil.updataDataTree(this._core.getModel().getDataManager(), this._treeCtrl);
    }

    public void updateReportParam() {
        if (this._core.getModel().getDataManager().isSupportReportParams()) {
            DataUtil.updateReportParam(this._treeCtrl, this._core.getModel().getDataManager().getReportParams());
        }
    }

    public void addData(DataExtend ext, Object data) {
        DataUtil.addDataNode(this._core.getModel().getDataManager(), this._treeCtrl, data, ext);
    }

    public void insertDataNode(DataExtend ext, Object data, int idx) {
        DataUtil.insertDataNode(this._core.getModel().getDataManager(), this._treeCtrl, data, ext, idx);
    }

    public void removeData(DataExtend ext) {
        DataUtil.removeDataNode(this._treeCtrl, ext);
    }

    public void renameData(DataExtend ext) {
        DataUtil.updateDataNodeText(this._treeCtrl, ext);
    }

    public DataExtend[] getSelectedData() throws SelectErrorException {
        ArrayList<Object> result = new ArrayList<Object>();
        TreePath[] paths = this._treeCtrl.getSelectionPaths();
        if (paths == null) {
            throw new SelectErrorException("Have not selected.");
        }
        for (int i = 0; i < paths.length; ++i) {
            DataExtend ext;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)paths[i].getLastPathComponent();
            Object obj = node.getUserObject();
            if (!(obj instanceof DataExtend) || StringUtil.equalsIgnoreCase((String)(ext = (DataExtend)((Object)obj)).getName(), (String)"report") || StringUtil.equalsIgnoreCase((String)ext.getName(), (String)"context")) {
                throw new SelectErrorException("The selected is not Data.");
            }
            result.add(obj);
        }
        return result.toArray(new DataExtend[0]);
    }

    static class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private ComboPanel core;
        private Object parentObj;
        private Object nodeObj;
        private ElementPath targetEp;
        private boolean isCanDrop = false;
        private Point ptAtPageContainer;

        public MouseHandler(ComboPanel core) {
            this.core = core;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            KDTree tree;
            TreePath path;
            this.isCanDrop = false;
            this.nodeObj = null;
            this.parentObj = null;
            if (SwingUtilities.isLeftMouseButton(e) && (path = (tree = (KDTree)e.getSource()).getClosestPath(e.getX(), e.getY())) != null && path.getLastPathComponent() instanceof DefaultKingdeeTreeNode) {
                this.nodeObj = ((DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject();
                this.parentObj = ((DefaultKingdeeTreeNode)path.getParentPath().getLastPathComponent()).getUserObject();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            KDTree tree = (KDTree)e.getSource();
            tree.setCursor(CursorManager.getDefault());
            PageContainer pc = this.core.getPageContainer();
            pc.setCursor(CursorManager.getDefault());
            if (this.isCanDrop) {
                this.doReleased(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && this.nodeObj != null) {
                KDTree tree = (KDTree)e.getSource();
                PageContainer pc = this.core.getPageContainer();
                if (tree.getCursor() != CursorManager.getDragDrop()) {
                    tree.setCursor(CursorManager.getDragDrop());
                }
                this.ptAtPageContainer = SwingUtilities.convertPoint((Component)tree, e.getX(), e.getY(), pc);
                this.ptAtPageContainer.setLocation(1.0 / this.core.getScale() * this.ptAtPageContainer.getX(), 1.0 / this.core.getScale() * this.ptAtPageContainer.getY());
                this.targetEp = pc.searchTopElement(this.ptAtPageContainer);
                String dsName = null;
                MetaClass mc = null;
                MetaField mf = null;
                if (this.nodeObj instanceof MetaField) {
                    mf = (MetaField)this.nodeObj;
                    dsName = ((DataExtend)((Object)this.parentObj)).getName();
                } else if (this.nodeObj instanceof DataExtend) {
                    dsName = ((DataExtend)((Object)this.nodeObj)).getName();
                }
                mc = (MetaClass)this.core.getModel().getDataManager().getObject(dsName);
                this.isCanDrop = this.isTargetCanDrop(this.targetEp, mc, mf);
                if (this.isCanDrop) {
                    pc.setCursor(R1DesignerIcons.CURSOR_MOVEDDROP);
                } else {
                    pc.setCursor(R1DesignerIcons.CURSOR_FORBID);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private boolean isTargetCanDrop(ElementPath targetEp, MetaClass metaClass, MetaField metaField) {
            IBind bind;
            if (targetEp == null || metaClass == null) {
                return false;
            }
            Object objRo = targetEp.getRootPathComponent();
            IElement ele = (IElement)targetEp.getLastPathComponent();
            if (objRo instanceof IBind && (bind = (IBind)objRo).getDataSource().isTypeSupproted(metaClass.getType())) {
                return bind.isDraggedCanBind(metaClass, metaField, ele);
            }
            return false;
        }

        private void doReleased(MouseEvent e) {
            this.core.storeUndoState(MultiLanguageUtil.getMLS("core.DataTree.bindField", ""));
            String dsName = null;
            MetaField mf = null;
            if (this.nodeObj instanceof MetaField) {
                mf = (MetaField)this.nodeObj;
                dsName = ((DataExtend)((Object)this.parentObj)).getName();
            } else if (this.nodeObj instanceof MetaClass) {
                dsName = ((DataExtend)((Object)this.nodeObj)).getName();
            }
            IBind bind = (IBind)this.targetEp.getRootPathComponent();
            IElement ele = (IElement)this.targetEp.getLastPathComponent();
            bind.bindDraggedData(dsName, mf, ele, (JComponent)this.core.getPanel(), this.core.getPromptTitle(), e);
            this.core.getModel().setDirty(true);
            this.core.getPanel().repaint();
        }
    }

    class PackOperate
    extends AbstractAction {
        private IDataTreeOperate oprImpl;

        public PackOperate(IDataTreeOperate opr, Icon icon, String prompt) {
            this.oprImpl = opr;
            this.oprImpl.setCore(DataTree.this._core);
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", prompt);
        }

        public IDataTreeOperate getOperate() {
            return this.oprImpl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.oprImpl.operate();
        }
    }

    public static class SelectErrorException
    extends R1DesignerException {
        public SelectErrorException() {
        }

        public SelectErrorException(String message) {
            super(message);
        }
    }
}

