/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.AbstractDoubleClickEditor;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.IDoubleClick;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class TextEditor
extends AbstractDoubleClickEditor {
    private IDoubleClick bindObject;
    private JTextComponent ctrl;
    private KDScrollPane scrollPane;
    private boolean isCancel;

    private TextEditor() {
    }

    public static TextEditor createInstance(JTextComponent textCmp) {
        TextEditor inst = new TextEditor();
        inst.initCtrl(textCmp);
        return inst;
    }

    public static TextEditor createInstance() {
        return TextEditor.createInstance((JTextComponent)new KDTextField());
    }

    private void initCtrl(JTextComponent textCmp) {
        this.ctrl = textCmp;
        this.ctrl.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (TextEditor.this.isCancel) {
                    TextEditor.this.fireCancelEdit();
                } else {
                    TextEditor.this.acceptEdit();
                }
            }
        });
        this.ctrl.setFocusTraversalKeysEnabled(false);
        InputMap inputMap = this.ctrl.getInputMap(2);
        ActionMap actionMap = this.ctrl.getActionMap();
        KeyStroke ks_ctrlEnter = KeyStroke.getKeyStroke(10, 128);
        inputMap.put(ks_ctrlEnter, "Ctrl+Enter");
        actionMap.put(inputMap.get(ks_ctrlEnter), new CtrlEnterAction());
        KeyStroke ks_Esc = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(ks_Esc, "Esc");
        actionMap.put(inputMap.get(ks_Esc), new EscAction());
    }

    public void setScrollPane(KDScrollPane scp) {
        this.scrollPane = scp;
    }

    @Override
    public KDScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public JComponent getEditorCtrl() {
        return this.ctrl;
    }

    @Override
    public void setValue(Object value) {
        this.ctrl.setText((String)value);
    }

    private void acceptEdit() {
        this.bindObject.setEditedValue(this.ctrl.getText());
        this.fireAcceptEdit();
    }

    @Override
    public void setBindObject(IDoubleClick obj) {
        this.isCancel = false;
        this.bindObject = obj;
    }

    class EscAction
    extends AbstractAction {
        EscAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextEditor.this.isCancel = true;
            TextEditor.this.fireCancelEdit();
        }
    }

    class CtrlEnterAction
    extends AbstractAction {
        CtrlEnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextEditor.this.acceptEdit();
        }
    }
}

