/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.Line;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import java.awt.Point;

public class StickUtil {
    private static int STICK_ARG = 10;
    private static int NEAR_ARG = 60;
    private static int THRUM = 15;

    public static Line[] moveStickTo(IReportObject ele, Point mouseOffset) {
        MaxMinPair pair;
        int nearestX = -32767;
        int nearestY = -32767;
        int minDistanceX = STICK_ARG;
        int minDistanceY = STICK_ARG;
        IReportObject eleStickToX = null;
        IReportObject eleStickToY = null;
        boolean isLeft = false;
        boolean isTop = false;
        Point posEle = new Point(ele.getXLom(), ele.getYLom());
        Util.lom2Pixel(posEle);
        posEle.translate(mouseOffset.x, mouseOffset.y);
        int eleHeight = Util.lom2Pixel(ele.getHeightLom());
        int eleWidth = Util.lom2Pixel(ele.getWidthLom());
        ElementPath parentPath = ele.getParent();
        IContainer parent = (IContainer)parentPath.getLastPathComponent();
        for (IReportObject eleBrother : parent.getChildren()) {
            if (ele == eleBrother) continue;
            Point posBrother = new Point(eleBrother.getXLom(), eleBrother.getYLom());
            Util.lom2Pixel(posBrother);
            int brotherHeight = Util.lom2Pixel(eleBrother.getHeightLom());
            int brotherWidth = Util.lom2Pixel(eleBrother.getWidthLom());
            if (StickUtil.isNearEnough(posEle.y, eleHeight, posBrother.y, brotherHeight)) {
                int tempX = posBrother.x;
                int tempDistanceX = Math.abs(posEle.x - tempX);
                if (tempDistanceX < minDistanceX) {
                    minDistanceX = tempDistanceX;
                    nearestX = tempX;
                    eleStickToX = eleBrother;
                    isLeft = true;
                } else {
                    tempX = posBrother.x + brotherWidth;
                    tempDistanceX = Math.abs(posEle.x - tempX);
                    if (tempDistanceX < minDistanceX) {
                        minDistanceX = tempDistanceX;
                        nearestX = tempX;
                        eleStickToX = eleBrother;
                        isLeft = true;
                    } else {
                        tempX = posBrother.x + brotherWidth - eleWidth;
                        tempDistanceX = Math.abs(posEle.x - tempX);
                        if (tempDistanceX < minDistanceX) {
                            minDistanceX = tempDistanceX;
                            nearestX = tempX;
                            eleStickToX = eleBrother;
                            isLeft = false;
                        } else {
                            tempX = posBrother.x - eleWidth;
                            tempDistanceX = Math.abs(posEle.x - tempX);
                            if (tempDistanceX < minDistanceX) {
                                minDistanceX = tempDistanceX;
                                nearestX = tempX;
                                eleStickToX = eleBrother;
                                isLeft = false;
                            }
                        }
                    }
                }
            }
            if (!StickUtil.isNearEnough(posEle.x, eleWidth, posBrother.x, brotherWidth)) continue;
            int tempY = posBrother.y;
            int tempDistanceY = Math.abs(posEle.y - tempY);
            if (tempDistanceY < minDistanceY) {
                minDistanceY = tempDistanceY;
                nearestY = tempY;
                eleStickToY = eleBrother;
                isTop = true;
                continue;
            }
            tempY = posBrother.y + brotherHeight;
            tempDistanceY = Math.abs(posEle.y - tempY);
            if (tempDistanceY < minDistanceY) {
                minDistanceY = tempDistanceY;
                nearestY = tempY;
                eleStickToY = eleBrother;
                isTop = true;
                continue;
            }
            tempY = posBrother.y + brotherHeight - eleHeight;
            tempDistanceY = Math.abs(posEle.y - tempY);
            if (tempDistanceY < minDistanceY) {
                minDistanceY = tempDistanceY;
                nearestY = tempY;
                eleStickToY = eleBrother;
                isTop = false;
                continue;
            }
            tempY = posBrother.y - eleHeight;
            tempDistanceY = Math.abs(posEle.y - tempY);
            if (tempDistanceY >= minDistanceY) continue;
            minDistanceY = tempDistanceY;
            nearestY = tempY;
            eleStickToY = eleBrother;
            isTop = false;
        }
        if (nearestX < 0 && nearestY < 0) {
            return null;
        }
        Point ptRelaPage = ContainerUtil.getPointAtPage(ele);
        Line[] lines = new Line[2];
        if (nearestX >= 0) {
            mouseOffset.x += nearestX - posEle.x;
            int yEleStickTo = Util.lom2Pixel(eleStickToX.getYLom());
            pair = MaxMinPair.createPair(yEleStickTo, yEleStickTo + Util.lom2Pixel(eleStickToX.getHeightLom()), posEle.y, posEle.y + eleHeight);
            int x = nearestX + (isLeft ? 0 : eleWidth) + ptRelaPage.x;
            lines[0] = new Line(x, pair.getMin() - THRUM + ptRelaPage.y, x, pair.getMax() + THRUM + ptRelaPage.y);
        }
        if (nearestY >= 0) {
            mouseOffset.y += nearestY - posEle.y;
            int xEleStickTo = Util.lom2Pixel(eleStickToY.getXLom());
            pair = MaxMinPair.createPair(xEleStickTo, xEleStickTo + Util.lom2Pixel(eleStickToY.getWidthLom()), posEle.x, posEle.x + eleWidth);
            int y = nearestY + (isTop ? 0 : eleHeight) + ptRelaPage.y;
            lines[1] = new Line(pair.getMin() - THRUM + ptRelaPage.x, y, pair.getMax() + THRUM + ptRelaPage.x, y);
        }
        return lines;
    }

    private static boolean isNearEnough(int startOri, int lengthOri, int startRefer, int lengthRefer) {
        return startOri >= startRefer - lengthOri - NEAR_ARG && startOri <= startRefer + lengthRefer + NEAR_ARG;
    }

    public static class MaxMinPair {
        private int max;
        private int min;

        public MaxMinPair(int min, int max) {
            this.setMin(min);
            this.setMax(max);
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public int getMin() {
            return this.min;
        }

        public void setMin(int min) {
            this.min = min;
        }

        public static MaxMinPair createPair(int n1, int n2, int n3, int n4) {
            int max = Math.max(n4, Math.max(n3, Math.max(n1, n2)));
            int min = Math.min(n4, Math.min(n3, Math.min(n1, n2)));
            return new MaxMinPair(min, max);
        }
    }

    public static class StickParm {
        private int minDistance;
        private IReportObject stickObject;
        private int nearestValue;

        public static StickParm create(StickParm oriParm, int value, int referValue, IReportObject referObject) {
            int oriMinDistance = oriParm == null ? Integer.MAX_VALUE : oriParm.minDistance;
            StickParm newParm = null;
            int tempDistance = Math.abs(value - referValue);
            if (tempDistance < oriMinDistance) {
                newParm = new StickParm();
                newParm.minDistance = tempDistance;
                newParm.nearestValue = referValue;
                newParm.stickObject = referObject;
            }
            return newParm;
        }

        public int getMinDistance() {
            return this.minDistance;
        }

        public int getNearestValue() {
            return this.nearestValue;
        }

        public IReportObject getReferenceObject() {
            return this.stickObject;
        }
    }
}

