/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.selection;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class SelectionRenderer {
    public static int BLOCK_WIDTH = 6;
    public static int HALF_BLOCK_WIDTH = BLOCK_WIDTH / 2;

    public void drawSelected(Graphics g, ElementPath elePath, boolean isCurrent) {
        Object ele = elePath.getLastPathComponent();
        IReportObject ro = (IReportObject)elePath.getRootPathComponent();
        if (ele instanceof IReportObject) {
            this.drawSelectedObject(g, (IReportObject)ele, isCurrent);
        } else if (ele instanceof IElement && ro instanceof ICompositeObject) {
            ((ICompositeObject)((Object)ro)).getInnerSelectionRenderer().drawSelected(g, elePath, isCurrent);
        }
    }

    private void drawSelectedObject(Graphics g, IReportObject ro, boolean isCurrent) {
        Rectangle rect = ro.getRectAtPage();
        int left = rect.x - BLOCK_WIDTH - 1;
        int right = rect.x + rect.width;
        int center = (right - left) / 2 + left;
        int top = rect.y - BLOCK_WIDTH - 1;
        int bottom = rect.y + rect.height;
        int middle = (bottom - top) / 2 + top;
        boolean isLocked = ro.isLocked();
        if (ro instanceof IR1Page) {
            this.drawCrossBlock(g, left, top, isCurrent, true);
            this.drawBlock(g, right, top, isCurrent, true);
            this.drawBlock(g, center, top, isCurrent, true);
            this.drawBlock(g, left, middle, isCurrent, true);
            this.drawBlock(g, left, bottom, isCurrent, true);
            this.drawBlock(g, center, bottom, isCurrent, isLocked);
            this.drawBlock(g, right, middle, isCurrent, isLocked);
            this.drawBlock(g, right, bottom, isCurrent, isLocked);
        } else {
            boolean isHUnresizable = !ro.isHorizontalResizable();
            boolean isVUnresizable = !ro.isVerticalResizable();
            boolean isHFill = ro.isHorizontalFill();
            boolean isVFill = ro.isVerticalFill();
            this.drawCrossBlock(g, left, top, isCurrent, isLocked || isHFill && isVFill);
            boolean angle = isLocked || isVUnresizable || isHUnresizable || isHFill || isVFill;
            this.drawBlock(g, right, top, isCurrent, angle);
            this.drawBlock(g, left, bottom, isCurrent, angle);
            this.drawBlock(g, right, bottom, isCurrent, angle);
            boolean up_down = isLocked || isVUnresizable || isVFill;
            this.drawBlock(g, center, top, isCurrent, up_down);
            this.drawBlock(g, center, bottom, isCurrent, up_down);
            boolean left_right = isLocked || isHUnresizable || isHFill;
            this.drawBlock(g, left, middle, isCurrent, left_right);
            this.drawBlock(g, right, middle, isCurrent, left_right);
        }
    }

    private void drawBlock(Graphics g, int x, int y, boolean isCurrent, boolean isLocked) {
        Color oriColor = g.getColor();
        if (isCurrent) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(isLocked ? Color.GRAY : Color.BLUE);
        }
        g.fillRect(x, y, BLOCK_WIDTH, BLOCK_WIDTH);
        if (isCurrent) {
            g.setColor(isLocked ? Color.GRAY : Color.BLUE);
        } else {
            g.setColor(Color.WHITE);
        }
        g.drawRect(x, y, BLOCK_WIDTH, BLOCK_WIDTH);
        g.setColor(oriColor);
    }

    private void drawCrossBlock(Graphics g, int x, int y, boolean isCurrent, boolean isLocked) {
        this.drawBlock(g, x, y, isCurrent, isLocked);
        Color oriColor = g.getColor();
        if (isCurrent && !isLocked) {
            g.setColor(Color.BLUE);
            g.drawLine(x + HALF_BLOCK_WIDTH, y, x + HALF_BLOCK_WIDTH, y + BLOCK_WIDTH);
            g.drawLine(x, y + HALF_BLOCK_WIDTH, x + BLOCK_WIDTH, y + HALF_BLOCK_WIDTH);
        }
        g.setColor(oriColor);
    }

    public static int getDirectionByPoint(IReportObject ro, Point ptAtPage) {
        boolean isSouth;
        boolean isRangeOfHorizontal;
        Rectangle rect = ro.getRectAtPage();
        int left = rect.x - BLOCK_WIDTH - 1;
        int right = rect.x + rect.width;
        int center = (right - left) / 2 + left;
        int top = rect.y - BLOCK_WIDTH - 1;
        int bottom = rect.y + rect.height;
        int middle = (bottom - top) / 2 + top;
        int result = -1;
        boolean isRangeOfVertical = ptAtPage.y >= top && ptAtPage.y <= bottom + BLOCK_WIDTH;
        boolean bl = isRangeOfHorizontal = ptAtPage.x >= left && ptAtPage.x <= right + BLOCK_WIDTH;
        if (!isRangeOfHorizontal || !isRangeOfVertical) {
            return result;
        }
        boolean isWest = ptAtPage.x >= left && ptAtPage.x <= rect.x;
        boolean isCenter = ptAtPage.x >= center && ptAtPage.x <= center + BLOCK_WIDTH;
        boolean isEast = ptAtPage.x >= right && ptAtPage.x <= right + BLOCK_WIDTH;
        boolean isNorth = ptAtPage.y >= top && ptAtPage.y <= rect.y;
        boolean isMiddle = ptAtPage.y >= middle && ptAtPage.y <= middle + BLOCK_WIDTH;
        boolean bl2 = isSouth = ptAtPage.y >= bottom && ptAtPage.y <= bottom + BLOCK_WIDTH;
        if (isWest) {
            result = 2;
            result += isNorth ? 8 : (isSouth ? 4 : (isMiddle ? 0 : -2));
        } else if (isEast && isRangeOfVertical) {
            result = 1;
            result += isNorth ? 8 : (isSouth ? 4 : (isMiddle ? 0 : -1));
        } else if (isCenter) {
            result = isNorth ? 8 : (isSouth ? 4 : -1);
        } else if (isNorth || isSouth) {
            result = 0;
        }
        return result;
    }
}

