/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IPropertyUnsupported;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;

public class PanelGeneral
extends AbstractPropertyPanel {
    public static String NoPrint = "NoPrint";
    public static String NoHide = "NoHide";
    public static String NoEnable = "NoEnable";
    private KDTextField txtGeneralName;
    private KDCheckBox cbHide;
    private KDCheckBox cbLock;
    private KDCheckBox cbPrint;
    private KDCheckBox cbForbidden;
    private boolean isMultiSelected;
    private ComboPanel core;
    private List existIds;

    public PanelGeneral() {
        this.init();
        this.installListener();
    }

    private void init() {
        this.cbHide = new KDCheckBox();
        this.cbLock = new KDCheckBox();
        this.cbPrint = new KDCheckBox();
        this.cbForbidden = new KDCheckBox();
        this.txtGeneralName = new KDTextField();
        this.cbLock.setText(MultiLanguageUtil.getMLS("lock", ""));
        this.cbHide.setText(MultiLanguageUtil.getMLS("hide", ""));
        this.cbPrint.setText(MultiLanguageUtil.getMLS("print", ""));
        this.cbForbidden.setText(MultiLanguageUtil.getMLS("forbiddenState", ""));
        this.cbHide.setSwitch(false);
        this.cbLock.setSwitch(false);
        this.cbPrint.setSwitch(false);
        this.cbForbidden.setSwitch(false);
        KDLabelContainer setGereralName = new KDLabelContainer((JComponent)this.txtGeneralName);
        setGereralName.setBoundLabelUnderline(true);
        setGereralName.setBoundLabelText(MultiLanguageUtil.getMLS("name", ""));
        setGereralName.setBoundLabelLength(80);
        TableLayout tl = TableLayout.split((int)7, (int)2);
        tl.style().setMargin(10, 2, 2, 2);
        tl.rowStyle(0).setMargin(10, 10, 10, 0);
        tl.rowStyle(0).setHeight(19);
        tl.rowStyle(1).setHeight(8);
        tl.rowStyle(6).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)setGereralName, tl.cell(0, 0));
        this.add((Component)this.cbLock, tl.cell(2, 0));
        this.add((Component)this.cbHide, tl.cell(3, 0));
        this.add((Component)this.cbPrint, tl.cell(4, 0));
        this.add((Component)this.cbForbidden, tl.cell(5, 0));
    }

    private void installListener() {
    }

    public boolean isHideSelected() {
        return this.cbHide.isSelected();
    }

    public boolean isLockSelected() {
        return this.cbLock.isSelected();
    }

    public boolean isPrint() {
        return this.cbPrint.isSelected();
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        String newId;
        String oldId;
        IElement ele = (IElement)elePath.getLastPathComponent();
        if (!this.isMultiSelected && !StringUtil.equalsIgnoreCase((String)(oldId = ele.getId()), (String)(newId = this.txtGeneralName.getText()))) {
            ele.setId(newId);
            this.core.getModel().fireRenameEvent(elePath, oldId, newId);
        }
        if (this.cbHide.getSelectState() != 64) {
            ele.setHide(this.cbHide.isSelected());
        }
        if (ele instanceof IReportObject) {
            IReportObject ro = (IReportObject)ele;
            if (this.cbLock.getSelectState() != 64) {
                ro.setLocked(this.cbLock.isSelected());
            }
            if (this.cbPrint.getSelectState() != 64) {
                ro.setPrint(this.cbPrint.isSelected());
            }
            if (this.cbForbidden.getSelectState() != 64) {
                ro.setDisabled(this.cbForbidden.isSelected());
            }
        }
    }

    @Override
    public String getTitle() {
        return MultiLanguageUtil.getMLS("general", "");
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eps) {
        this.core = core;
        IElement ele = (IElement)eps[0].getLastPathComponent();
        this.existIds = core.getModel().getExistIds(ele);
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eps) {
        IPropertyUnsupported ps;
        List list;
        IElement ele = (IElement)eps[0].getLastPathComponent();
        this.txtGeneralName.setText(ele.getId());
        if (eps.length > 1) {
            this.isMultiSelected = true;
            this.txtGeneralName.setEnabled(false);
        } else {
            this.isMultiSelected = false;
            this.txtGeneralName.setEnabled(true);
        }
        boolean isHide = ele.isHide();
        boolean isHideUnsure = false;
        for (int i = 1; i < eps.length; ++i) {
            ele = (IElement)eps[i].getLastPathComponent();
            if (isHideUnsure || isHide == ele.isHide()) continue;
            isHideUnsure = true;
        }
        if (isHideUnsure) {
            this.cbHide.setSelectState(64);
        } else {
            this.cbHide.setSelected(isHide);
        }
        if (!(ele instanceof IReportObject)) {
            IPropertyUnsupported ps2;
            List list2;
            this.cbLock.setSelected(false);
            this.cbPrint.setSelected(false);
            this.cbForbidden.setSelected(false);
            this.cbLock.setEnabled(false);
            this.cbPrint.setEnabled(false);
            this.cbForbidden.setEnabled(false);
            if (ele instanceof IPropertyUnsupported && (list2 = (ps2 = (IPropertyUnsupported)((Object)ele)).getUnsupportedPropertyKeys()) != null) {
                if (list2.contains(NoPrint)) {
                    this.cbPrint.setEnabled(false);
                }
                if (list2.contains(NoEnable)) {
                    this.cbForbidden.setEnabled(false);
                }
                if (list2.contains(NoHide)) {
                    this.cbHide.setEnabled(false);
                }
            }
            return;
        }
        this.cbLock.setEnabled(true);
        this.cbPrint.setEnabled(true);
        this.cbForbidden.setEnabled(true);
        if (ele instanceof IPropertyUnsupported && (list = (ps = (IPropertyUnsupported)((Object)ele)).getUnsupportedPropertyKeys()) != null) {
            if (list.contains(NoPrint)) {
                this.cbPrint.setEnabled(false);
            }
            if (list.contains(NoEnable)) {
                this.cbForbidden.setEnabled(false);
            }
            if (list.contains(NoHide)) {
                this.cbHide.setEnabled(false);
            }
        }
        IReportObject ro = (IReportObject)ele;
        boolean isLock = ro.isLocked();
        boolean isPrint = ro.isPrint();
        boolean isForbiden = ro.isDisabled();
        boolean isLockUnsure = false;
        boolean isPrintUnsure = false;
        boolean isForbidenUnsure = false;
        for (int i = 1; i < eps.length; ++i) {
            ro = (IReportObject)eps[i].getLastPathComponent();
            if (!isLockUnsure && isLock != ro.isLocked()) {
                isLockUnsure = true;
            }
            if (!isPrintUnsure && isPrint != ro.isPrint()) {
                isPrintUnsure = true;
            }
            if (isForbidenUnsure || isForbiden == ro.isDisabled()) continue;
            isForbidenUnsure = true;
        }
        if (isLockUnsure) {
            this.cbLock.setSelectState(64);
        } else {
            this.cbLock.setSelected(isLock);
        }
        if (isPrintUnsure) {
            this.cbPrint.setSelectState(64);
        } else {
            this.cbPrint.setSelected(isPrint);
        }
        if (isForbidenUnsure) {
            this.cbForbidden.setSelectState(64);
        } else {
            this.cbForbidden.setSelected(isForbiden);
        }
    }

    @Override
    public boolean verify() {
        int max = 32;
        String newId = this.txtGeneralName.getText();
        if (!StringUtil.isEnglishString((String)newId)) {
            WindowUtil.msgboxError((Object)"", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (newId.length() > max) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("outOf32", ""), (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (this.existIds.contains(newId)) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("nameReInput", ""), (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (StringUtil.isEmptyString((String)newId)) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("noNullName", ""), (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }
}

